/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.pockets;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1263;
import net.minecraft.class_173;
import net.minecraft.class_181;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2595;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_47;
import net.minecraft.class_52;
import net.minecraft.class_5281;
import org.apache.logging.log4j.Logger;
import org.dimdev.dimdoors.DimensionalDoorsInitializer;
import org.dimdev.dimdoors.api.util.Location;
import org.dimdev.dimdoors.api.util.math.MathUtil;
import org.dimdev.dimdoors.block.entity.EntranceRiftBlockEntity;
import org.dimdev.dimdoors.block.entity.RiftBlockEntity;
import org.dimdev.dimdoors.entity.ModEntityTypes;
import org.dimdev.dimdoors.entity.MonolithEntity;
import org.dimdev.dimdoors.pockets.DefaultDungeonDestinations;
import org.dimdev.dimdoors.rift.registry.LinkProperties;
import org.dimdev.dimdoors.rift.targets.PocketEntranceMarker;
import org.dimdev.dimdoors.rift.targets.PocketExitMarker;
import org.dimdev.dimdoors.rift.targets.VirtualTarget;
import org.dimdev.dimdoors.util.schematic.Schematic;
import org.dimdev.dimdoors.world.level.registry.DimensionalRegistry;
import org.dimdev.dimdoors.world.pocket.type.Pocket;

public class TemplateUtils {
    static void setupEntityPlaceholders(List<class_2487> entities, class_2487 entityTag) {
        if (entityTag.method_10545("placeholder")) {
            double x = entityTag.method_10574("x");
            double y = entityTag.method_10574("y");
            double z = entityTag.method_10574("z");
            float yaw = entityTag.method_10583("yaw");
            float pitch = entityTag.method_10583("pitch");
            if (!"monolith".equals(entityTag.method_10558("placeholder"))) {
                throw new RuntimeException("Unknown entity placeholder: " + entityTag.method_10558("placeholder"));
            }
            MonolithEntity monolith = Objects.requireNonNull((MonolithEntity)ModEntityTypes.MONOLITH.method_5883(null));
            monolith.method_23327(x, y, z);
            monolith.method_36456(yaw);
            monolith.method_36457(pitch);
            class_2487 newTag = monolith.method_5647(new class_2487());
            entities.add(newTag);
        } else {
            entities.add(entityTag);
        }
    }

    public static void setupLootTable(class_3218 world, class_2586 tile, class_1263 inventory, Logger logger) {
        class_52 table;
        if (tile instanceof class_2595) {
            logger.debug("Now populating chest.");
            table = world.method_8503().method_3857().method_367(new class_2960("dimdoors:dungeon_chest"));
        } else {
            logger.debug("Now populating dispenser.");
            table = world.method_8503().method_3857().method_367(new class_2960("dimdoors:dispenser_projectiles"));
        }
        class_47 ctx = new class_47.class_48(world).method_311(world.field_9229).method_312(class_181.field_24424, (Object)class_243.method_24954((class_2382)tile.method_11016())).method_309(class_173.field_1179);
        table.method_329(inventory, ctx);
        if (inventory.method_5442()) {
            logger.error(", however Inventory is: empty!");
        }
    }

    public static void registerRifts(List<? extends RiftBlockEntity> rifts, VirtualTarget linkTo, LinkProperties linkProperties, Pocket pocket) {
        VirtualTarget dest;
        class_3218 world = DimensionalDoorsInitializer.getWorld(pocket.getWorld());
        HashMap<RiftBlockEntity, Float> entranceWeights = new HashMap<RiftBlockEntity, Float>();
        for (RiftBlockEntity riftBlockEntity : rifts) {
            if (!(riftBlockEntity.getDestination() instanceof PocketEntranceMarker)) continue;
            entranceWeights.put(riftBlockEntity, Float.valueOf(((PocketEntranceMarker)riftBlockEntity.getDestination()).getWeight()));
        }
        if (entranceWeights.size() == 0) {
            return;
        }
        RiftBlockEntity selectedEntrance = (RiftBlockEntity)MathUtil.weightedRandom(entranceWeights);
        for (RiftBlockEntity riftBlockEntity : rifts) {
            dest = riftBlockEntity.getDestination();
            if (!(dest instanceof PocketEntranceMarker)) continue;
            if (riftBlockEntity == selectedEntrance) {
                riftBlockEntity.setDestination(((PocketEntranceMarker)dest).getIfDestination());
                riftBlockEntity.register();
                DimensionalRegistry.getRiftRegistry().addPocketEntrance(pocket, new Location((class_3218)riftBlockEntity.method_10997(), riftBlockEntity.method_11016()));
                continue;
            }
            riftBlockEntity.setDestination(((PocketEntranceMarker)dest).getOtherwiseDestination());
        }
        for (RiftBlockEntity riftBlockEntity : rifts) {
            dest = riftBlockEntity.getDestination();
            if (!(dest instanceof PocketExitMarker)) continue;
            if (linkProperties != null) {
                riftBlockEntity.setProperties(linkProperties);
            }
            riftBlockEntity.setDestination(riftBlockEntity.getProperties() == null || !riftBlockEntity.getProperties().isOneWay() ? linkTo : null);
        }
        for (RiftBlockEntity riftBlockEntity : rifts) {
            riftBlockEntity.register();
            riftBlockEntity.method_5431();
        }
    }

    public static void replacePlaceholders(Schematic schematic, class_5281 world) {
        ArrayList<class_2487> blockEntities = new ArrayList<class_2487>();
        for (class_2487 blockEntityTag : schematic.getBlockEntities()) {
            if (blockEntityTag.method_10545("placeholder")) {
                int x = blockEntityTag.method_10550("x");
                int y = blockEntityTag.method_10550("y");
                int z = blockEntityTag.method_10550("z");
                class_2338 pos = new class_2338(x, y, z);
                class_2487 newTag = new class_2487();
                EntranceRiftBlockEntity rift = new EntranceRiftBlockEntity(pos, Schematic.getBlockSample(schematic).method_8320(pos));
                switch (blockEntityTag.method_10558("placeholder")) {
                    case "deeper_depth_door": {
                        rift.setProperties(DefaultDungeonDestinations.POCKET_LINK_PROPERTIES);
                        rift.setDestination(DefaultDungeonDestinations.getDeeperDungeonDestination());
                        rift.method_11007(newTag);
                        break;
                    }
                    case "less_deep_depth_door": {
                        rift.setProperties(DefaultDungeonDestinations.POCKET_LINK_PROPERTIES);
                        rift.setDestination(DefaultDungeonDestinations.getShallowerDungeonDestination());
                        rift.method_11007(newTag);
                        break;
                    }
                    case "overworld_door": {
                        rift.setProperties(DefaultDungeonDestinations.POCKET_LINK_PROPERTIES);
                        rift.setDestination(DefaultDungeonDestinations.getOverworldDestination());
                        rift.method_11007(newTag);
                        break;
                    }
                    case "entrance_door": {
                        rift.setProperties(DefaultDungeonDestinations.POCKET_LINK_PROPERTIES);
                        rift.setDestination(DefaultDungeonDestinations.getTwoWayPocketEntrance());
                        rift.method_11007(newTag);
                        break;
                    }
                    case "gateway_portal": {
                        rift.setProperties(DefaultDungeonDestinations.OVERWORLD_LINK_PROPERTIES);
                        rift.setDestination(DefaultDungeonDestinations.getGateway());
                        rift.method_11007(newTag);
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unknown block entity placeholder: " + blockEntityTag.method_10558("placeholder"));
                    }
                }
                rift.method_31662((class_1937)world.method_8410());
                blockEntities.add(newTag);
                continue;
            }
            blockEntities.add(blockEntityTag);
        }
        schematic.setBlockEntities(blockEntities);
        ArrayList<class_2487> entities = new ArrayList<class_2487>();
        for (class_2487 entityTag : schematic.getEntities()) {
            TemplateUtils.setupEntityPlaceholders(entities, entityTag);
        }
        schematic.setEntities((List<class_2487>)entities);
    }
}

