/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.particle.client;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2378;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2540;
import org.dimdev.dimdoors.particle.ModParticleTypes;

public class RiftParticleEffect
implements class_2394 {
    private static final RiftParticleEffect OUTSIDE = new RiftParticleEffect(0.4f, 2000);
    private static final RiftParticleEffect INSIDE = new RiftParticleEffect(0.8f, 2000);
    private static final RiftParticleEffect OUTSIDE_UNSTABLE = new RiftParticleEffect(0.0f, 2000);
    private static final RiftParticleEffect INSIDE_UNSTABLE = new RiftParticleEffect(0.7f, 2000);
    private static final RiftParticleEffect OUTSIDE_STABLE = new RiftParticleEffect(0.0f, 750);
    private static final RiftParticleEffect INSIDE_STABLE = new RiftParticleEffect(0.7f, 750);
    public static final Codec<RiftParticleEffect> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("color").forGetter(riftParticleEffect -> Float.valueOf(riftParticleEffect.color)), (App)Codec.INT.fieldOf("averageAge").forGetter(riftParticleEffect -> riftParticleEffect.averageAge)).apply((Applicative)instance, RiftParticleEffect::new));
    public static final class_2394.class_2395<RiftParticleEffect> PARAMETERS_FACTORY = new class_2394.class_2395<RiftParticleEffect>(){

        public RiftParticleEffect read(class_2396<RiftParticleEffect> particleType, StringReader stringReader) throws CommandSyntaxException {
            stringReader.expect(' ');
            float f = stringReader.readFloat();
            stringReader.expect(' ');
            int g = stringReader.readInt();
            return new RiftParticleEffect(f, g);
        }

        public RiftParticleEffect read(class_2396<RiftParticleEffect> particleType, class_2540 packetByteBuf) {
            return new RiftParticleEffect(packetByteBuf.readFloat(), packetByteBuf.readInt());
        }
    };
    private final float color;
    private final int averageAge;

    public static RiftParticleEffect of(boolean isOutsidePocket) {
        return isOutsidePocket ? OUTSIDE : INSIDE;
    }

    public static RiftParticleEffect of(boolean isOutsidePocket, boolean stablized) {
        if (isOutsidePocket) {
            if (stablized) {
                return OUTSIDE_STABLE;
            }
            return OUTSIDE_UNSTABLE;
        }
        if (stablized) {
            return INSIDE_STABLE;
        }
        return INSIDE_UNSTABLE;
    }

    public RiftParticleEffect(float color, int averageAge) {
        this.color = color;
        this.averageAge = averageAge;
    }

    public void method_10294(class_2540 buf) {
        buf.writeFloat(this.color);
        buf.writeInt(this.averageAge);
    }

    public String method_10293() {
        return String.format(Locale.ROOT, "%s %.2f %s", class_2378.field_11141.method_10221(this.method_10295()), Float.valueOf(this.color), this.averageAge);
    }

    public class_2396<RiftParticleEffect> method_10295() {
        return ModParticleTypes.RIFT;
    }

    @Environment(value=EnvType.CLIENT)
    public float getColor() {
        return this.color;
    }

    @Environment(value=EnvType.CLIENT)
    public int getAverageAge() {
        return this.averageAge;
    }
}

