/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.network.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5321;
import net.minecraft.class_634;
import net.minecraft.class_703;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dimdev.dimdoors.client.CustomBreakBlockHandler;
import org.dimdev.dimdoors.entity.MonolithEntity;
import org.dimdev.dimdoors.mixin.client.accessor.WorldRendererAccessor;
import org.dimdev.dimdoors.network.SimplePacket;
import org.dimdev.dimdoors.network.client.ClientPacketListener;
import org.dimdev.dimdoors.network.packet.c2s.NetworkHandlerInitializedC2SPacket;
import org.dimdev.dimdoors.network.packet.s2c.MonolithAggroParticlesPacket;
import org.dimdev.dimdoors.network.packet.s2c.MonolithTeleportParticlesPacket;
import org.dimdev.dimdoors.network.packet.s2c.PlayerInventorySlotUpdateS2CPacket;
import org.dimdev.dimdoors.network.packet.s2c.RenderBreakBlockS2CPacket;
import org.dimdev.dimdoors.network.packet.s2c.SyncPocketAddonsS2CPacket;
import org.dimdev.dimdoors.particle.client.MonolithParticle;
import org.dimdev.dimdoors.world.pocket.type.addon.AutoSyncedAddon;

@Environment(value=EnvType.CLIENT)
public class ClientPacketHandler
implements ClientPacketListener {
    private static final Logger LOGGER = LogManager.getLogger();
    private final class_634 networkHandler;
    private boolean initialized = false;
    private final Set<class_2960> registeredChannels = new HashSet<class_2960>();
    private class_5321<class_1937> pocketWorld;
    private int gridSize = 1;
    private int pocketId = Integer.MIN_VALUE;
    private int pocketRange = 1;
    private List<AutoSyncedAddon> addons = new ArrayList<AutoSyncedAddon>();

    public void init() {
        if (this.initialized) {
            throw new RuntimeException("ClientPacketHandler has already been initialized.");
        }
        this.initialized = true;
        this.registerReceiver(PlayerInventorySlotUpdateS2CPacket.ID, PlayerInventorySlotUpdateS2CPacket::new);
        this.registerReceiver(SyncPocketAddonsS2CPacket.ID, SyncPocketAddonsS2CPacket::new);
        this.registerReceiver(MonolithAggroParticlesPacket.ID, MonolithAggroParticlesPacket::new);
        this.registerReceiver(MonolithTeleportParticlesPacket.ID, MonolithTeleportParticlesPacket::new);
        this.registerReceiver(RenderBreakBlockS2CPacket.ID, RenderBreakBlockS2CPacket::new);
        ClientPacketHandler.sendPacket(new NetworkHandlerInitializedC2SPacket());
    }

    public static boolean sendPacket(SimplePacket<?> packet) {
        try {
            ClientPlayNetworking.send((class_2960)packet.channelId(), (class_2540)packet.write(PacketByteBufs.create()));
            return true;
        }
        catch (IOException e) {
            LOGGER.error((Object)e);
            return false;
        }
    }

    public ClientPacketHandler(class_634 networkHandler) {
        this.networkHandler = networkHandler;
    }

    private void registerReceiver(class_2960 channelName, Supplier<? extends SimplePacket<ClientPacketListener>> supplier) {
        ClientPlayNetworking.registerReceiver((class_2960)channelName, (client, handler, buf, responseSender) -> {
            try {
                ((SimplePacket)supplier.get()).read(buf).apply(this);
            }
            catch (IOException e) {
                LOGGER.error((Object)e);
            }
        });
        this.registeredChannels.add(channelName);
    }

    private void unregisterReceiver(class_2960 channelName) {
        ClientPlayNetworking.unregisterReceiver((class_2960)channelName);
        this.registeredChannels.remove(channelName);
    }

    public void unregister() {
        new HashSet<class_2960>(this.registeredChannels).forEach(this::unregisterReceiver);
    }

    public class_5321<class_1937> getPocketWorld() {
        return this.pocketWorld;
    }

    public int getGridSize() {
        return this.gridSize;
    }

    public int getPocketId() {
        return this.pocketId;
    }

    public int getPocketRange() {
        return this.pocketRange;
    }

    public List<AutoSyncedAddon> getAddons() {
        return this.addons;
    }

    @Override
    public void onPlayerInventorySlotUpdate(PlayerInventorySlotUpdateS2CPacket packet) {
        class_310.method_1551().execute(() -> {
            if (class_310.method_1551().field_1724 != null) {
                class_310.method_1551().field_1724.method_31548().method_5447(packet.getSlot(), packet.getStack());
            }
        });
    }

    @Override
    public void onSyncPocketAddons(SyncPocketAddonsS2CPacket packet) {
        this.pocketWorld = packet.getWorld();
        this.gridSize = packet.getGridSize();
        this.pocketId = packet.getPocketId();
        this.pocketRange = packet.getPocketRange();
        this.addons = packet.getAddons();
    }

    @Override
    public void onMonolithAggroParticles(MonolithAggroParticlesPacket packet) {
        class_310.method_1551().execute(() -> MonolithEntity.spawnParticles(packet.getAggro()));
    }

    @Override
    public void onMonolithTeleportParticles(MonolithTeleportParticlesPacket packet) {
        class_310 client = class_310.method_1551();
        client.execute(() -> client.field_1713.method_3058((class_703)new MonolithParticle(client.field_1687, client.field_1724.method_23317(), client.field_1724.method_23318(), client.field_1724.method_23321())));
    }

    @Override
    public void onRenderBreakBlock(RenderBreakBlockS2CPacket packet) {
        CustomBreakBlockHandler.customBreakBlock(packet.getPos(), packet.getStage(), ((WorldRendererAccessor)class_310.method_1551().field_1769).getTicks());
    }
}

