/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.item;

import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_5321;
import org.dimdev.dimdoors.DimensionalDoorsInitializer;
import org.dimdev.dimdoors.api.util.Location;
import org.dimdev.dimdoors.api.util.RotatedLocation;
import org.dimdev.dimdoors.block.ModBlocks;
import org.dimdev.dimdoors.block.entity.DetachedRiftBlockEntity;
import org.dimdev.dimdoors.client.ToolTipHelper;
import org.dimdev.dimdoors.rift.targets.RiftReference;
import org.dimdev.dimdoors.sound.ModSoundEvents;
import org.dimdev.dimdoors.world.ModDimensions;
import org.jetbrains.annotations.NotNull;

public class RiftSignatureItem
extends class_1792 {
    public static final String ID = "rift_signature";

    public RiftSignatureItem(class_1792.class_1793 settings) {
        super(settings);
    }

    public boolean method_7886(class_1799 stack) {
        return stack.method_7969() != null && stack.method_7969().method_10545("destination");
    }

    public class_1269 method_7884(@NotNull class_1838 itemUsageContext) {
        class_1657 player = itemUsageContext.method_8036();
        class_1937 world = itemUsageContext.method_8045();
        class_2338 pos = itemUsageContext.method_8037();
        class_1268 hand = itemUsageContext.method_20287();
        class_2350 side = itemUsageContext.method_8038();
        class_1750 placementContext = new class_1750(itemUsageContext);
        class_1799 stack = player.method_5998(hand);
        class_2338 class_23382 = pos = world.method_8320(pos).method_26204().method_9616(world.method_8320(pos), placementContext) ? pos : pos.method_10093(side);
        if (!player.method_7343(pos, side.method_10153(), stack)) {
            return class_1269.field_5814;
        }
        if (world.field_9236) {
            return class_1269.field_5812;
        }
        if (ModDimensions.isPrivatePocketDimension(world) && !DimensionalDoorsInitializer.getConfig().getPocketsConfig().canUseRiftSignatureInPrivatePockets) {
            player.method_7353((class_2561)new class_2588("tools.signature_blocked").method_27692(class_124.field_1074), true);
            return class_1269.field_5814;
        }
        RotatedLocation target = RiftSignatureItem.getSource(stack);
        if (target == null) {
            RiftSignatureItem.setSource(stack, new RotatedLocation((class_5321<class_1937>)world.method_27983(), pos, player.method_36454(), 0.0f));
            player.method_7353((class_2561)new class_2588(this.method_7876() + ".stored"), true);
            world.method_8396(null, player.method_24515(), ModSoundEvents.RIFT_START, class_3419.field_15245, 0.6f, 1.0f);
        } else {
            if (target.getBlockState().method_26204() != ModBlocks.DETACHED_RIFT) {
                if (!target.getBlockState().method_26204().method_9538()) {
                    player.method_7353((class_2561)new class_2588("tools.target_became_block"), true);
                    RiftSignatureItem.clearSource(stack);
                    return class_1269.field_5814;
                }
                class_3218 sourceWorld = DimensionalDoorsInitializer.getWorld((class_5321<class_1937>)target.world);
                sourceWorld.method_8501(target.getBlockPos(), ModBlocks.DETACHED_RIFT.method_9564());
                DetachedRiftBlockEntity rift1 = (DetachedRiftBlockEntity)target.getBlockEntity();
                rift1.setDestination(RiftReference.tryMakeRelative(target, new Location((class_3218)world, pos)));
                rift1.register();
            }
            world.method_8501(pos, ModBlocks.DETACHED_RIFT.method_9564());
            DetachedRiftBlockEntity rift2 = (DetachedRiftBlockEntity)world.method_8321(pos);
            rift2.setDestination(RiftReference.tryMakeRelative(new Location((class_3218)world, pos), target));
            rift2.register();
            stack.method_7956(1, (class_1309)player, a -> {});
            RiftSignatureItem.clearSource(stack);
            player.method_7353((class_2561)new class_2588(this.method_7876() + ".created"), true);
            world.method_8396(null, player.method_24515(), ModSoundEvents.RIFT_END, class_3419.field_15245, 0.6f, 1.0f);
        }
        return class_1269.field_5812;
    }

    public static void setSource(class_1799 itemStack, RotatedLocation destination) {
        if (!itemStack.method_7985()) {
            itemStack.method_7980(new class_2487());
        }
        itemStack.method_7969().method_10566("destination", (class_2520)RotatedLocation.serialize(destination));
    }

    public static void clearSource(class_1799 itemStack) {
        if (itemStack.method_7985()) {
            itemStack.method_7969().method_10551("destination");
        }
    }

    public static RotatedLocation getSource(class_1799 itemStack) {
        if (itemStack.method_7985() && itemStack.method_7969().method_10545("destination")) {
            return RotatedLocation.deserialize(itemStack.method_7969().method_10562("destination"));
        }
        return null;
    }

    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 itemStack, class_1937 world, List<class_2561> list, class_1836 tooltipContext) {
        RotatedLocation transform = RiftSignatureItem.getSource(itemStack);
        if (transform != null) {
            list.add((class_2561)new class_2588(this.method_7876() + ".bound.info0", new Object[]{transform.getX(), transform.getY(), transform.getZ(), transform.getWorldId().method_29177()}));
            list.add((class_2561)new class_2588(this.method_7876() + ".bound.info1", new Object[]{transform.getWorldId().method_29177()}));
        } else {
            ToolTipHelper.processTranslation(list, this.method_7876() + ".unbound.info", new Object[0]);
        }
    }
}

