/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.item;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.BuiltinItemRendererRegistry;
import net.fabricmc.fabric.api.event.registry.RegistryEntryAddedCallback;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1074;
import net.minecraft.class_1158;
import net.minecraft.class_1160;
import net.minecraft.class_1269;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1765;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2323;
import net.minecraft.class_2378;
import net.minecraft.class_2533;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_5321;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Triple;
import org.dimdev.dimdoors.DimensionalDoorsInitializer;
import org.dimdev.dimdoors.api.util.function.QuadFunction;
import org.dimdev.dimdoors.block.door.DimensionalDoorBlock;
import org.dimdev.dimdoors.block.door.DimensionalTrapdoorBlock;
import org.dimdev.dimdoors.block.door.data.DoorData;
import org.dimdev.dimdoors.block.entity.EntranceRiftBlockEntity;
import org.dimdev.dimdoors.client.UnderlaidChildItemRenderer;
import org.dimdev.dimdoors.item.DimensionalDoorItem;
import org.dimdev.dimdoors.item.DimensionalTrapdoorItem;
import org.dimdev.dimdoors.item.ItemExtensions;
import org.dimdev.dimdoors.item.ModItems;
import org.dimdev.dimdoors.listener.ItemRegistryEntryAddedListener;
import org.dimdev.dimdoors.rift.targets.PublicPocketTarget;

public class DimensionalDoorItemRegistrar {
    public static final String PREFIX = "item_ag_dim_";
    private final class_2378<class_1792> registry;
    private final Map<class_2248, class_2248> blocksAlreadyNotifiedAbout = new HashMap<class_2248, class_2248>();
    private final Map<class_2248, Triple<class_2960, class_1792, Function<class_2248, class_1747>>> toBeMapped = new HashMap<class_2248, Triple<class_2960, class_1792, Function<class_2248, class_1747>>>();
    private final Map<class_1792, Function<class_1750, class_1269>> placementFunctions = new HashMap<class_1792, Function<class_1750, class_1269>>();

    public DimensionalDoorItemRegistrar(class_2378<class_1792> registry) {
        this.registry = registry;
        this.init();
        RegistryEntryAddedCallback.event(registry).register((Object)new ItemRegistryEntryAddedListener(this));
    }

    public boolean isRegistered(class_1792 item) {
        return this.placementFunctions.containsKey(item);
    }

    public class_1269 place(class_1792 item, class_1750 context) {
        return this.placementFunctions.get(item).apply(context);
    }

    private void init() {
        new ArrayList<Map.Entry>(this.registry.method_29722()).forEach(entry -> this.handleEntry(((class_5321)entry.getKey()).method_29177(), (class_1792)entry.getValue()));
    }

    public void handleEntry(class_2960 identifier, class_1792 original) {
        if (DimensionalDoorsInitializer.getConfig().getDoorsConfig().isAllowed(identifier)) {
            if (original instanceof class_1765) {
                class_2248 block = ((class_1765)original).method_7711();
                this.handleEntry(identifier, original, block, AutoGenDimensionalDoorItem::new);
            } else if (original instanceof class_1747) {
                class_2248 originalBlock = ((class_1747)original).method_7711();
                if (originalBlock instanceof class_2323) {
                    this.handleEntry(identifier, original, originalBlock, AutoGenDimensionalDoorItem::new);
                } else {
                    this.handleEntry(identifier, original, originalBlock, AutoGenDimensionalTrapdoorItem::new);
                }
            }
        }
    }

    private void handleEntry(class_2960 identifier, class_1792 original, class_2248 originalBlock, QuadFunction<class_2248, class_1792.class_1793, Consumer<? super EntranceRiftBlockEntity>, class_1792, ? extends class_1747> constructor) {
        if (!(originalBlock instanceof DimensionalDoorBlock) && !(originalBlock instanceof DimensionalTrapdoorBlock) && (originalBlock instanceof class_2323 || originalBlock instanceof class_2533)) {
            class_1792.class_1793 settings = ItemExtensions.getSettings(original).method_7892(DoorData.PARENT_ITEMS.contains(original) || DoorData.PARENT_BLOCKS.contains(originalBlock) ? null : ModItems.DIMENSIONAL_DOORS);
            Function<class_2248, class_1747> dimItemConstructor = dimBlock -> (class_1747)constructor.apply((class_2248)dimBlock, settings, rift -> rift.setDestination(new PublicPocketTarget()), original);
            if (!this.blocksAlreadyNotifiedAbout.containsKey(originalBlock)) {
                this.toBeMapped.put(originalBlock, (Triple<class_2960, class_1792, Function<class_2248, class_1747>>)new ImmutableTriple((Object)identifier, (Object)original, dimItemConstructor));
                return;
            }
            this.register(identifier, original, this.blocksAlreadyNotifiedAbout.get(originalBlock), dimItemConstructor);
        }
    }

    public void notifyBlockMapped(class_2248 original, class_2248 dimBlock) {
        if (!this.toBeMapped.containsKey(original)) {
            this.blocksAlreadyNotifiedAbout.put(original, dimBlock);
            return;
        }
        Triple<class_2960, class_1792, Function<class_2248, class_1747>> triple = this.toBeMapped.get(original);
        this.register((class_2960)triple.getLeft(), (class_1792)triple.getMiddle(), dimBlock, (Function)triple.getRight());
    }

    private void register(class_2960 identifier, class_1792 original, class_2248 block, Function<class_2248, class_1747> dimItem) {
        if (!DoorData.PARENT_ITEMS.contains(original)) {
            class_2960 gennedId = new class_2960("dimdoors", PREFIX + identifier.method_12836() + "_" + identifier.method_12832());
            class_1747 item = (class_1747)class_2378.method_10230(this.registry, (class_2960)gennedId, (Object)dimItem.apply(block));
            this.placementFunctions.put(original, arg_0 -> ((class_1747)item).method_7712(arg_0));
            if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
                this.registerItemRenderer(item);
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    private void registerItemRenderer(class_1747 dimItem) {
        BuiltinItemRendererRegistry.INSTANCE.register((class_1935)dimItem, (BuiltinItemRendererRegistry.DynamicItemRenderer)Renderer.RENDERER);
    }

    @Environment(value=EnvType.CLIENT)
    private static interface Renderer {
        public static final UnderlaidChildItemRenderer RENDERER = new UnderlaidChildItemRenderer(class_1802.field_8634);
    }

    public static interface ChildItem {
        public class_1792 getOriginalItem();

        default public void transform(class_4587 matrices) {
        }
    }

    private static class AutoGenDimensionalTrapdoorItem
    extends DimensionalTrapdoorItem
    implements ChildItem {
        private final class_1792 originalItem;

        public AutoGenDimensionalTrapdoorItem(class_2248 block, class_1792.class_1793 settings, Consumer<? super EntranceRiftBlockEntity> setupFunction, class_1792 originalItem) {
            super(block, settings, setupFunction);
            this.originalItem = originalItem;
        }

        public class_2561 method_7864(class_1799 stack) {
            return new class_2588("dimdoors.autogen_item_prefix", new Object[]{class_1074.method_4662((String)this.originalItem.method_7876(), (Object[])new Object[0])});
        }

        public class_2561 method_7848() {
            return new class_2588("dimdoors.autogen_item_prefix", new Object[]{class_1074.method_4662((String)this.originalItem.method_7876(), (Object[])new Object[0])});
        }

        @Override
        public class_1792 getOriginalItem() {
            return this.originalItem;
        }

        @Override
        public void transform(class_4587 matrices) {
            matrices.method_22905(0.55f, 0.55f, 0.6f);
            matrices.method_22904(0.05, -0.05, 0.41);
            matrices.method_22907(class_1158.method_35823((class_1160)new class_1160(90.0f, 0.0f, 0.0f)));
        }
    }

    private static class AutoGenDimensionalDoorItem
    extends DimensionalDoorItem
    implements ChildItem {
        private final class_1792 originalItem;

        public AutoGenDimensionalDoorItem(class_2248 block, class_1792.class_1793 settings, Consumer<? super EntranceRiftBlockEntity> setupFunction, class_1792 originalItem) {
            super(block, settings, setupFunction);
            this.originalItem = originalItem;
        }

        public class_2561 method_7864(class_1799 stack) {
            return new class_2588("dimdoors.autogen_item_prefix", new Object[]{class_1074.method_4662((String)this.originalItem.method_7876(), (Object[])new Object[0])});
        }

        public class_2561 method_7848() {
            return new class_2588("dimdoors.autogen_item_prefix", new Object[]{class_1074.method_4662((String)this.originalItem.method_7876(), (Object[])new Object[0])});
        }

        @Override
        public class_1792 getOriginalItem() {
            return this.originalItem;
        }

        @Override
        public void transform(class_4587 matrices) {
            matrices.method_22905(0.68f, 0.68f, 1.0f);
            matrices.method_22904(0.05, 0.02, 0.0);
        }
    }
}

