/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.item;

import java.util.List;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1269;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2680;
import org.dimdev.dimdoors.DimensionalDoorsInitializer;
import org.dimdev.dimdoors.block.ModBlocks;
import org.dimdev.dimdoors.block.RiftProvider;
import org.dimdev.dimdoors.block.entity.DetachedRiftBlockEntity;
import org.dimdev.dimdoors.block.entity.EntranceRiftBlockEntity;
import org.dimdev.dimdoors.block.entity.RiftBlockEntity;
import org.dimdev.dimdoors.client.ToolTipHelper;

public class DimensionalDoorItem
extends class_1747 {
    private final Consumer<? super EntranceRiftBlockEntity> setupFunction;
    private boolean hasToolTip = false;

    public DimensionalDoorItem(class_2248 block, class_1792.class_1793 settings, Consumer<? super EntranceRiftBlockEntity> setupFunction) {
        this(block, settings, setupFunction, false);
    }

    public DimensionalDoorItem(class_2248 block, class_1792.class_1793 settings, Consumer<? super EntranceRiftBlockEntity> setupFunction, boolean hasToolTip) {
        super(block, settings);
        this.setupFunction = setupFunction;
        this.hasToolTip = hasToolTip;
    }

    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 itemStack, class_1937 world, List<class_2561> list, class_1836 tooltipContext) {
        if (this.hasToolTip) {
            ToolTipHelper.processTranslation(list, this.method_7876() + ".info", new Object[0]);
        }
    }

    public class_1269 method_7712(class_1750 context) {
        class_1269 result;
        boolean placedOnRift;
        class_2338 pos = context.method_8037();
        if (!context.method_8045().method_8320(pos).method_26166(context)) {
            pos = pos.method_10093(context.method_8042());
        }
        boolean bl = placedOnRift = context.method_8045().method_8320(pos).method_26204() == ModBlocks.DETACHED_RIFT;
        if (!placedOnRift && !context.method_8036().method_5715() && DimensionalDoorItem.isRiftNear(context.method_8045(), pos)) {
            if (context.method_8045().field_9236) {
                context.method_8036().method_7353((class_2561)new class_2588("rifts.entrances.rift_too_close"), true);
                RiftBlockEntity.showRiftCoreUntil = System.currentTimeMillis() + (long)DimensionalDoorsInitializer.getConfig().getGraphicsConfig().highlightRiftCoreFor;
            }
            return class_1269.field_5814;
        }
        if (context.method_8045().field_9236) {
            return super.method_7712(context);
        }
        DetachedRiftBlockEntity rift = null;
        if (placedOnRift) {
            rift = (DetachedRiftBlockEntity)context.method_8045().method_8321(pos);
            rift.setUnregisterDisabled(true);
        }
        if ((result = super.method_7712(context)) == class_1269.field_5812 || result == class_1269.field_21466) {
            class_2680 state = context.method_8045().method_8320(pos);
            if (rift == null) {
                EntranceRiftBlockEntity entranceRift = (EntranceRiftBlockEntity)((RiftProvider)state.method_26204()).getRift(context.method_8045(), pos, state);
                this.setupRift(entranceRift);
                entranceRift.method_5431();
                entranceRift.register();
            } else {
                EntranceRiftBlockEntity newRift = (EntranceRiftBlockEntity)context.method_8045().method_8321(pos);
                newRift.copyFrom(rift);
                newRift.updateType();
            }
        } else if (rift != null) {
            rift.setUnregisterDisabled(false);
        }
        return result;
    }

    public static boolean isRiftNear(class_1937 world, class_2338 pos) {
        for (int x = pos.method_10263() - 5; x < pos.method_10263() + 5; ++x) {
            for (int y = pos.method_10264() - 5; y < pos.method_10264() + 5; ++y) {
                for (int z = pos.method_10260() - 5; z < pos.method_10260() + 5; ++z) {
                    class_2338 searchPos = new class_2338(x, y, z);
                    if (world.method_8320(searchPos).method_26204() != ModBlocks.DETACHED_RIFT) continue;
                    DetachedRiftBlockEntity rift = (DetachedRiftBlockEntity)world.method_8321(searchPos);
                    if (!(Math.sqrt(pos.method_10262((class_2382)searchPos)) < (double)rift.size)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void setupRift(EntranceRiftBlockEntity entranceRift) {
        this.setupFunction.accept(entranceRift);
    }
}

