/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.entity;

import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1313;
import net.minecraft.class_1333;
import net.minecraft.class_1352;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_310;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_746;
import org.dimdev.dimdoors.DimensionalDoorsInitializer;
import org.dimdev.dimdoors.entity.ModEntityTypes;
import org.dimdev.dimdoors.entity.ai.MonolithAggroGoal;
import org.dimdev.dimdoors.item.ModItems;
import org.dimdev.dimdoors.sound.ModSoundEvents;
import org.dimdev.dimdoors.world.ModDimensions;

public class MonolithEntity
extends class_1308 {
    public static final int MAX_AGGRO = 250;
    private static final int MAX_AGGRO_CAP = 100;
    private static final int MIN_AGGRO_CAP = 25;
    private static final int MAX_TEXTURE_STATE = 18;
    private static final int MAX_SOUND_COOLDOWN = 200;
    public static final int MAX_AGGRO_RANGE = 35;
    private static final class_2940<Integer> AGGRO = class_2945.method_12791(MonolithEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Float> SCALE = class_2945.method_12791(MonolithEntity.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Float> PITCH = class_2945.method_12791(MonolithEntity.class, (class_2941)class_2943.field_13320);
    private static final float EYE_HEIGHT_PERCENTAGE = 0.55f;
    @Environment(value=EnvType.CLIENT)
    private static final Random clientRandom = new Random();
    private int soundTime = 0;
    private final int aggroCap;

    MonolithEntity(class_1937 world) {
        this(ModEntityTypes.MONOLITH, world);
    }

    public MonolithEntity(class_1299<? extends MonolithEntity> type, class_1937 world) {
        super(ModEntityTypes.MONOLITH, world);
        this.field_5960 = true;
        this.aggroCap = class_3532.method_15395((Random)this.method_6051(), (int)25, (int)100);
        this.method_5875(true);
        this.field_6206 = new class_1333(this){

            protected boolean method_20433() {
                return false;
            }
        };
        this.method_5684(true);
    }

    public boolean isDangerous() {
        return DimensionalDoorsInitializer.getConfig().getMonolithsConfig().monolithTeleportation && (ModDimensions.isLimboDimension(this.field_6002) || DimensionalDoorsInitializer.getConfig().getMonolithsConfig().dangerousLimboMonoliths);
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (source != class_1282.field_5855) {
            this.setAggro(250);
        }
        return false;
    }

    protected int method_6130(int i) {
        return 10;
    }

    protected int method_6064(int i) {
        return 10;
    }

    public boolean method_17326() {
        return false;
    }

    public boolean method_5810() {
        return false;
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(AGGRO, (Object)0);
        this.field_6011.method_12784(SCALE, (Object)Float.valueOf(1.0f));
        this.field_6011.method_12784(PITCH, (Object)Float.valueOf(1.0f));
        this.method_18382();
    }

    public boolean method_5805() {
        return false;
    }

    public void method_5784(class_1313 movementType, class_243 vec3d) {
    }

    protected void method_5958() {
        if (!ModDimensions.isLimboDimension(this.field_6002) && !ModDimensions.isPocketDimension(this.field_6002)) {
            this.method_5650(class_1297.class_5529.field_26999);
            super.method_5958();
            return;
        }
        super.method_5958();
    }

    public void updateAggroLevel(class_1657 player, boolean visibility) {
        if (player == null) {
            return;
        }
        if (((class_1799)player.method_31548().field_7548.get(0)).method_7909() == ModItems.WORLD_THREAD_HELMET && ((class_1799)player.method_31548().field_7548.get(1)).method_7909() == ModItems.WORLD_THREAD_CHESTPLATE && ((class_1799)player.method_31548().field_7548.get(2)).method_7909() == ModItems.WORLD_THREAD_LEGGINGS && ((class_1799)player.method_31548().field_7548.get(3)).method_7909() == ModItems.WORLD_THREAD_BOOTS) {
            return;
        }
        if (!this.field_6002.field_9236) {
            if (player.method_5739((class_1297)this) > 70.0f) {
                return;
            }
            int aggro = (Integer)this.field_6011.method_12789(AGGRO);
            if (visibility) {
                aggro = ModDimensions.isLimboDimension(this.field_6002) ? (this.isDangerous() ? ++aggro : (aggro += 36)) : (aggro += 3);
            } else if (this.isDangerous()) {
                if (aggro > this.aggroCap) {
                    --aggro;
                } else if (aggro < this.aggroCap) {
                    ++aggro;
                }
            } else {
                aggro -= 3;
            }
            int maxAggro = this.isDangerous() ? 250 : 180;
            aggro = (short)class_3532.method_15340((int)aggro, (int)0, (int)maxAggro);
            this.field_6011.method_12778(AGGRO, (Object)aggro);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public int getTextureState() {
        return class_3532.method_15340((int)(18 * (Integer)this.field_6011.method_12789(AGGRO) / 250), (int)0, (int)18);
    }

    public void playSounds(class_243 pos) {
        float aggroPercent = this.getAggroProgress();
        float pitch = this.method_36455();
        if (this.soundTime <= 0) {
            this.method_5783(ModSoundEvents.MONK, 1.0f, pitch);
            this.soundTime = 100;
        }
        if ((double)aggroPercent > 0.7 && this.soundTime < 100) {
            this.field_6002.method_8396(null, new class_2338(pos), ModSoundEvents.TEARING, class_3419.field_15251, 1.0f, (float)(1.0 + this.method_6051().nextGaussian()));
            this.soundTime = 100 + this.method_6051().nextInt(75);
        }
        if ((double)aggroPercent > 0.8 && this.soundTime < 200) {
            this.field_6002.method_8396(null, new class_2338(pos), ModSoundEvents.TEARING, class_3419.field_15251, 7.0f, 1.0f);
            this.soundTime = 250;
        }
        --this.soundTime;
    }

    public float method_18381(class_4050 entityPose) {
        return this.method_18377((class_4050)entityPose).field_18068 * 0.55f;
    }

    protected float method_18394(class_4050 pose, class_4048 dimensions) {
        return this.method_18377((class_4050)pose).field_18068 * 0.55f;
    }

    @Environment(value=EnvType.CLIENT)
    public static void spawnParticles(int aggro) {
        class_746 player = class_310.method_1551().field_1724;
        if (aggro < 120) {
            return;
        }
        int count = 10 * aggro / 250;
        for (int i = 1; i < count; ++i) {
            player.field_6002.method_8406((class_2394)class_2398.field_11214, player.method_23317() + (clientRandom.nextDouble() - 0.5) * 3.0, player.method_23318() + clientRandom.nextDouble() * (double)player.method_17682() - 0.75, player.method_23321() + (clientRandom.nextDouble() - 0.5) * (double)player.method_17681(), (clientRandom.nextDouble() - 0.5) * 2.0, -clientRandom.nextDouble(), (clientRandom.nextDouble() - 0.5) * 2.0);
        }
    }

    public float getAggroProgress() {
        return (float)this.getAggro() / 250.0f;
    }

    protected void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(0, (class_1352)new MonolithAggroGoal(this, 35.0f));
    }

    public void facePlayer(class_1657 player) {
        this.field_6206.method_6226((class_1297)player, 1.0f, 1.0f);
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10569("Aggro", this.getAggro());
        nbt.method_10548("scale", this.getScale());
        nbt.method_10548("pitch", this.method_36455());
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.setAggro(nbt.method_10550("Aggro"));
        if (nbt.method_10573("scale", 5)) {
            this.setScale(nbt.method_10583("scale"));
        }
        if (nbt.method_10573("pitch", 5)) {
            this.method_36457(nbt.method_10583("pitch"));
        }
    }

    public int getAggro() {
        return (Integer)this.field_6011.method_12789(AGGRO);
    }

    public void setAggro(int aggro) {
        this.field_6011.method_12778(AGGRO, (Object)aggro);
    }

    public float method_17825() {
        return this.getScale();
    }

    public float getScale() {
        return ((Float)this.field_6011.method_12789(SCALE)).floatValue();
    }

    public void setScale(float scale) {
        this.field_6011.method_12778(SCALE, (Object)Float.valueOf(scale));
        this.method_18382();
    }

    public float method_36455() {
        return ((Float)this.field_6011.method_12789(PITCH)).floatValue();
    }

    public void method_36457(float pitch) {
        this.field_6011.method_12778(PITCH, (Object)Float.valueOf(pitch));
    }

    public class_238 method_24833(class_4050 pose) {
        float scale = this.getScale();
        return super.method_24833(pose).method_1012((double)scale, (double)scale, (double)scale);
    }

    public void method_5674(class_2940<?> data) {
        if (SCALE.equals(data)) {
            this.method_18382();
        }
        super.method_5674(data);
    }

    public boolean method_5979(class_1936 world, class_3730 spawnReason) {
        if (spawnReason == class_3730.field_16472) {
            return super.method_5979(world, spawnReason);
        }
        if (spawnReason == class_3730.field_16459) {
            return this.method_6051().nextInt(32) == 2;
        }
        return false;
    }
}

