/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.datagen;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.nio.file.Path;
import java.util.function.BiConsumer;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2403;
import net.minecraft.class_2405;
import net.minecraft.class_2408;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dimdev.dimdoors.api.util.ResourceUtil;
import org.dimdev.dimdoors.block.ModBlocks;
import org.dimdev.dimdoors.world.decay.DecayPredicate;
import org.dimdev.dimdoors.world.decay.DecayProcessor;
import org.dimdev.dimdoors.world.decay.predicates.SimpleDecayPredicate;
import org.dimdev.dimdoors.world.decay.processors.SelfDecayProcessor;
import org.dimdev.dimdoors.world.decay.processors.SimpleDecayProcesor;

public class LimboDecayProvider
implements class_2405 {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final class_2403 generator;

    public LimboDecayProvider(class_2403 generator) {
        this.generator = generator;
    }

    public void method_10319(class_2408 cache) throws IOException {
        Path path = this.generator.method_10313();
        BiConsumer<class_2960, JsonObject> consumer = (identifier, json) -> {
            Path outputPath = LimboDecayProvider.getOutput(path, identifier);
            try {
                class_2405.method_10320((Gson)GSON, (class_2408)cache, (JsonElement)json, (Path)outputPath);
            }
            catch (IOException var6) {
                LOGGER.error("Couldn't save decay pattern {}", (Object)outputPath, (Object)var6);
            }
        };
        this.generatePatterns(consumer);
    }

    protected void generatePatterns(BiConsumer<class_2960, JsonObject> consumer) {
        this.createSimplePattern(new class_2960("dimdoors:stone"), class_2246.field_10340, class_2246.field_10445).run(consumer);
        this.createSimplePattern(new class_2960("dimdoors:cobblestone"), class_2246.field_10445, class_2246.field_10255).run(consumer);
        this.createSimplePattern(new class_2960("dimdoors:gravel"), class_2246.field_10255, class_2246.field_10102).run(consumer);
        this.turnIntoSelf(new class_2960("dimdoors:sand"), class_2246.field_10102).run(consumer);
        this.createSimplePattern(new class_2960("dimdoors:bedrock"), class_2246.field_9987, ModBlocks.SOLID_STATIC);
        this.createSimplePattern(new class_2960("dimdoors:glass"), class_2246.field_10033, class_2246.field_10102).run(consumer);
        this.createSimplePattern(new class_2960("dimdoors:grass_block"), class_2246.field_10219, class_2246.field_10566).run(consumer);
        this.createSimplePattern(new class_2960("dimdoors:dirt"), class_2246.field_10566, class_2246.field_10102).run(consumer);
        this.createSimplePattern(new class_2960("dimdoors:redstone_block"), class_2246.field_10002, class_2246.field_10080).run(consumer);
        this.createSimplePattern(new class_2960("dimdoors:redstone_ore"), class_2246.field_10080, class_2246.field_10340).run(consumer);
        this.createSimplePattern(new class_2960("dimdoors:emerald_block"), class_2246.field_10234, class_2246.field_10013).run(consumer);
        this.createSimplePattern(new class_2960("dimdoors:emerald_ore"), class_2246.field_10013, class_2246.field_10340).run(consumer);
        this.createSimplePattern(new class_2960("dimdoors:coal_block"), class_2246.field_10381, class_2246.field_10418).run(consumer);
        this.createSimplePattern(new class_2960("dimdoors:coal_ore"), class_2246.field_10418, class_2246.field_10340).run(consumer);
        this.createSimplePattern(new class_2960("dimdoors:iron_block"), class_2246.field_10085, class_2246.field_10212).run(consumer);
        this.createSimplePattern(new class_2960("dimdoors:iron_ore"), class_2246.field_10212, class_2246.field_10340).run(consumer);
        this.createSimplePattern(new class_2960("dimdoors:lapis_block"), class_2246.field_10441, class_2246.field_10090).run(consumer);
        this.createSimplePattern(new class_2960("dimdoors:lapis_ore"), class_2246.field_10090, class_2246.field_10340).run(consumer);
        this.createSimplePattern(new class_2960("dimdoors:gold_block"), class_2246.field_10205, class_2246.field_10571).run(consumer);
        this.createSimplePattern(new class_2960("dimdoors:gold_ore"), class_2246.field_10571, class_2246.field_10340).run(consumer);
        this.createSimplePattern(new class_2960("dimdoors:sandstone"), class_2246.field_9979, class_2246.field_10102).run(consumer);
        this.createSimplePattern(new class_2960("dimdoors:end_stone_bricks"), class_2246.field_10462, class_2246.field_10471).run(consumer);
        this.createSimplePattern(new class_2960("dimdoors:dirt_path"), class_2246.field_10194, class_2246.field_10566).run(consumer);
        this.createSimplePattern(new class_2960("dimdoors:polished_granite"), class_2246.field_10289, class_2246.field_10474).run(consumer);
        this.createSimplePattern(new class_2960("dimdoors:polished_andesite"), class_2246.field_10093, class_2246.field_10115).run(consumer);
        this.createSimplePattern(new class_2960("dimdoors:andesite"), class_2246.field_10115, class_2246.field_10508).run(consumer);
        this.createSimplePattern(new class_2960("dimdoors:polished_diorite"), class_2246.field_10346, class_2246.field_10508).run(consumer);
        this.createSimplePattern(new class_2960("dimdoors:granite"), class_2246.field_10474, class_2246.field_10508).run(consumer);
        this.createSimplePattern(new class_2960("dimdoors:diorite"), class_2246.field_10508, class_2246.field_10445).run(consumer);
        this.createSimplePattern(new class_2960("dimdoors:polished_blackstone"), class_2246.field_23873, class_2246.field_23869).run(consumer);
        this.createSimplePattern(new class_2960("dimdoors:blackstone"), class_2246.field_23869, class_2246.field_10445).run(consumer);
        this.createSimplePattern(new class_2960("dimdoors:podzol"), class_2246.field_10520, class_2246.field_10566).run(consumer);
        this.createSimplePattern(new class_2960("dimdoors:farmland"), class_2246.field_10362, class_2246.field_10566).run(consumer);
        this.createSimplePattern(new class_2960("dimdoors:stone_bricks"), class_2246.field_10056, class_2246.field_10416).run(consumer);
        this.createSimplePattern(new class_2960("dimdoors:cracked_stone_bricks"), class_2246.field_10416, class_2246.field_10508).run(consumer);
        this.createSimplePattern(new class_2960("dimdoors:end_stone"), class_2246.field_10471, class_2246.field_9979).run(consumer);
        this.createSimplePattern(new class_2960("dimdoors:oak_log"), class_2246.field_10431, class_2246.field_10161).run(consumer);
        this.createSimplePattern(new class_2960("dimdoors:birch_log"), class_2246.field_10511, class_2246.field_10148).run(consumer);
        this.createSimplePattern(new class_2960("dimdoors:spruce_log"), class_2246.field_10037, class_2246.field_9975).run(consumer);
        this.createSimplePattern(new class_2960("dimdoors:jungle_log"), class_2246.field_10306, class_2246.field_10334).run(consumer);
        this.createSimplePattern(new class_2960("dimdoors:acacia_log"), class_2246.field_10533, class_2246.field_10218).run(consumer);
        this.createSimplePattern(new class_2960("dimdoors:dark_oak_log"), class_2246.field_10010, class_2246.field_10075).run(consumer);
        this.createSimplePattern(new class_2960("dimdoors:oak_wood"), class_2246.field_10126, class_2246.field_10431).run(consumer);
        this.createSimplePattern(new class_2960("dimdoors:birch_wood"), class_2246.field_10307, class_2246.field_10511).run(consumer);
        this.createSimplePattern(new class_2960("dimdoors:spruce_wood"), class_2246.field_10155, class_2246.field_10037).run(consumer);
        this.createSimplePattern(new class_2960("dimdoors:jungle_wood"), class_2246.field_10303, class_2246.field_10306).run(consumer);
        this.createSimplePattern(new class_2960("dimdoors:acacia_wood"), class_2246.field_9999, class_2246.field_10533).run(consumer);
        this.createSimplePattern(new class_2960("dimdoors:dark_oak_wood"), class_2246.field_10178, class_2246.field_10010).run(consumer);
    }

    private DecayPatternData turnIntoSelf(class_2960 identifier, class_2248 before) {
        return new DecayPatternData(identifier, SimpleDecayPredicate.builder().block(before).create(), SelfDecayProcessor.instance());
    }

    public String method_10321() {
        return "Limbo Decay";
    }

    private static Path getOutput(Path rootOutput, class_2960 lootTableId) {
        return rootOutput.resolve("data/" + lootTableId.method_12836() + "/decay_patterns/" + lootTableId.method_12832() + ".json");
    }

    public DecayPatternData createSimplePattern(class_2960 id, class_2248 before, class_2248 after) {
        return new DecayPatternData(id, SimpleDecayPredicate.builder().block(before).create(), SimpleDecayProcesor.builder().block(after).entropy(1).create());
    }

    public static class DecayPatternData {
        private class_2960 id;
        private DecayPredicate predicate;
        private DecayProcessor processor;

        public DecayPatternData(class_2960 id, DecayPredicate predicate, DecayProcessor processor) {
            this.id = id;
            this.predicate = predicate;
            this.processor = processor;
        }

        public void run(BiConsumer<class_2960, JsonObject> consumer) {
            JsonObject object = new JsonObject();
            object.add("predicate", (JsonElement)ResourceUtil.NBT_TO_JSON.apply((class_2520)this.predicate.toNbt(new class_2487())));
            object.add("processor", (JsonElement)ResourceUtil.NBT_TO_JSON.apply((class_2520)this.processor.toNbt(new class_2487())));
            consumer.accept(this.id, object);
        }
    }
}

