/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.client;

import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.model.ModelLoadingRegistry;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.rendereregistry.v1.BlockEntityRendererRegistry;
import org.dimdev.dimdoors.block.ModBlocks;
import org.dimdev.dimdoors.block.entity.ModBlockEntityTypes;
import org.dimdev.dimdoors.client.DetachedRiftBlockEntityRenderer;
import org.dimdev.dimdoors.client.DimensionRenderering;
import org.dimdev.dimdoors.client.DimensionalDoorModelVariantProvider;
import org.dimdev.dimdoors.client.EntranceRiftBlockEntityRenderer;
import org.dimdev.dimdoors.client.ModEntityModelLayers;
import org.dimdev.dimdoors.entity.ModEntityTypes;
import org.dimdev.dimdoors.fluid.ModFluids;
import org.dimdev.dimdoors.network.client.ExtendedClientPlayNetworkHandler;
import org.dimdev.dimdoors.particle.ModParticleTypes;

@Environment(value=EnvType.CLIENT)
public class DimensionalDoorsClientInitializer
implements ClientModInitializer {
    public void onInitializeClient() {
        ModelLoadingRegistry.INSTANCE.registerVariantProvider(manager -> new DimensionalDoorModelVariantProvider());
        ModEntityTypes.initClient();
        ModFluids.initClient();
        BlockEntityRendererRegistry.INSTANCE.register(ModBlockEntityTypes.ENTRANCE_RIFT, ctx -> new EntranceRiftBlockEntityRenderer());
        BlockEntityRendererRegistry.INSTANCE.register(ModBlockEntityTypes.DETACHED_RIFT, ctx -> new DetachedRiftBlockEntityRenderer());
        ModBlocks.initClient();
        ModEntityModelLayers.initClient();
        ModParticleTypes.initClient();
        DimensionRenderering.initClient();
        this.registerListeners();
    }

    private void registerListeners() {
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> ((ExtendedClientPlayNetworkHandler)handler).getDimDoorsPacketHandler().init());
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> ((ExtendedClientPlayNetworkHandler)handler).getDimDoorsPacketHandler().unregister());
    }
}

