/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.client;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2338;

@Environment(value=EnvType.CLIENT)
public class CustomBreakBlockHandler {
    private static final Map<class_2338, BreakBlockInfo> customBreakBlockMap = new ConcurrentHashMap<class_2338, BreakBlockInfo>();
    private static final ReentrantLock lock = new ReentrantLock();

    public static Map<class_2338, BreakBlockInfo> getCustomBreakBlockMap(int ticks) {
        lock.lock();
        Set<class_2338> expired = customBreakBlockMap.entrySet().stream().filter(entry -> ticks - ((BreakBlockInfo)entry.getValue()).getLastUpdateTick() > 400).map(entry -> (class_2338)entry.getKey()).collect(Collectors.toSet());
        expired.forEach(customBreakBlockMap::remove);
        HashMap<class_2338, BreakBlockInfo> copy = new HashMap<class_2338, BreakBlockInfo>(customBreakBlockMap);
        lock.unlock();
        return copy;
    }

    public static void customBreakBlock(class_2338 pos, int stage, int ticks) {
        lock.lock();
        if (stage < 0 || stage > 10) {
            customBreakBlockMap.remove(pos);
        } else if (customBreakBlockMap.containsKey(pos)) {
            BreakBlockInfo info = customBreakBlockMap.get(pos);
            info.setStage(stage);
            info.setLastUpdateTick(ticks);
        } else {
            customBreakBlockMap.put(pos, new BreakBlockInfo(stage, ticks));
        }
        lock.unlock();
    }

    public static class BreakBlockInfo {
        private int stage;
        private int lastUpdateTick;

        private BreakBlockInfo(int stage, int lastUpdateTick) {
            this.stage = stage;
            this.lastUpdateTick = lastUpdateTick;
        }

        public void setStage(int stage) {
            this.stage = stage;
        }

        public int getStage() {
            return this.stage;
        }

        public void setLastUpdateTick(int lastUpdateTick) {
            this.lastUpdateTick = lastUpdateTick;
        }

        public int getLastUpdateTick() {
            return this.lastUpdateTick;
        }
    }
}

