/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.block.entity;

import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1560;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2379;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import org.dimdev.dimdoors.DimensionalDoorsInitializer;
import org.dimdev.dimdoors.api.util.TeleportUtil;
import org.dimdev.dimdoors.block.ModBlocks;
import org.dimdev.dimdoors.block.entity.ModBlockEntityTypes;
import org.dimdev.dimdoors.block.entity.RiftBlockEntity;

public class DetachedRiftBlockEntity
extends RiftBlockEntity {
    private static final Random random = new Random();
    public boolean closing = false;
    public boolean stabilized = false;
    public int spawnedEndermanId = 0;
    public float size = 0.0f;
    private boolean unregisterDisabled = false;
    @Environment(value=EnvType.CLIENT)
    public double renderAngle;

    public DetachedRiftBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntityTypes.DETACHED_RIFT, pos, state);
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, DetachedRiftBlockEntity blockEntity) {
        if (world == null) {
            return;
        }
        if (state.method_26204() != ModBlocks.DETACHED_RIFT) {
            blockEntity.method_11012();
            return;
        }
        if (!world.method_8608() && (double)random.nextFloat() < DimensionalDoorsInitializer.getConfig().getGeneralConfig().endermanSpawnChance) {
            class_1560 enderman = (class_1560)class_1299.field_6091.method_5899((class_3218)world, null, null, null, pos, class_3730.field_16474, false, false);
            if (random.nextDouble() < DimensionalDoorsInitializer.getConfig().getGeneralConfig().endermanAggressiveChance && enderman != null) {
                enderman.method_5980((class_1309)world.method_18460((class_1297)enderman, 50.0));
            }
        }
        if (blockEntity.closing) {
            if (blockEntity.size > 0.0f) {
                blockEntity.size = (float)((double)blockEntity.size - DimensionalDoorsInitializer.getConfig().getGeneralConfig().riftCloseSpeed);
            } else {
                world.method_8650(pos, false);
            }
        } else if (!blockEntity.stabilized) {
            blockEntity.size = (float)((double)blockEntity.size + DimensionalDoorsInitializer.getConfig().getGeneralConfig().riftGrowthSpeed / (double)(blockEntity.size + 1.0f));
        }
    }

    public void setClosing(boolean closing) {
        this.closing = closing;
        this.method_5431();
    }

    public void setStabilized(boolean stabilized) {
        this.stabilized = stabilized;
        this.method_5431();
    }

    @Override
    public class_2487 serialize(class_2487 nbt) {
        super.serialize(nbt);
        nbt.method_10556("closing", this.closing);
        nbt.method_10556("stablized", this.stabilized);
        nbt.method_10569("spawnedEnderManId", this.spawnedEndermanId);
        nbt.method_10548("size", this.size);
        return nbt;
    }

    @Override
    public void deserialize(class_2487 nbt) {
        super.deserialize(nbt);
        this.closing = nbt.method_10577("closing");
        this.stabilized = nbt.method_10577("stablized");
        this.spawnedEndermanId = nbt.method_10550("spawnedEnderManId");
        this.size = nbt.method_10583("size");
    }

    @Override
    public boolean isDetached() {
        return true;
    }

    @Override
    public void unregister() {
        if (!this.unregisterDisabled) {
            super.unregister();
        }
    }

    @Override
    public boolean receiveEntity(class_1297 entity, class_243 relativePos, class_2379 relativeAngle, class_243 velocity) {
        if (this.field_11863 instanceof class_3218) {
            TeleportUtil.teleport(entity, this.field_11863, this.field_11867, relativeAngle, velocity);
        }
        return true;
    }

    public void setUnregisterDisabled(boolean unregisterDisabled) {
        this.unregisterDisabled = unregisterDisabled;
    }

    @Override
    public boolean isLocked() {
        return false;
    }

    @Override
    public void setLocked(boolean locked) {
    }
}

