/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.block.door.data;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_3545;
import org.dimdev.dimdoors.block.door.data.condition.Condition;
import org.dimdev.dimdoors.block.entity.EntranceRiftBlockEntity;
import org.dimdev.dimdoors.rift.registry.LinkProperties;
import org.dimdev.dimdoors.rift.targets.VirtualTarget;

public class RiftDataList {
    private final LinkedList<class_3545<JsonObject, Condition>> riftDataConditions;

    public static RiftDataList fromJson(JsonArray jsonArray) {
        LinkedList<class_3545<JsonObject, Condition>> riftDataConditions = new LinkedList<class_3545<JsonObject, Condition>>();
        for (JsonElement json : jsonArray) {
            JsonObject jsonObject = json.getAsJsonObject();
            JsonObject unbakedRiftData = jsonObject.getAsJsonObject("data");
            Condition condition = Condition.fromJson(jsonObject.getAsJsonObject("condition"));
            riftDataConditions.add((class_3545<JsonObject, Condition>)new class_3545((Object)unbakedRiftData, (Object)condition));
        }
        return new RiftDataList(riftDataConditions);
    }

    public RiftDataList(LinkedList<class_3545<JsonObject, Condition>> riftDataConditions) {
        this.riftDataConditions = riftDataConditions;
    }

    public OptRiftData getRiftData(EntranceRiftBlockEntity rift) {
        JsonObject unbakedRiftData = (JsonObject)this.riftDataConditions.stream().filter(pair -> ((Condition)pair.method_15441()).matches(rift)).findFirst().orElseThrow(() -> new RuntimeException("Could not find any matching rift data")).method_15442();
        return OptRiftData.fromJson(unbakedRiftData);
    }

    public JsonArray toJson() {
        JsonArray jsonArray = new JsonArray();
        for (Map.Entry<JsonObject, Condition> entry : this.riftDataConditions.stream().collect(Collectors.toMap(class_3545::method_15442, class_3545::method_15441)).entrySet()) {
            JsonObject unbakedRiftData = entry.getKey();
            Condition condition = entry.getValue();
            JsonObject jsonInner = new JsonObject();
            jsonInner.add("data", (JsonElement)unbakedRiftData);
            jsonInner.add("condition", (JsonElement)condition.toJson(new JsonObject()));
            jsonArray.add((JsonElement)jsonInner);
        }
        return jsonArray;
    }

    public static class OptRiftData {
        private final Optional<VirtualTarget> destination;
        private final Optional<LinkProperties> linkProperties;

        public static OptRiftData fromJson(JsonObject json) {
            Optional<VirtualTarget> destination = Optional.ofNullable(json.get("destination")).map(JsonElement::getAsJsonObject).map(j -> (class_2520)JsonOps.INSTANCE.convertTo((DynamicOps)class_2509.field_11560, (JsonElement)j)).map(class_2487.class::cast).map(VirtualTarget::fromNbt);
            Optional<LinkProperties> linkProperties = Optional.ofNullable(json.get("properties")).map(JsonElement::getAsJsonObject).map(j -> (class_2520)JsonOps.INSTANCE.convertTo((DynamicOps)class_2509.field_11560, (JsonElement)j)).map(class_2487.class::cast).map(LinkProperties::fromNbt);
            return new OptRiftData(destination, linkProperties);
        }

        public OptRiftData(Optional<VirtualTarget> destination, Optional<LinkProperties> linkProperties) {
            this.destination = destination;
            this.linkProperties = linkProperties;
        }

        public JsonObject toJson(JsonObject json) {
            this.destination.ifPresent(s -> json.add("destination", (JsonElement)class_2509.field_11560.method_29146((DynamicOps)JsonOps.INSTANCE, (class_2520)VirtualTarget.toNbt(s))));
            this.linkProperties.ifPresent(s -> json.add("properties", (JsonElement)class_2509.field_11560.method_29146((DynamicOps)JsonOps.INSTANCE, (class_2520)LinkProperties.toNbt(s))));
            return json;
        }

        public Optional<LinkProperties> getProperties() {
            return this.linkProperties;
        }

        public Optional<VirtualTarget> getDestination() {
            return this.destination;
        }
    }
}

