/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.block.door.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_156;
import net.minecraft.class_1814;
import net.minecraft.class_3545;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dimdev.dimdoors.DimensionalDoorsInitializer;
import org.dimdev.dimdoors.block.door.data.DoorData;
import org.dimdev.dimdoors.block.door.data.RiftDataList;
import org.dimdev.dimdoors.block.door.data.condition.AlwaysTrueCondition;
import org.dimdev.dimdoors.block.door.data.condition.InverseCondition;
import org.dimdev.dimdoors.block.door.data.condition.WorldMatchCondition;
import org.dimdev.dimdoors.pockets.DefaultDungeonDestinations;
import org.dimdev.dimdoors.rift.registry.LinkProperties;
import org.dimdev.dimdoors.rift.targets.EscapeTarget;
import org.dimdev.dimdoors.rift.targets.PrivatePocketExitTarget;
import org.dimdev.dimdoors.rift.targets.PrivatePocketTarget;
import org.dimdev.dimdoors.rift.targets.PublicPocketTarget;
import org.dimdev.dimdoors.rift.targets.UnstableTarget;
import org.dimdev.dimdoors.world.ModDimensions;

public class DoorDataReader {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().setLenient().create();
    private static final Logger LOGGER = LogManager.getLogger();
    public static final DoorData DEFAULT_IRON_DIMENSIONAL_DOOR = new DoorData("dimdoors:iron_dimensional_door", new DoorData.UnbakedItemSettings("minecraft:iron_door", OptionalInt.of(1), OptionalInt.empty(), Optional.of(class_1814.field_8907), TriState.FALSE), new DoorData.UnbakedBlockSettings("minecraft:iron_door", OptionalInt.of(10)), new RiftDataList((LinkedList)class_156.method_654(new LinkedList(), list -> list.add(new class_3545((Object)new RiftDataList.OptRiftData(Optional.of(new PublicPocketTarget()), Optional.empty()).toJson(new JsonObject()), (Object)AlwaysTrueCondition.INSTANCE)))), true);
    public static final DoorData DEFAULT_GOLD_DIMENSIONAL_DOOR = new DoorData("dimdoors:gold_dimensional_door", new DoorData.UnbakedItemSettings("dimdoors:gold_door", OptionalInt.of(1), OptionalInt.empty(), Optional.of(class_1814.field_8907), TriState.FALSE), new DoorData.UnbakedBlockSettings("dimdoors:gold_door", OptionalInt.of(10)), new RiftDataList((LinkedList)class_156.method_654(new LinkedList(), list -> list.add(new class_3545((Object)new RiftDataList.OptRiftData(Optional.of(new PublicPocketTarget()), Optional.empty()).toJson(new JsonObject()), (Object)AlwaysTrueCondition.INSTANCE)))), true);
    public static final DoorData DEFAULT_OAK_DIMENSIONAL_DOOR = new DoorData("dimdoors:oak_dimensional_door", new DoorData.UnbakedItemSettings("minecraft:oak_door", OptionalInt.of(1), OptionalInt.empty(), Optional.of(class_1814.field_8907), TriState.FALSE), new DoorData.UnbakedBlockSettings("minecraft:oak_door", OptionalInt.of(10)), new RiftDataList((LinkedList)class_156.method_654(new LinkedList(), list -> list.add(new class_3545((Object)new RiftDataList.OptRiftData(Optional.of(new EscapeTarget(true)), Optional.empty()).toJson(new JsonObject()), (Object)AlwaysTrueCondition.INSTANCE)))), true);
    public static final DoorData DEFAULT_QUARTZ_DIMENSIONAL_DOOR = new DoorData("dimdoors:quartz_dimensional_door", new DoorData.UnbakedItemSettings("dimdoors:quartz_door", OptionalInt.of(1), OptionalInt.empty(), Optional.of(class_1814.field_8907), TriState.FALSE), new DoorData.UnbakedBlockSettings("dimdoors:quartz_door", OptionalInt.of(10)), new RiftDataList((LinkedList)class_156.method_654(new LinkedList(), list -> {
        WorldMatchCondition condition = new WorldMatchCondition(ModDimensions.PERSONAL);
        list.add(new class_3545((Object)new RiftDataList.OptRiftData(Optional.of(new PrivatePocketExitTarget()), Optional.empty()).toJson(new JsonObject()), (Object)condition));
        list.add(new class_3545((Object)new RiftDataList.OptRiftData(Optional.of(new PrivatePocketTarget()), Optional.empty()).toJson(new JsonObject()), (Object)new InverseCondition(condition)));
    })), true);
    public static final DoorData DEFAULT_UNSTABLE_DIMENSIONAL_DOOR = new DoorData("dimdoors:unstable_dimensional_door", new DoorData.UnbakedItemSettings("minecraft:iron_door", OptionalInt.of(1), OptionalInt.empty(), Optional.of(class_1814.field_8907), TriState.FALSE), new DoorData.UnbakedBlockSettings("minecraft:iron_door", OptionalInt.of(10)), new RiftDataList((LinkedList)class_156.method_654(new LinkedList(), list -> list.add(new class_3545((Object)new RiftDataList.OptRiftData(Optional.of(new UnstableTarget()), Optional.of(LinkProperties.builder().linksRemaining(1).groups(IntStream.of(0, 1).boxed().collect(Collectors.toSet())).build())).toJson(new JsonObject()), (Object)AlwaysTrueCondition.INSTANCE)))), true);
    public static final DoorData DEFAULT_DUNGEON_DOOR = new DoorData("dimdoors:dungeon_door", new DoorData.UnbakedItemSettings("dimdoors:stone_door", OptionalInt.of(1), OptionalInt.empty(), Optional.of(class_1814.field_8907), TriState.FALSE), new DoorData.UnbakedBlockSettings("dimdoors:stone_door", OptionalInt.empty()), new RiftDataList((LinkedList)class_156.method_654(new LinkedList(), list -> list.add(new class_3545((Object)new RiftDataList.OptRiftData(Optional.of(DefaultDungeonDestinations.getShallowerDungeonDestination()), Optional.of(DefaultDungeonDestinations.POCKET_LINK_PROPERTIES)).toJson(new JsonObject()), (Object)AlwaysTrueCondition.INSTANCE)))), true);

    public static void read() {
        Path doorDir = DimensionalDoorsInitializer.getConfigRoot().resolve("doors");
        if (Files.exists(doorDir, new LinkOption[0]) && !Files.isDirectory(doorDir, new LinkOption[0])) {
            try {
                Files.delete(doorDir);
            }
            catch (IOException e) {
                LOGGER.error("Error deleting " + doorDir, (Throwable)e);
                return;
            }
        }
        if (Files.notExists(doorDir, new LinkOption[0])) {
            try {
                Files.createDirectory(doorDir, new FileAttribute[0]);
                DoorDataReader.writeDefault(doorDir);
            }
            catch (IOException e) {
                LOGGER.error("Error creating directory " + doorDir, (Throwable)e);
                return;
            }
        }
        if (Files.isDirectory(doorDir, new LinkOption[0])) {
            List paths;
            try {
                paths = Files.list(doorDir).collect(Collectors.toList());
            }
            catch (IOException e) {
                LOGGER.error("Error retrieving paths in directory " + doorDir, (Throwable)e);
                return;
            }
            for (Path p : paths) {
                String jsonStr;
                if (Files.isDirectory(p, new LinkOption[0]) || !Files.isRegularFile(p, new LinkOption[0])) continue;
                try {
                    jsonStr = Files.readString(p);
                }
                catch (IOException e) {
                    LOGGER.error("Error reading " + p, (Throwable)e);
                    return;
                }
                JsonObject json = (JsonObject)GSON.fromJson(jsonStr, JsonObject.class);
                try {
                    DoorData ignored = DoorData.fromJson(json);
                    try {
                        LOGGER.info("Loaded door json from {} with id {}", (Object)p.toAbsolutePath().toString(), (Object)ignored.getId());
                    }
                    finally {
                        if (ignored == null) continue;
                        ignored.close();
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Error trying to load door json from path " + p.toAbsolutePath().toString(), (Throwable)e);
                }
            }
        }
    }

    private static void writeDefault(Path root) throws IOException {
        DoorDataReader.writeDefault(root.resolve("iron_dimensional_door.json"), DEFAULT_IRON_DIMENSIONAL_DOOR);
        DoorDataReader.writeDefault(root.resolve("gold_dimensional_door.json"), DEFAULT_GOLD_DIMENSIONAL_DOOR);
        DoorDataReader.writeDefault(root.resolve("oak_dimensional_door.json"), DEFAULT_OAK_DIMENSIONAL_DOOR);
        DoorDataReader.writeDefault(root.resolve("quartz_dimensional_door.json"), DEFAULT_QUARTZ_DIMENSIONAL_DOOR);
        DoorDataReader.writeDefault(root.resolve("dungeon_door.json"), DEFAULT_DUNGEON_DOOR);
    }

    private static void writeDefault(Path path, DoorData doorData) {
        try {
            Files.createFile(path, new FileAttribute[0]);
        }
        catch (IOException e) {
            LOGGER.error("Error creating " + path, (Throwable)e);
            return;
        }
        String json = GSON.toJson((JsonElement)doorData.toJson(new JsonObject()));
        try {
            Files.writeString(path, (CharSequence)json, new OpenOption[0]);
        }
        catch (IOException e) {
            LOGGER.error("Error writing to " + path, (Throwable)e);
        }
    }
}

