/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.block.door.data;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_156;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1814;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_4970;
import org.dimdev.dimdoors.block.door.DimensionalDoorBlock;
import org.dimdev.dimdoors.block.door.data.RiftDataList;
import org.dimdev.dimdoors.block.entity.EntranceRiftBlockEntity;
import org.dimdev.dimdoors.item.DimensionalDoorItem;
import org.dimdev.dimdoors.item.ItemExtensions;
import org.dimdev.dimdoors.item.ModItems;
import org.dimdev.dimdoors.mixin.accessor.ItemGroupAccessor;

public final class DoorData
implements AutoCloseable {
    private static final Map<String, class_1761> itemGroupCache = new HashMap<String, class_1761>();
    public static final Set<class_2248> PARENT_BLOCKS = new HashSet<class_2248>();
    public static final Set<class_1792> PARENT_ITEMS = new HashSet<class_1792>();
    public static final List<class_2248> DOORS = new ArrayList<class_2248>();
    private final String id;
    private final UnbakedItemSettings itemSettings;
    private final Optional<String> itemGroup;
    private final UnbakedBlockSettings blockSettings;
    private final RiftDataList riftDataList;
    private final boolean hasToolTip;
    private boolean closed = false;

    public static DoorData fromJson(JsonObject json) {
        try {
            String id = json.get("id").getAsString();
            UnbakedItemSettings itemSettings = UnbakedItemSettings.fromJson(json.getAsJsonObject("itemSettings"));
            Optional<String> itemGroup = Optional.ofNullable(json.getAsJsonPrimitive("itemGroup")).map(JsonPrimitive::getAsString);
            UnbakedBlockSettings blockSettings = UnbakedBlockSettings.fromJson(json.getAsJsonObject("blockSettings"));
            RiftDataList riftDataList = RiftDataList.fromJson(json.getAsJsonArray("riftData"));
            boolean hasToolTip = json.has("hasToolTip") && json.getAsJsonPrimitive("hasToolTip").getAsBoolean();
            return new DoorData(id, itemSettings, itemGroup, blockSettings, riftDataList, hasToolTip);
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Caught exception while deserializing " + json.toString(), e);
        }
    }

    public DoorData(String id, UnbakedItemSettings itemSettings, UnbakedBlockSettings blockSettings, RiftDataList riftDataList) {
        this(id, itemSettings, Optional.empty(), blockSettings, riftDataList, false);
    }

    public DoorData(String id, UnbakedItemSettings itemSettings, UnbakedBlockSettings blockSettings, RiftDataList riftDataList, boolean hasToolTip) {
        this(id, itemSettings, Optional.empty(), blockSettings, riftDataList, hasToolTip);
    }

    public DoorData(String id, UnbakedItemSettings itemSettings, Optional<String> itemGroup, UnbakedBlockSettings blockSettings, RiftDataList riftDataList, boolean hasToolTip) {
        this.id = id;
        this.itemSettings = itemSettings;
        this.itemGroup = itemGroup;
        this.blockSettings = blockSettings;
        this.riftDataList = riftDataList;
        this.hasToolTip = hasToolTip;
    }

    public JsonObject toJson(JsonObject json) {
        json.addProperty("id", this.id);
        json.add("itemSettings", (JsonElement)this.itemSettings.toJson(new JsonObject()));
        this.itemGroup.ifPresent(s -> json.add("itemGroup", (JsonElement)new JsonPrimitive(s)));
        json.add("blockSettings", (JsonElement)this.blockSettings.toJson(new JsonObject()));
        json.add("riftData", (JsonElement)this.riftDataList.toJson());
        json.addProperty("hasToolTip", Boolean.valueOf(this.hasToolTip));
        return json;
    }

    private Consumer<? super EntranceRiftBlockEntity> createSetupFunction() {
        RiftDataList riftDataList = this.riftDataList;
        return rift -> {
            RiftDataList.OptRiftData riftData = riftDataList.getRiftData((EntranceRiftBlockEntity)rift);
            riftData.getDestination().ifPresent(rift::setDestination);
            riftData.getProperties().ifPresent(rift::setProperties);
        };
    }

    public String getId() {
        return this.id;
    }

    public UnbakedItemSettings getItemSettings() {
        return this.itemSettings;
    }

    public UnbakedBlockSettings getBlockSettings() {
        return this.blockSettings;
    }

    public RiftDataList getRiftDataList() {
        return this.riftDataList;
    }

    public boolean hasToolTip() {
        return this.hasToolTip;
    }

    @Override
    public void close() {
        if (this.closed) {
            throw new UnsupportedOperationException("Already Closed");
        }
        class_1792 parentItem = (class_1792)class_2378.field_11142.method_10223(new class_2960(this.itemSettings.parent));
        PARENT_ITEMS.add(parentItem);
        class_1792.class_1793 itemSettings = ItemExtensions.getSettings(parentItem);
        this.itemSettings.maxCount.ifPresent(arg_0 -> ((class_1792.class_1793)itemSettings).method_7889(arg_0));
        this.itemSettings.maxDamage.ifPresent(arg_0 -> ((class_1792.class_1793)itemSettings).method_7898(arg_0));
        this.itemSettings.rarity.ifPresent(arg_0 -> ((class_1792.class_1793)itemSettings).method_7894(arg_0));
        this.itemSettings.fireproof.map(b -> {
            if (!b) {
                return false;
            }
            itemSettings.method_24359();
            return false;
        });
        class_1761 group = null;
        if (this.itemGroup.isPresent()) {
            String groupString = this.itemGroup.get();
            if (itemGroupCache.containsKey(groupString)) {
                group = itemGroupCache.get(groupString);
            } else {
                for (class_1761 g : class_1761.field_7921) {
                    if (!((ItemGroupAccessor)g).getId().equals(groupString)) continue;
                    group = g;
                    itemGroupCache.put(groupString, group);
                    break;
                }
            }
        }
        itemSettings.method_7892(group != null ? group : ModItems.DIMENSIONAL_DOORS);
        class_2248 parentBlock = (class_2248)class_2378.field_11146.method_10223(new class_2960(this.blockSettings.parent));
        PARENT_BLOCKS.add(parentBlock);
        FabricBlockSettings blockSettings = FabricBlockSettings.copyOf((class_4970)parentBlock);
        this.blockSettings.luminance.ifPresent(arg_0 -> ((FabricBlockSettings)blockSettings).luminance(arg_0));
        class_2960 id = new class_2960(this.id);
        DimensionalDoorBlock doorBlock = new DimensionalDoorBlock((class_4970.class_2251)blockSettings);
        DimensionalDoorItem doorItem = new DimensionalDoorItem((class_2248)doorBlock, itemSettings, this.createSetupFunction(), this.hasToolTip);
        class_2378.method_10230((class_2378)class_2378.field_11146, (class_2960)id, (Object)doorBlock);
        class_2378.method_10230((class_2378)class_2378.field_11142, (class_2960)id, (Object)((Object)doorItem));
        DOORS.add((class_2248)doorBlock);
        class_1792.field_8003.put(doorBlock, doorItem);
        this.closed = true;
    }

    public static final class UnbakedItemSettings {
        private static final Map<String, class_1814> RARITIES = ((ImmutableMap.Builder)class_156.method_654((Object)ImmutableMap.builder(), b -> {
            for (class_1814 rarity : class_1814.values()) {
                b.put((Object)rarity.name().toLowerCase(), (Object)rarity);
            }
        })).build();
        private final String parent;
        private final OptionalInt maxCount;
        private final OptionalInt maxDamage;
        private final Optional<class_1814> rarity;
        private final TriState fireproof;

        public static UnbakedItemSettings fromJson(JsonObject json) {
            String parent = Optional.ofNullable(json.get("parent")).map(JsonElement::getAsString).orElseThrow(() -> new RuntimeException("Missing parent key in " + json.toString()));
            OptionalInt maxCount = Optional.ofNullable(json.get("maxCount")).map(JsonElement::getAsInt).map(OptionalInt::of).orElse(OptionalInt.empty());
            OptionalInt maxDamage = Optional.ofNullable(json.get("maxDamage")).map(JsonElement::getAsInt).map(OptionalInt::of).orElse(OptionalInt.empty());
            Optional<class_1814> rarity = Optional.ofNullable(json.get("rarity")).map(JsonElement::getAsString).map(String::toLowerCase).map(RARITIES::get).map(Objects::requireNonNull);
            TriState fireproof = Optional.ofNullable(json.get("fireproof")).map(JsonElement::getAsBoolean).map(TriState::of).orElse(TriState.DEFAULT);
            return new UnbakedItemSettings(parent, maxCount, maxDamage, rarity, fireproof);
        }

        public UnbakedItemSettings(String parent, OptionalInt maxCount, OptionalInt maxDamage, Optional<class_1814> rarity, TriState fireproof) {
            this.parent = parent;
            this.maxCount = maxCount;
            this.maxDamage = maxDamage;
            this.rarity = rarity;
            this.fireproof = fireproof;
        }

        public JsonObject toJson(JsonObject json) {
            json.addProperty("parent", this.parent);
            this.maxCount.ifPresent(s -> json.addProperty("maxCount", (Number)s));
            this.maxDamage.ifPresent(s -> json.addProperty("maxDamage", (Number)s));
            this.rarity.ifPresent(s -> json.addProperty("rarity", s.name().toLowerCase()));
            this.fireproof.map(b -> {
                json.addProperty("fireproof", Boolean.valueOf(b));
                return b;
            });
            return json;
        }
    }

    public static final class UnbakedBlockSettings {
        private final String parent;
        private final OptionalInt luminance;

        public static UnbakedBlockSettings fromJson(JsonObject json) {
            String parent = Optional.ofNullable(json.get("parent")).map(JsonElement::getAsString).orElseThrow(() -> new RuntimeException("Missing parent block"));
            OptionalInt luminance = Optional.ofNullable(json.get("luminance")).map(JsonElement::getAsInt).map(OptionalInt::of).orElse(OptionalInt.empty());
            return new UnbakedBlockSettings(parent, luminance);
        }

        public UnbakedBlockSettings(String parent, OptionalInt luminance) {
            this.parent = parent;
            this.luminance = luminance;
        }

        public JsonObject toJson(JsonObject json) {
            json.addProperty("parent", this.parent);
            this.luminance.ifPresent(s -> json.addProperty("luminance", (Number)s));
            return json;
        }
    }
}

