/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.block.door;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.event.registry.RegistryEntryAddedCallback;
import net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1921;
import net.minecraft.class_2248;
import net.minecraft.class_2323;
import net.minecraft.class_2378;
import net.minecraft.class_2533;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_4970;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import org.dimdev.dimdoors.DimensionalDoorsInitializer;
import org.dimdev.dimdoors.block.door.DimensionalDoorBlock;
import org.dimdev.dimdoors.block.door.DimensionalTrapdoorBlock;
import org.dimdev.dimdoors.block.entity.ModBlockEntityTypes;
import org.dimdev.dimdoors.item.DimensionalDoorItemRegistrar;
import org.dimdev.dimdoors.listener.BlockRegistryEntryAddedListener;

public class DimensionalDoorBlockRegistrar {
    private static final String PREFIX = "block_ag_dim_";
    private final class_2378<class_2248> registry;
    private final DimensionalDoorItemRegistrar itemRegistrar;
    private final BiMap<class_2960, class_2960> mappedDoorBlocks = HashBiMap.create();

    public DimensionalDoorBlockRegistrar(class_2378<class_2248> registry, DimensionalDoorItemRegistrar itemRegistrar) {
        this.registry = registry;
        this.itemRegistrar = itemRegistrar;
        this.init();
        RegistryEntryAddedCallback.event(registry).register((Object)new BlockRegistryEntryAddedListener(this));
    }

    private void init() {
        new ArrayList<Map.Entry>(this.registry.method_29722()).forEach(entry -> this.handleEntry(((class_5321)entry.getKey()).method_29177(), (class_2248)entry.getValue()));
    }

    public void handleEntry(class_2960 identifier, class_2248 original) {
        if (DimensionalDoorsInitializer.getConfig().getDoorsConfig().isAllowed(identifier)) {
            if (!(original instanceof DimensionalDoorBlock) && original instanceof class_2323) {
                this.register(identifier, original, DimensionalDoorBlockRegistrar::createAutoGenDimensionalDoorBlock);
            } else if (!(original instanceof DimensionalTrapdoorBlock) && original instanceof class_2533) {
                this.register(identifier, original, DimensionalDoorBlockRegistrar::createAutoGenDimensionalTrapdoorBlock);
            }
        }
    }

    private void register(class_2960 identifier, class_2248 original, BiFunction<class_4970.class_2251, class_2248, ? extends class_2248> constructor) {
        class_2960 gennedId = new class_2960("dimdoors", PREFIX + identifier.method_12836() + "_" + identifier.method_12832());
        class_2248 dimBlock = (class_2248)class_2378.method_10230(this.registry, (class_2960)gennedId, (Object)constructor.apply(FabricBlockSettings.method_9630((class_4970)original), original));
        ModBlockEntityTypes.ENTRANCE_RIFT.addBlock(dimBlock);
        this.mappedDoorBlocks.put((Object)gennedId, (Object)identifier);
        this.itemRegistrar.notifyBlockMapped(original, dimBlock);
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            this.putCutout(dimBlock);
        }
    }

    private void putCutout(class_2248 original) {
        BlockRenderLayerMap.INSTANCE.putBlock(original, class_1921.method_23581());
    }

    public class_2960 get(class_2960 identifier) {
        return (class_2960)this.mappedDoorBlocks.get((Object)identifier);
    }

    public boolean isMapped(class_2960 identifier) {
        return this.mappedDoorBlocks.containsKey((Object)identifier);
    }

    private static <T extends Comparable<T>> class_2680 transferProperty(class_2680 from, class_2680 to, class_2769<T> property) {
        return (class_2680)to.method_11657(property, from.method_11654(property));
    }

    private static AutoGenDimensionalDoorBlock createAutoGenDimensionalDoorBlock(class_4970.class_2251 settings, final class_2248 originalBlock) {
        return new AutoGenDimensionalDoorBlock(settings, originalBlock){

            @Override
            protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
                DimensionalDoorBlockRegistrar.appendPropertiesOverride(builder, originalBlock, new class_2769[]{WATERLOGGED});
            }
        };
    }

    private static AutoGenDimensionalTrapdoorBlock createAutoGenDimensionalTrapdoorBlock(class_4970.class_2251 settings, final class_2248 originalBlock) {
        return new AutoGenDimensionalTrapdoorBlock(settings, originalBlock){

            @Override
            protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
                DimensionalDoorBlockRegistrar.appendPropertiesOverride(builder, originalBlock, new class_2769[]{field_11626});
            }
        };
    }

    private static void appendPropertiesOverride(class_2689.class_2690<class_2248, class_2680> builder, class_2248 originalBlock, class_2769<?> ... requiredProperties) {
        HashSet properties = new HashSet(originalBlock.method_9595().method_11659());
        properties.addAll(List.of(requiredProperties));
        builder.method_11667(properties.toArray(new class_2769[0]));
    }

    private static class AutoGenDimensionalTrapdoorBlock
    extends DimensionalTrapdoorBlock {
        private final class_2248 originalBlock;

        public AutoGenDimensionalTrapdoorBlock(class_4970.class_2251 settings, class_2248 originalBlock) {
            super(settings);
            this.originalBlock = originalBlock;
            class_2680 state = (class_2680)this.method_9595().method_11664();
            class_2680 originalState = originalBlock.method_9564();
            for (class_2769 property : originalBlock.method_9564().method_28501()) {
                state = DimensionalDoorBlockRegistrar.transferProperty(originalState, state, property);
            }
            this.method_9590((class_2680)state.method_11657((class_2769)field_11626, (Comparable)Boolean.valueOf(false)));
        }

        protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
            throw new RuntimeException("AutoGenDimensionalTrapdoorBlock should be instantiated as anonymous inner class overriding appendProperties!");
        }

        public class_5250 method_9518() {
            return new class_2588("dimdoors.autogen_block_prefix").method_10852((class_2561)this.originalBlock.method_9518());
        }
    }

    private static class AutoGenDimensionalDoorBlock
    extends DimensionalDoorBlock {
        private final class_2248 originalBlock;

        public AutoGenDimensionalDoorBlock(class_4970.class_2251 settings, class_2248 originalBlock) {
            super(settings);
            this.originalBlock = originalBlock;
            class_2680 state = (class_2680)this.method_9595().method_11664();
            class_2680 originalState = originalBlock.method_9564();
            for (class_2769 property : originalBlock.method_9564().method_28501()) {
                state = DimensionalDoorBlockRegistrar.transferProperty(originalState, state, property);
            }
            this.method_9590((class_2680)state.method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        }

        @Override
        protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
            throw new RuntimeException("AutoGenDimensionalDoorBlock should be instantiated as anonymous inner class overriding appendProperties!");
        }

        public class_5250 method_9518() {
            return new class_2588("dimdoors.autogen_block_prefix").method_10852((class_2561)this.originalBlock.method_9518());
        }
    }
}

