/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.block.door;

import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2323;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3545;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3614;
import net.minecraft.class_3619;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5712;
import org.dimdev.dimdoors.DimensionalDoorsInitializer;
import org.dimdev.dimdoors.api.block.AfterMoveCollidableBlock;
import org.dimdev.dimdoors.api.block.CustomBreakBlock;
import org.dimdev.dimdoors.api.block.ExplosionConvertibleBlock;
import org.dimdev.dimdoors.api.entity.LastPositionProvider;
import org.dimdev.dimdoors.api.util.math.MathUtil;
import org.dimdev.dimdoors.api.util.math.TransformationMatrix3d;
import org.dimdev.dimdoors.block.CoordinateTransformerBlock;
import org.dimdev.dimdoors.block.ModBlocks;
import org.dimdev.dimdoors.block.RiftProvider;
import org.dimdev.dimdoors.block.door.WaterLoggableDoorBlock;
import org.dimdev.dimdoors.block.entity.DetachedRiftBlockEntity;
import org.dimdev.dimdoors.block.entity.EntranceRiftBlockEntity;
import org.dimdev.dimdoors.block.entity.RiftData;
import org.jetbrains.annotations.Nullable;

public class DimensionalDoorBlock
extends WaterLoggableDoorBlock
implements RiftProvider<EntranceRiftBlockEntity>,
CoordinateTransformerBlock,
ExplosionConvertibleBlock,
CustomBreakBlock,
AfterMoveCollidableBlock {
    public DimensionalDoorBlock(class_4970.class_2251 settings) {
        super(settings);
    }

    public void method_9548(class_2680 state, class_1937 world, class_2338 pos, class_1297 entity) {
        if (world.field_9236 || entity instanceof class_3222) {
            return;
        }
        this.onCollision(state, world, pos, entity, entity.method_19538().method_1020(((LastPositionProvider)entity).getLastPos()));
        super.method_9548(state, world, pos, entity);
    }

    @Override
    public class_1269 onAfterMovePlayerCollision(class_2680 state, class_3218 world, class_2338 pos, class_3222 player, class_243 positionChange) {
        return this.onCollision(state, (class_1937)world, pos, (class_1297)player, positionChange);
    }

    private class_1269 onCollision(class_2680 state, class_1937 world, class_2338 pos, class_1297 entity, class_243 positionChange) {
        class_2338 top = state.method_11654((class_2769)field_10946) == class_2756.field_12609 ? pos : pos.method_10084();
        class_2338 bottom = top.method_10074();
        class_2680 doorState = world.method_8320(bottom);
        if (doorState.method_26204() != this || !((Boolean)doorState.method_11654((class_2769)class_2323.field_10945)).booleanValue()) {
            return class_1269.field_5811;
        }
        class_243 currentPos = entity.method_19538();
        class_243 previousPos = currentPos.method_1020(positionChange);
        double portalHalfWidth = 0.5;
        double portalHeight = 2.0;
        double portalOffsetFromCenter = 0.31;
        class_243 portalNormal = class_243.method_24954((class_2382)((class_2350)state.method_11654((class_2769)field_10938)).method_10153().method_10163());
        class_243 origin = class_243.method_24955((class_2382)bottom);
        class_243 bottomMiddlePortalPoint = origin.method_1019(portalNormal.method_1021(portalOffsetFromCenter));
        double dotCurrent = portalNormal.method_1026(currentPos.method_1020(bottomMiddlePortalPoint));
        double dotPrevious = portalNormal.method_1026(previousPos.method_1020(bottomMiddlePortalPoint));
        if (!((dotCurrent <= 0.0 && dotPrevious >= 0.0 || dotCurrent >= 0.0 && dotPrevious <= 0.0) && (dotCurrent != 0.0 || dotPrevious != 0.0))) {
            return class_1269.field_5811;
        }
        class_243 yVec = new class_243(0.0, 1.0, 0.0);
        class_243 xzVec = portalNormal.method_1036(yVec);
        class_243 vecFromPreviousPosToPortalPlane = bottomMiddlePortalPoint.method_1020(previousPos);
        class_243 normalizedPositionChange = positionChange.method_1029();
        class_243 pointOfIntersection = previousPos.method_1019(normalizedPositionChange.method_1021(vecFromPreviousPosToPortalPlane.method_1026(normalizedPositionChange) / normalizedPositionChange.method_1026(normalizedPositionChange)));
        class_243 intersectionRelativeToPortalPlane = pointOfIntersection.method_1020(bottomMiddlePortalPoint);
        double relativeIntersectionHeight = intersectionRelativeToPortalPlane.method_1026(yVec);
        double relativeIntersectionWidth = intersectionRelativeToPortalPlane.method_1026(xzVec);
        if (relativeIntersectionHeight < 0.0 || relativeIntersectionHeight > portalHeight || Math.abs(relativeIntersectionWidth) > portalHalfWidth) {
            return class_1269.field_5811;
        }
        if (entity.method_30230()) {
            entity.method_30229();
            return class_1269.field_5811;
        }
        entity.method_30229();
        this.getRift(world, pos, state).teleport(entity);
        if (DimensionalDoorsInitializer.getConfig().getDoorsConfig().closeDoorBehind) {
            world.method_8501(top, (class_2680)world.method_8320(top).method_11657((class_2769)class_2323.field_10945, (Comparable)Boolean.valueOf(false)));
            world.method_8501(bottom, (class_2680)world.method_8320(bottom).method_11657((class_2769)class_2323.field_10945, (Comparable)Boolean.valueOf(false)));
        }
        return class_1269.field_5812;
    }

    @Override
    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hitResult) {
        state = (class_2680)state.method_28493((class_2769)field_10945);
        world.method_8652(pos, state, 10);
        if (!world.field_9236 && ((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            world.method_39281(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)world));
        }
        world.method_8444(player, ((Boolean)state.method_11654((class_2769)field_10945)).booleanValue() ? (this.field_23158 == class_3614.field_15953 ? 1005 : 1006) : (this.field_23158 == class_3614.field_15953 ? 1011 : 1012), pos, 0);
        world.method_32888((class_1297)player, this.method_30841(state) ? class_5712.field_28168 : class_5712.field_28169, pos);
        return class_1269.field_5812;
    }

    public boolean method_9616(class_2680 state, class_1750 context) {
        return super.method_9616(state, context) || state.method_26204() == ModBlocks.DETACHED_RIFT;
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        if (state.method_11654((class_2769)class_2323.field_10946) == class_2756.field_12609) {
            return null;
        }
        return new EntranceRiftBlockEntity(pos, state);
    }

    public void createDetachedRift(class_1937 world, class_2338 pos) {
        this.createDetachedRift(world, pos, world.method_8320(pos));
    }

    public void createDetachedRift(class_1937 world, class_2338 pos, class_2680 state) {
        class_2756 doubleBlockHalf = (class_2756)state.method_11654((class_2769)field_10946);
        class_2338 blockPos = pos;
        class_2680 blockState = world.method_8320(pos);
        class_2586 blockEntity = world.method_8321(pos);
        if (doubleBlockHalf == class_2756.field_12609) {
            blockPos = pos.method_10074();
            blockState = world.method_8320(blockPos);
            blockEntity = world.method_8321(blockPos);
        }
        if (blockEntity instanceof EntranceRiftBlockEntity && blockState.method_11654((class_2769)field_10946) == class_2756.field_12607) {
            world.method_8501(blockPos, (class_2680)ModBlocks.DETACHED_RIFT.method_9564().method_11657((class_2769)WATERLOGGED, (Comparable)((Boolean)blockState.method_11654((class_2769)WATERLOGGED))));
            ((DetachedRiftBlockEntity)world.method_8321(blockPos)).setData(((EntranceRiftBlockEntity)blockEntity).getData());
        }
    }

    public void method_9586(class_1937 world, class_2338 pos, class_1927 explosion) {
        if (world.method_8320(pos).method_26215()) {
            return;
        }
        if (world.method_8608()) {
            return;
        }
        class_2680 state = world.method_8320(pos);
        super.method_9586(world, pos, explosion);
    }

    @Override
    public EntranceRiftBlockEntity getRift(class_1937 world, class_2338 pos, class_2680 state) {
        class_2586 topEntity;
        class_2586 bottomEntity;
        if (state.method_11654((class_2769)class_2323.field_10946) == class_2756.field_12607) {
            bottomEntity = world.method_8321(pos);
            topEntity = world.method_8321(pos.method_10084());
        } else {
            bottomEntity = world.method_8321(pos.method_10074());
            topEntity = world.method_8321(pos);
        }
        if (bottomEntity instanceof EntranceRiftBlockEntity && topEntity instanceof EntranceRiftBlockEntity) {
            field_10638.warn("Dimensional door at " + pos + " in world " + world + " contained two rifts, please report this. Defaulting to bottom.");
            return (EntranceRiftBlockEntity)bottomEntity;
        }
        if (bottomEntity instanceof EntranceRiftBlockEntity) {
            return (EntranceRiftBlockEntity)bottomEntity;
        }
        if (topEntity instanceof EntranceRiftBlockEntity) {
            return (EntranceRiftBlockEntity)topEntity;
        }
        throw new IllegalStateException("Dimensional door at " + pos + " in world " + world + " contained no rift.");
    }

    @Override
    public void method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        class_2756 doubleBlockHalf = (class_2756)state.method_11654((class_2769)field_10946);
        class_2338 blockPos = pos;
        class_2680 blockState = world.method_8320(pos);
        class_2586 blockEntity = world.method_8321(pos);
        if (doubleBlockHalf == class_2756.field_12609) {
            blockPos = pos.method_10074();
            blockState = world.method_8320(blockPos);
            blockEntity = world.method_8321(blockPos);
            if (blockState.method_27852(state.method_26204()) && blockState.method_11654((class_2769)field_10946) == class_2756.field_12607) {
                world.method_8652(blockPos, world.method_8316(blockPos).method_15772() == class_3612.field_15910 ? class_2246.field_10382.method_9564() : class_2246.field_10124.method_9564(), 35);
                world.method_8444(player, 2001, blockPos, class_2248.method_9507((class_2680)blockState));
            }
            if (blockEntity instanceof EntranceRiftBlockEntity && blockState.method_11654((class_2769)field_10946) == class_2756.field_12607 && (!player.method_7337() || DimensionalDoorsInitializer.getConfig().getDoorsConfig().placeRiftsInCreativeMode)) {
                world.method_8501(blockPos, (class_2680)ModBlocks.DETACHED_RIFT.method_9564().method_11657((class_2769)WATERLOGGED, (Comparable)((Boolean)blockState.method_11654((class_2769)WATERLOGGED))));
                ((DetachedRiftBlockEntity)world.method_8321(blockPos)).setData(((EntranceRiftBlockEntity)blockEntity).getData());
            }
        }
        super.method_9576(world, pos, state, player);
    }

    public class_265 method_9584(class_2680 state, class_1922 world, class_2338 pos) {
        return class_259.method_1077();
    }

    @Override
    public TransformationMatrix3d.TransformationMatrix3dBuilder transformationBuilder(class_2680 state, class_2338 pos) {
        return TransformationMatrix3d.builder().inverseTranslate(class_243.method_24953((class_2382)pos).method_1019(class_243.method_24954((class_2382)((class_2350)state.method_11654((class_2769)class_2323.field_10938)).method_10163()).method_1021(-0.31))).inverseRotate(MathUtil.directionEulerAngle(((class_2350)state.method_11654((class_2769)class_2323.field_10938)).method_10153()));
    }

    @Override
    public TransformationMatrix3d.TransformationMatrix3dBuilder rotatorBuilder(class_2680 state, class_2338 pos) {
        return TransformationMatrix3d.builder().inverseRotate(MathUtil.directionEulerAngle(((class_2350)state.method_11654((class_2769)class_2323.field_10938)).method_10153()));
    }

    @Override
    public boolean isExitFlipped() {
        return true;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean isTall(class_2680 cachedState) {
        return true;
    }

    @Override
    public class_1269 explode(class_1937 world, class_2338 pos, class_2680 state, class_2586 blockEntity) {
        if (blockEntity == null) {
            return class_1269.field_5811;
        }
        this.createDetachedRift(world, pos, state);
        return class_1269.field_5812;
    }

    public class_3619 method_9527(class_2680 state) {
        return state.method_11654((class_2769)field_10946) == class_2756.field_12607 ? class_3619.field_15972 : super.method_9527(state);
    }

    @Override
    public class_1271<class_3545<class_2680, Consumer<class_2586>>> customBreakBlock(class_1937 world, class_2338 pos, class_2680 blockState, class_1297 breakingEntity) {
        if (blockState.method_11654((class_2769)field_10946) != class_2756.field_12607) {
            return class_1271.method_22430(null);
        }
        RiftData data = ((EntranceRiftBlockEntity)world.method_8321(pos)).getData();
        return class_1271.method_22427((Object)new class_3545((Object)((class_2680)ModBlocks.DETACHED_RIFT.method_9564().method_11657((class_2769)WATERLOGGED, (Comparable)((Boolean)blockState.method_11654((class_2769)WATERLOGGED)))), blockEntity -> ((DetachedRiftBlockEntity)blockEntity).setData(data)));
    }

    static {
        PlayerBlockBreakEvents.AFTER.register((world, player, pos, state, blockEntity) -> {
            if (player.method_7337() && !DimensionalDoorsInitializer.getConfig().getDoorsConfig().placeRiftsInCreativeMode) {
                return;
            }
            if (blockEntity instanceof EntranceRiftBlockEntity && state.method_11654((class_2769)field_10946) == class_2756.field_12607) {
                world.method_8501(pos, (class_2680)ModBlocks.DETACHED_RIFT.method_9564().method_11657((class_2769)WATERLOGGED, (Comparable)((Boolean)state.method_11654((class_2769)WATERLOGGED))));
                ((DetachedRiftBlockEntity)world.method_8321(pos)).setData(((EntranceRiftBlockEntity)blockEntity).getData());
            }
        });
    }
}

