/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.api.util.math;

import net.minecraft.class_2379;
import net.minecraft.class_243;
import org.dimdev.dimdoors.api.util.math.AbstractMatrixd;
import org.dimdev.dimdoors.api.util.math.MathUtil;
import org.dimdev.dimdoors.api.util.math.Matrixd;
import org.dimdev.dimdoors.api.util.math.TransformationMatrixdImpl;
import org.dimdev.dimdoors.api.util.math.Vectord;

public class TransformationMatrix3d
extends TransformationMatrixdImpl<TransformationMatrix3d> {
    public TransformationMatrix3d(double[][] matrix) {
        super(matrix);
    }

    public TransformationMatrix3d(AbstractMatrixd<? extends AbstractMatrixd<?>> matrix) {
        super(matrix);
    }

    public TransformationMatrix3d(Vectord ... vectors) {
        super(vectors);
    }

    public static TransformationMatrix3d identity() {
        return new TransformationMatrix3d(Matrixd.identity(4, 4));
    }

    @Override
    public TransformationMatrix3d construct(double[][] matrix) {
        return new TransformationMatrix3d(matrix);
    }

    @Override
    public TransformationMatrix3d construct(AbstractMatrixd<? extends AbstractMatrixd<?>> matrixd) {
        return new TransformationMatrix3d(matrixd);
    }

    @Override
    public TransformationMatrix3d construct(Vectord ... vectors) {
        return new TransformationMatrix3d(vectors);
    }

    public class_243 transform(class_243 vector) {
        Vectord vec = this.transform(new Vectord(vector.field_1352, vector.field_1351, vector.field_1350));
        return new class_243(vec.get(0), vec.get(1), vec.get(2));
    }

    public class_2379 transform(class_2379 angle) {
        TransformationMatrix3d rotator = (TransformationMatrix3d)TransformationMatrix3d.builder().rotate(angle).build();
        class_243 direction = rotator.transform(new class_243(0.0, 0.0, 1.0));
        class_243 upwards = rotator.transform(new class_243(0.0, 1.0, 0.0));
        direction = this.transform(direction);
        upwards = this.transform(upwards);
        return MathUtil.eulerAngle(direction, upwards);
    }

    public static TransformationMatrix3dBuilder builder() {
        return new TransformationMatrix3dBuilder(TransformationMatrix3d.identity());
    }

    public static class TransformationMatrix3dBuilder
    extends TransformationMatrixdImpl.TransformationMatrixdBuilderImpl<TransformationMatrix3dBuilder, TransformationMatrix3d> {
        protected TransformationMatrix3dBuilder(TransformationMatrix3d instance) {
            super(3, instance);
        }

        @Override
        public TransformationMatrix3dBuilder getSelf() {
            return this;
        }

        public TransformationMatrix3dBuilder translate(class_243 vector) {
            return (TransformationMatrix3dBuilder)this.translate(new Vectord(vector.field_1352, vector.field_1351, vector.field_1350));
        }

        public TransformationMatrix3dBuilder inverseTranslate(class_243 vector) {
            return (TransformationMatrix3dBuilder)this.translate(new Vectord(-vector.field_1352, -vector.field_1351, -vector.field_1350));
        }

        public TransformationMatrix3dBuilder rotateX(double angle) {
            return (TransformationMatrix3dBuilder)this.rotateAroundBasePlane(angle, 1, 2);
        }

        public TransformationMatrix3dBuilder rotateY(double angle) {
            return (TransformationMatrix3dBuilder)this.rotateAroundBasePlane(angle, 2, 0);
        }

        public TransformationMatrix3dBuilder rotateZ(double angle) {
            return (TransformationMatrix3dBuilder)this.rotateAroundBasePlane(angle, 0, 1);
        }

        public TransformationMatrix3dBuilder rotate(class_2379 angle) {
            return this.rotateZ(Math.toRadians(angle.method_10258())).rotateX(Math.toRadians(angle.method_10256())).rotateY(Math.toRadians(-angle.method_10257()));
        }

        public TransformationMatrix3dBuilder inverseRotate(class_2379 angle) {
            return this.rotateZ(-Math.toRadians(angle.method_10258())).rotateX(-Math.toRadians(angle.method_10256())).rotateY(-Math.toRadians(-angle.method_10257()));
        }
    }
}

