/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import me.shedaniel.autoconfig.serializer.ConfigSerializer;
import me.shedaniel.autoconfig.util.Utils;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.Jankson;
import me.shedaniel.clothconfig2.gui.entries.SelectionListEntry;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.EnvironmentInterface;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
import net.minecraft.class_2960;
import org.dimdev.dimdoors.DimensionalDoorsInitializer;
import org.jetbrains.annotations.NotNull;

@Config(name="dimdoors")
public final class ModConfig
implements ConfigData {
    @ConfigEntry.Gui.TransitiveObject
    @ConfigEntry.Category(value="general")
    private General general = new General();
    @ConfigEntry.Gui.TransitiveObject
    @ConfigEntry.Category(value="pockets")
    private Pockets pockets = new Pockets();
    @ConfigEntry.Gui.TransitiveObject
    @ConfigEntry.Category(value="world")
    private World world = new World();
    @ConfigEntry.Gui.TransitiveObject
    @ConfigEntry.Category(value="dungeons")
    private Dungeons dungeons = new Dungeons();
    @ConfigEntry.Gui.TransitiveObject
    @ConfigEntry.Category(value="monoliths")
    private Monoliths monoliths = new Monoliths();
    @ConfigEntry.Gui.TransitiveObject
    @ConfigEntry.Category(value="limbo")
    private Limbo limbo = new Limbo();
    @ConfigEntry.Gui.TransitiveObject
    @ConfigEntry.Category(value="graphics")
    private Graphics graphics = new Graphics();
    @ConfigEntry.Gui.TransitiveObject
    @ConfigEntry.Category(value="doors")
    private Doors doors = new Doors();

    public General getGeneralConfig() {
        return this.general;
    }

    public Pockets getPocketsConfig() {
        return this.pockets;
    }

    public World getWorldConfig() {
        return this.world;
    }

    public Dungeons getDungeonsConfig() {
        return this.dungeons;
    }

    public Monoliths getMonolithsConfig() {
        return this.monoliths;
    }

    public Limbo getLimboConfig() {
        return this.limbo;
    }

    public Graphics getGraphicsConfig() {
        return this.graphics;
    }

    public Doors getDoorsConfig() {
        return this.doors;
    }

    public static class General {
        @ConfigEntry.Gui.Tooltip
        public double teleportOffset = 0.0;
        @ConfigEntry.Gui.Tooltip
        public boolean riftBoundingBoxInCreative;
        @ConfigEntry.Gui.Tooltip
        public double riftCloseSpeed = 0.01;
        @ConfigEntry.Gui.Tooltip
        public double riftGrowthSpeed = 1.0;
        @ConfigEntry.Gui.Tooltip
        public int depthSpreadFactor = 20;
        @ConfigEntry.Gui.Tooltip
        public double endermanSpawnChance = 5.0E-5;
        @ConfigEntry.Gui.Tooltip
        public double endermanAggressiveChance = 0.5;
    }

    public static class Pockets {
        @ConfigEntry.Gui.Tooltip
        public int pocketGridSize = 32;
        @ConfigEntry.Gui.Tooltip
        public int maxPocketSize = 15;
        @ConfigEntry.Gui.Tooltip
        public int privatePocketSize = 2;
        @ConfigEntry.Gui.Tooltip
        public int publicPocketSize = 1;
        @ConfigEntry.Gui.Tooltip
        public String defaultWeightEquation = "5";
        @ConfigEntry.Gui.Tooltip
        public int fallbackWeight = 5;
        @ConfigEntry.Gui.Tooltip
        @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
        public ExtendedResourcePackActivationType classicPocketsResourcePackActivationType = ExtendedResourcePackActivationType.DEFAULT_ENABLED;
        @ConfigEntry.Gui.Tooltip
        @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
        public ExtendedResourcePackActivationType defaultPocketsResourcePackActivationType = ExtendedResourcePackActivationType.DEFAULT_ENABLED;
        @ConfigEntry.Gui.Tooltip
        public boolean asyncWorldEditPocketLoading = true;
        @ConfigEntry.Gui.Tooltip
        public boolean canUseRiftSignatureInPrivatePockets = true;
    }

    public static class World {
        @ConfigEntry.Gui.RequiresRestart
        @ConfigEntry.Gui.Tooltip
        public double clusterGenChance = 20000.0;
        @ConfigEntry.Gui.RequiresRestart
        @ConfigEntry.Gui.Tooltip
        public int gatewayGenChance = 200;
        @ConfigEntry.Gui.RequiresRestart
        @ConfigEntry.Gui.Tooltip
        public List<String> clusterDimBlacklist = new LinkedList<String>();
        @ConfigEntry.Gui.RequiresRestart
        @ConfigEntry.Gui.Tooltip
        public List<String> gatewayDimBlacklist = new LinkedList<String>();
    }

    public static class Dungeons {
        @ConfigEntry.Gui.Tooltip
        public int maxDungeonDepth = 50;
    }

    public static class Monoliths {
        @ConfigEntry.Gui.Tooltip
        public boolean dangerousLimboMonoliths = false;
        @ConfigEntry.Gui.Tooltip
        public boolean monolithTeleportation = true;
    }

    public static class Limbo {
        @ConfigEntry.Gui.Tooltip
        public boolean universalLimbo = false;
        @ConfigEntry.Gui.Tooltip
        public boolean hardcoreLimbo = false;
        @ConfigEntry.Gui.Tooltip
        public double decaySpreadChance = 1.0;
        @ConfigEntry.Gui.Tooltip
        public float limboBlocksCorruptingOverworldAmount = 5.0f;
    }

    public static class Graphics {
        @ConfigEntry.Gui.Tooltip
        public boolean showRiftCore = false;
        @ConfigEntry.Gui.Tooltip
        public int highlightRiftCoreFor = 15000;
        @ConfigEntry.Gui.Tooltip
        public double riftSize = 1.0;
        @ConfigEntry.Gui.Tooltip
        public double riftJitter = 1.0;
    }

    public static class Doors {
        @ConfigEntry.Gui.Tooltip
        public boolean closeDoorBehind = true;
        @ConfigEntry.Gui.Tooltip
        @ConfigEntry.Gui.CollapsibleObject
        public DoorList doorList = new DoorList();
        @ConfigEntry.Gui.Tooltip
        public boolean placeRiftsInCreativeMode = true;

        public boolean isAllowed(class_2960 id) {
            String idStr = id.toString();
            boolean contains = this.doorList.doors.contains(idStr);
            return this.doorList.mode == DoorList.Mode.ENABLE == contains;
        }

        public static class DoorList {
            @ConfigEntry.Gui.Tooltip
            public Mode mode = Mode.DISABLE;
            @ConfigEntry.Gui.Tooltip
            public Set<String> doors = new HashSet<String>();

            @EnvironmentInterface(value=EnvType.CLIENT, itf=SelectionListEntry.Translatable.class)
            public static enum Mode implements SelectionListEntry.Translatable
            {
                ENABLE("dimdoors.mode.enable"),
                DISABLE("dimdoors.mode.disable");

                private String translationKey;

                private Mode(String translationKey) {
                    this.translationKey = translationKey;
                }

                @NotNull
                public String getKey() {
                    return this.translationKey;
                }
            }
        }
    }

    public static class SubRootJanksonConfigSerializer<T extends ConfigData>
    implements ConfigSerializer<T> {
        private static final Jankson JANKSON = Jankson.builder().build();
        private final Config definition;
        private final Class<T> configClass;

        public SubRootJanksonConfigSerializer(Config definition, Class<T> configClass) {
            this.definition = definition;
            this.configClass = configClass;
        }

        private Path getConfigPath() {
            return DimensionalDoorsInitializer.getConfigRoot().resolve(this.definition.name() + "-config.json5");
        }

        public void serialize(T config) throws ConfigSerializer.SerializationException {
            Path configPath = this.getConfigPath();
            try {
                Files.createDirectories(configPath.getParent(), new FileAttribute[0]);
                BufferedWriter writer = Files.newBufferedWriter(configPath, new OpenOption[0]);
                writer.write(JANKSON.toJson(config).toJson(true, true));
                writer.close();
            }
            catch (IOException e) {
                throw new ConfigSerializer.SerializationException((Throwable)e);
            }
        }

        public T deserialize() throws ConfigSerializer.SerializationException {
            Path configPath = this.getConfigPath();
            if (Files.exists(configPath, new LinkOption[0])) {
                try {
                    return (T)((ConfigData)JANKSON.fromJson(JANKSON.load(this.getConfigPath().toFile()), this.configClass));
                }
                catch (Throwable e) {
                    throw new ConfigSerializer.SerializationException(e);
                }
            }
            return this.createDefault();
        }

        public T createDefault() {
            return (T)((ConfigData)Utils.constructUnsafely(this.configClass));
        }
    }

    @EnvironmentInterface(value=EnvType.CLIENT, itf=SelectionListEntry.Translatable.class)
    public static enum ExtendedResourcePackActivationType implements SelectionListEntry.Translatable
    {
        NORMAL(ResourcePackActivationType.NORMAL, "resourcePackActivationType.normal"),
        DEFAULT_ENABLED(ResourcePackActivationType.DEFAULT_ENABLED, "resourcePackActivationType.defaultEnabled"),
        ALWAYS_ENABLED(ResourcePackActivationType.ALWAYS_ENABLED, "resourcePackActivationType.alwaysEnabled");

        private final ResourcePackActivationType resourcePackActivationType;
        private final String translationKey;

        private ExtendedResourcePackActivationType(ResourcePackActivationType resourcePackActivationType, String translationKey) {
            this.resourcePackActivationType = resourcePackActivationType;
            this.translationKey = translationKey;
        }

        public ResourcePackActivationType asResourcePackActivationType() {
            return this.resourcePackActivationType;
        }

        @NotNull
        public String getKey() {
            return this.translationKey;
        }
    }
}

