/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors;

import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigHolder;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerChunkEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.player.AttackBlockCallback;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.event.player.UseItemCallback;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3264;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import org.dimdev.dimdoors.ModConfig;
import org.dimdev.dimdoors.api.DimensionalDoorsApi;
import org.dimdev.dimdoors.api.event.UseItemOnBlockCallback;
import org.dimdev.dimdoors.block.ModBlocks;
import org.dimdev.dimdoors.block.door.DimensionalDoorBlockRegistrar;
import org.dimdev.dimdoors.block.door.data.condition.Condition;
import org.dimdev.dimdoors.block.entity.ModBlockEntityTypes;
import org.dimdev.dimdoors.command.ModCommands;
import org.dimdev.dimdoors.command.PocketCommand;
import org.dimdev.dimdoors.criteria.ModCriteria;
import org.dimdev.dimdoors.enchantment.ModEnchants;
import org.dimdev.dimdoors.entity.ModEntityTypes;
import org.dimdev.dimdoors.entity.stat.ModStats;
import org.dimdev.dimdoors.fluid.ModFluids;
import org.dimdev.dimdoors.item.DimensionalDoorItemRegistrar;
import org.dimdev.dimdoors.item.ModItems;
import org.dimdev.dimdoors.listener.AttackBlockCallbackListener;
import org.dimdev.dimdoors.listener.ChunkLoadListener;
import org.dimdev.dimdoors.listener.UseDoorItemOnBlockCallbackListener;
import org.dimdev.dimdoors.listener.pocket.PlayerBlockBreakEventBeforeListener;
import org.dimdev.dimdoors.listener.pocket.PocketAttackBlockCallbackListener;
import org.dimdev.dimdoors.listener.pocket.UseBlockCallbackListener;
import org.dimdev.dimdoors.listener.pocket.UseItemCallbackListener;
import org.dimdev.dimdoors.listener.pocket.UseItemOnBlockCallbackListener;
import org.dimdev.dimdoors.network.ExtendedServerPlayNetworkHandler;
import org.dimdev.dimdoors.particle.ModParticleTypes;
import org.dimdev.dimdoors.pockets.PocketLoader;
import org.dimdev.dimdoors.pockets.generator.PocketGenerator;
import org.dimdev.dimdoors.pockets.modifier.Modifier;
import org.dimdev.dimdoors.pockets.virtual.ImplementedVirtualPocket;
import org.dimdev.dimdoors.rift.targets.Targets;
import org.dimdev.dimdoors.rift.targets.VirtualTarget;
import org.dimdev.dimdoors.sound.ModSoundEvents;
import org.dimdev.dimdoors.world.ModBiomes;
import org.dimdev.dimdoors.world.ModDimensions;
import org.dimdev.dimdoors.world.decay.DecayPredicate;
import org.dimdev.dimdoors.world.decay.DecayProcessor;
import org.dimdev.dimdoors.world.decay.LimboDecay;
import org.dimdev.dimdoors.world.feature.ModFeatures;
import org.dimdev.dimdoors.world.pocket.type.AbstractPocket;
import org.dimdev.dimdoors.world.pocket.type.addon.PocketAddon;
import org.jetbrains.annotations.NotNull;

public class DimensionalDoorsInitializer
implements ModInitializer {
    public static List<DimensionalDoorsApi> apiSubscribers = Collections.emptyList();
    private static final Supplier<Path> CONFIG_ROOT = () -> FabricLoader.getInstance().getConfigDir().resolve("dimdoors").toAbsolutePath();
    private static final ConfigHolder<ModConfig> CONFIG_MANAGER = AutoConfig.register(ModConfig.class, ModConfig.SubRootJanksonConfigSerializer::new);
    private static MinecraftServer server;
    private static ModContainer dimDoorsMod;
    private static DimensionalDoorBlockRegistrar dimensionalDoorBlockRegistrar;
    private static DimensionalDoorItemRegistrar dimensionalDoorItemRegistrar;

    @NotNull
    public static MinecraftServer getServer() {
        if (server != null) {
            return server;
        }
        throw new UnsupportedOperationException("Accessed server too early!");
    }

    public static DimensionalDoorBlockRegistrar getDimensionalDoorBlockRegistrar() {
        return dimensionalDoorBlockRegistrar;
    }

    public static DimensionalDoorItemRegistrar getDimensionalDoorItemRegistrar() {
        return dimensionalDoorItemRegistrar;
    }

    public static class_3218 getWorld(class_5321<class_1937> key) {
        return DimensionalDoorsInitializer.getServer().method_3847(key);
    }

    public static ModConfig getConfig() {
        return (ModConfig)CONFIG_MANAGER.get();
    }

    public static ModContainer getDimDoorsMod() {
        return dimDoorsMod;
    }

    public static Path getConfigRoot() {
        return CONFIG_ROOT.get();
    }

    public void onInitialize() {
        apiSubscribers = FabricLoader.getInstance().getEntrypoints("dimdoors:api", DimensionalDoorsApi.class);
        dimDoorsMod = (ModContainer)FabricLoader.getInstance().getModContainer("dimdoors").orElseThrow(RuntimeException::new);
        ServerLifecycleEvents.SERVER_STARTING.register(minecraftServer -> {
            server = minecraftServer;
        });
        DimensionalDoorsInitializer.registerRegistries();
        ModBlocks.init();
        ModItems.init();
        ModFeatures.init();
        ModBiomes.init();
        ModDimensions.init();
        ModEntityTypes.init();
        ModStats.init();
        ModBlockEntityTypes.init();
        ModCommands.init();
        ModFluids.init();
        ModSoundEvents.init();
        ModParticleTypes.init();
        ModCriteria.init();
        ModEnchants.init();
        dimensionalDoorItemRegistrar = new DimensionalDoorItemRegistrar((class_2378<class_1792>)class_2378.field_11142);
        dimensionalDoorBlockRegistrar = new DimensionalDoorBlockRegistrar((class_2378<class_2248>)class_2378.field_11146, dimensionalDoorItemRegistrar);
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)PocketLoader.getInstance());
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)LimboDecay.DecayLoader.getInstance());
        ResourceManagerHelper.registerBuiltinResourcePack((class_2960)new class_2960("dimdoors", "default"), (ModContainer)dimDoorsMod, (ResourcePackActivationType)((ModConfig)DimensionalDoorsInitializer.CONFIG_MANAGER.get()).getPocketsConfig().defaultPocketsResourcePackActivationType.asResourcePackActivationType());
        ResourceManagerHelper.registerBuiltinResourcePack((class_2960)new class_2960("dimdoors", "classic"), (ModContainer)dimDoorsMod, (ResourcePackActivationType)((ModConfig)DimensionalDoorsInitializer.CONFIG_MANAGER.get()).getPocketsConfig().classicPocketsResourcePackActivationType.asResourcePackActivationType());
        this.registerListeners();
        apiSubscribers.forEach(DimensionalDoorsApi::postInitialize);
    }

    public static void registerRegistries() {
        Targets.registerDefaultTargets();
        VirtualTarget.VirtualTargetType.register();
        ImplementedVirtualPocket.VirtualPocketType.register();
        Modifier.ModifierType.register();
        PocketGenerator.PocketGeneratorType.register();
        AbstractPocket.AbstractPocketType.register();
        PocketAddon.PocketAddonType.register();
        Condition.ConditionType.register();
        DecayPredicate.DecayPredicateType.register();
        DecayProcessor.DecayProcessorType.register();
    }

    private void registerListeners() {
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> ((ExtendedServerPlayNetworkHandler)handler).getDimDoorsPacketHandler().init());
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> {
            ((ExtendedServerPlayNetworkHandler)handler).getDimDoorsPacketHandler().unregister();
            PocketCommand.logSetting.remove(handler.method_32311().method_5667());
        });
        ServerChunkEvents.CHUNK_LOAD.register((Object)new ChunkLoadListener());
        AttackBlockCallback.EVENT.register((Object)new AttackBlockCallbackListener());
        AttackBlockCallback.EVENT.register((Object)new PocketAttackBlockCallbackListener());
        PlayerBlockBreakEvents.BEFORE.register((Object)new PlayerBlockBreakEventBeforeListener());
        UseItemCallback.EVENT.register((Object)new UseItemCallbackListener());
        UseItemOnBlockCallback.EVENT.register((Object)new UseItemOnBlockCallbackListener());
        UseBlockCallback.EVENT.register((Object)new UseBlockCallbackListener());
        UseItemOnBlockCallback.EVENT.register((Object)new UseDoorItemOnBlockCallbackListener());
    }
}

