/*
 * Decompiled with CFR 0.152.
 */
package paulevs.edenring.world.generator;

import com.google.common.collect.Lists;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.class_2338;
import net.minecraft.class_3532;
import paulevs.edenring.world.generator.GeneratorOptions;
import paulevs.edenring.world.generator.IslandLayer;
import ru.bclib.util.MHelper;

public class TerrainGenerator {
    private static final float[] COEF;
    private static final Point[] OFFS;
    private final IslandLayer largeIslands;
    private final IslandLayer mediumIslands;
    private final IslandLayer smallIslands;

    public TerrainGenerator(long seed) {
        Random random = new Random(seed);
        this.largeIslands = new IslandLayer(random.nextInt(), GeneratorOptions.bigOptions);
        this.mediumIslands = new IslandLayer(random.nextInt(), GeneratorOptions.mediumOptions);
        this.smallIslands = new IslandLayer(random.nextInt(), GeneratorOptions.smallOptions);
    }

    public void fillTerrainDensity(double[] buffer, class_2338 pos, double scaleXZ, double scaleY, float[] floatBuffer) {
        this.fillTerrainDensity(floatBuffer, pos, scaleXZ, scaleY);
        for (int i = 0; i < buffer.length; i = (int)((short)(i + 1))) {
            buffer[i] = floatBuffer[i];
        }
    }

    public void fillTerrainDensity(float[] buffer, class_2338 pos, double scaleXZ, double scaleY) {
        this.largeIslands.clearCache();
        this.mediumIslands.clearCache();
        this.smallIslands.clearCache();
        int x = class_3532.method_15357((double)((double)pos.method_10263() / scaleXZ));
        int z = class_3532.method_15357((double)((double)pos.method_10260() / scaleXZ));
        double px = (double)x * scaleXZ;
        double pz = (double)z * scaleXZ;
        this.largeIslands.updatePositions(px, pz);
        this.mediumIslands.updatePositions(px, pz);
        this.smallIslands.updatePositions(px, pz);
        for (int y = 0; y < buffer.length; ++y) {
            double py = (double)y * scaleY + (double)pos.method_10264();
            float dist = this.largeIslands.getDensity(px, py, pz);
            if (dist < 0.3f) {
                dist = MHelper.max((float)dist, (float)this.mediumIslands.getDensity(px, py, pz));
            }
            if (dist < 0.3f) {
                dist = MHelper.max((float)dist, (float)this.smallIslands.getDensity(px, py, pz));
            }
            buffer[y] = dist;
        }
    }

    static {
        float sum = 0.0f;
        ArrayList coef = Lists.newArrayList();
        ArrayList pos = Lists.newArrayList();
        for (int x = -3; x <= 3; ++x) {
            for (int z = -3; z <= 3; ++z) {
                float dist = MHelper.length((float)x, (float)z) / 3.0f;
                if (!(dist <= 1.0f)) continue;
                sum += dist;
                coef.add(Float.valueOf(dist));
                pos.add(new Point(x, z));
            }
        }
        OFFS = pos.toArray(new Point[0]);
        COEF = new float[coef.size()];
        for (int i = 0; i < COEF.length; ++i) {
            TerrainGenerator.COEF[i] = ((Float)coef.get(i)).floatValue() / sum;
        }
    }
}

