/*
 * Decompiled with CFR 0.152.
 */
package paulevs.edenring.world.generator;

import java.util.Random;
import java.util.function.BiFunction;
import net.minecraft.class_3532;
import paulevs.edenring.world.generator.LayerOptions;
import ru.bclib.noise.OpenSimplexNoise;
import ru.bclib.sdf.SDF;
import ru.bclib.sdf.operator.SDFBinary;
import ru.bclib.sdf.operator.SDFCoordModify;
import ru.bclib.sdf.operator.SDFDisplacement;
import ru.bclib.sdf.operator.SDFScale;
import ru.bclib.sdf.operator.SDFScale3D;
import ru.bclib.sdf.operator.SDFSmoothUnion;
import ru.bclib.sdf.operator.SDFTranslate;
import ru.bclib.sdf.operator.SDFUnary;
import ru.bclib.sdf.operator.SDFUnion;
import ru.bclib.sdf.primitive.SDFCappedCone;
import ru.bclib.sdf.primitive.SDFSphere;
import ru.bclib.util.MHelper;
import ru.bclib.util.WeightedList;

public class IslandTypes {
    private static final WeightedList<BiFunction<LayerOptions, Random, SDF>> ISLAND_FUNCTIONS = new WeightedList();

    public static SDF getIsland(LayerOptions options, Random random) {
        return (SDF)((BiFunction)ISLAND_FUNCTIONS.get(random)).apply(options, random);
    }

    private static SDF makeCone(float radiusBottom, float radiusTop, float height, float minY) {
        float hh = height * 0.5f;
        SDFCappedCone sdf = new SDFCappedCone().setHeight(hh).setRadius1(radiusBottom).setRadius2(radiusTop);
        return new SDFTranslate().setTranslate(0.0f, minY + hh, 0.0f).setSource((SDF)sdf);
    }

    private static BiFunction<LayerOptions, Random, SDF> makeSimpleIsland() {
        SDF cone1 = IslandTypes.makeCone(0.0f, 0.4f, 0.2f, -0.3f);
        SDF cone2 = IslandTypes.makeCone(0.4f, 0.5f, 0.1f, -0.1f);
        SDF cone3 = IslandTypes.makeCone(0.5f, 0.45f, 0.03f, 0.0f);
        SDF cone4 = IslandTypes.makeCone(0.45f, 0.0f, 0.02f, 0.03f);
        SDFBinary coneBottom = new SDFSmoothUnion().setRadius(0.02f).setSourceA(cone1).setSourceB(cone2);
        SDFBinary coneTop = new SDFSmoothUnion().setRadius(0.02f).setSourceA(cone3).setSourceB(cone4);
        SDFBinary defaultIsland = new SDFSmoothUnion().setRadius(0.01f).setSourceA((SDF)coneTop).setSourceB((SDF)coneBottom);
        return (arg_0, arg_1) -> IslandTypes.lambda$makeSimpleIsland$1((SDF)defaultIsland, arg_0, arg_1);
    }

    private static BiFunction<LayerOptions, Random, SDF> makeTallSphereIsland() {
        SDFSphere sphere = new SDFSphere().setRadius(1.0f);
        SDFSphere defaultIsland = sphere = new SDFScale3D().setScale(0.25f, 1.0f, 0.25f).setSource((SDF)sphere);
        return (arg_0, arg_1) -> IslandTypes.lambda$makeTallSphereIsland$3((SDF)defaultIsland, arg_0, arg_1);
    }

    private static BiFunction<LayerOptions, Random, SDF> makeDoubleConeIsland() {
        SDF cone1 = IslandTypes.makeCone(0.0f, 0.4f, 0.2f, -0.3f);
        SDF cone2 = IslandTypes.makeCone(0.4f, 0.5f, 0.1f, -0.1f);
        SDF cone3 = IslandTypes.makeCone(0.5f, 0.45f, 0.03f, 0.0f);
        SDF cone4 = IslandTypes.makeCone(0.45f, 0.0f, 0.02f, 0.03f);
        SDF cone5 = IslandTypes.makeCone(0.35f, 0.12f, 0.15f, 0.03f);
        SDF cone6 = IslandTypes.makeCone(0.12f, 0.0f, 0.15f, 0.18f);
        SDFBinary coneBottom = new SDFSmoothUnion().setRadius(0.02f).setSourceA(cone1).setSourceB(cone2);
        SDFBinary coneTop = new SDFSmoothUnion().setRadius(0.02f).setSourceA(cone3).setSourceB(cone4);
        SDFBinary merged = new SDFSmoothUnion().setRadius(0.02f).setSourceA((SDF)coneTop).setSourceB((SDF)coneBottom);
        SDFBinary mountain = new SDFSmoothUnion().setRadius(0.02f).setSourceA(cone5).setSourceB(cone6);
        return (arg_0, arg_1) -> IslandTypes.lambda$makeDoubleConeIsland$6((SDF)merged, (SDF)mountain, arg_0, arg_1);
    }

    private static /* synthetic */ SDF lambda$makeDoubleConeIsland$6(SDF merged, SDF mountain, LayerOptions options, Random random) {
        OpenSimplexNoise noise1 = new OpenSimplexNoise((long)random.nextInt());
        OpenSimplexNoise noise2 = new OpenSimplexNoise((long)random.nextInt());
        float scale1 = options.scale * 0.0125f;
        float scale2 = options.scale * 0.025f;
        float scale3 = options.scale * 0.05f;
        float scale4 = options.scale * 0.1f;
        float islandScale = random.nextFloat() + 0.5f;
        SDFUnary islandBottom = new SDFScale().setScale(islandScale).setSource(merged);
        islandBottom = new SDFCoordModify().setFunction(pos -> {
            float x1 = pos.method_4943() * scale1;
            float z1 = pos.method_4947() * scale1;
            float x2 = pos.method_4943() * scale2;
            float z2 = pos.method_4947() * scale2;
            float x3 = pos.method_4943() * scale3;
            float z3 = pos.method_4947() * scale3;
            float dx = (float)noise1.eval((double)x1, (double)z1) * 20.0f + (float)noise2.eval((double)x2, (double)z2) * 10.0f;
            float dy = (float)noise1.eval((double)x3, (double)z3) * 6.0f + (float)noise2.eval((double)x3, (double)z3) * 3.0f;
            float dz = (float)noise2.eval((double)x1, (double)z1) * 20.0f + (float)noise1.eval((double)x2, (double)z2) * 10.0f;
            pos.method_4949(pos.method_4943() + dx / options.scale, pos.method_4945() + dy / options.scale, pos.method_4947() + dz / options.scale);
        }).setSource((SDF)islandBottom);
        SDFUnary islandTop = new SDFScale().setScale(islandScale).setSource(mountain);
        islandTop = new SDFCoordModify().setFunction(pos -> {
            float x1 = pos.method_4943() * scale1;
            float z1 = pos.method_4947() * scale1;
            float x2 = pos.method_4943() * scale2;
            float z2 = pos.method_4947() * scale2;
            float x3 = pos.method_4943() * scale3;
            float z3 = pos.method_4947() * scale3;
            float x4 = pos.method_4943() * scale4;
            float z4 = pos.method_4947() * scale4;
            float dx = (float)noise1.eval((double)x1, (double)z1) * 20.0f + (float)noise2.eval((double)x2, (double)z2) * 10.0f;
            float dy = (float)noise1.eval((double)x3, (double)z3) * 15.0f + (float)noise2.eval((double)x3, (double)z3) * 8.0f + (float)noise1.eval((double)x4, (double)z4) * 3.0f;
            float dz = (float)noise2.eval((double)x1, (double)z1) * 20.0f + (float)noise1.eval((double)x2, (double)z2) * 10.0f;
            pos.method_4949(pos.method_4943() + dx / options.scale, pos.method_4945() + dy / options.scale, pos.method_4947() + dz / options.scale);
        }).setSource((SDF)islandTop);
        return new SDFSmoothUnion().setRadius(0.02f).setSourceA((SDF)islandBottom).setSourceB((SDF)islandTop);
    }

    private static /* synthetic */ SDF lambda$makeTallSphereIsland$3(SDF defaultIsland, LayerOptions options, Random random) {
        float scale = random.nextFloat() + 0.5f;
        if (options.scale > 60.0f) {
            scale = 60.0f * scale / options.scale;
        } else if (options.scale < 30.0f) {
            scale = 30.0f * scale / options.scale;
        }
        SDFUnary island = new SDFScale().setScale(scale).setSource(defaultIsland);
        if (options.scale > 35.0f) {
            float distance = scale * 0.6f;
            float offset = random.nextFloat() * ((float)Math.PI * 2);
            byte count = (byte)MHelper.randRange((int)3, (int)5, (Random)random);
            for (byte i = 0; i < count; i = (byte)(i + 1)) {
                float angle = (float)i / (float)count * ((float)Math.PI * 2) + offset;
                float px = (float)Math.sin(angle) * distance;
                float pz = (float)Math.cos(angle) * distance;
                SDFUnary part = new SDFScale().setScale(scale * MHelper.randRange((float)0.3f, (float)0.6f, (Random)random)).setSource(defaultIsland);
                part = new SDFTranslate().setTranslate(px, MHelper.randRange((float)-0.25f, (float)0.25f, (Random)random) * distance, pz).setSource((SDF)part);
                island = new SDFUnion().setSourceA((SDF)island).setSourceB((SDF)part);
            }
        }
        OpenSimplexNoise noise1 = new OpenSimplexNoise((long)random.nextInt());
        float scale1 = 0.5f * options.scale;
        float noiseScale = class_3532.method_15363((float)((options.scale - 30.0f) / 30.0f), (float)0.1f, (float)1.0f);
        float scale2 = 20.0f / options.scale * noiseScale;
        island = new SDFDisplacement().setFunction(pos -> Float.valueOf((float)noise1.eval((double)(pos.method_4943() * scale1), (double)(pos.method_4945() * scale1), (double)(pos.method_4947() * scale1)) * scale2)).setSource((SDF)island);
        return island;
    }

    private static /* synthetic */ SDF lambda$makeSimpleIsland$1(SDF defaultIsland, LayerOptions options, Random random) {
        OpenSimplexNoise noise1 = new OpenSimplexNoise((long)random.nextInt());
        OpenSimplexNoise noise2 = new OpenSimplexNoise((long)random.nextInt());
        float scale1 = options.scale * 0.0125f;
        float scale2 = options.scale * 0.025f;
        float scale3 = options.scale * 0.05f;
        float scale4 = class_3532.method_15363((float)((options.scale - 50.0f) / 50.0f), (float)0.3f, (float)1.0f) / options.scale;
        float islandScale = random.nextFloat() + 0.5f;
        SDFUnary island = new SDFScale().setScale(islandScale).setSource(defaultIsland);
        island = new SDFCoordModify().setFunction(pos -> {
            float x1 = pos.method_4943() * scale1;
            float z1 = pos.method_4947() * scale1;
            float x2 = pos.method_4943() * scale2;
            float z2 = pos.method_4947() * scale2;
            float x3 = pos.method_4943() * scale3;
            float z3 = pos.method_4947() * scale3;
            float dx = (float)noise1.eval((double)x1, (double)z1) * 20.0f + (float)noise2.eval((double)x2, (double)z2) * 10.0f;
            float dy = (float)noise1.eval((double)x3, (double)z3) * 6.0f + (float)noise2.eval((double)x3, (double)z3) * 3.0f;
            float dz = (float)noise2.eval((double)x1, (double)z1) * 20.0f + (float)noise1.eval((double)x2, (double)z2) * 10.0f;
            pos.method_4949(pos.method_4943() + dx * scale4, pos.method_4945() + dy * scale4, pos.method_4947() + dz * scale4);
        }).setSource((SDF)island);
        return island;
    }

    static {
        ISLAND_FUNCTIONS.add(IslandTypes.makeSimpleIsland(), 2.0f);
        ISLAND_FUNCTIONS.add(IslandTypes.makeTallSphereIsland(), 1.0f);
        ISLAND_FUNCTIONS.add(IslandTypes.makeDoubleConeIsland(), 1.5f);
    }
}

