/*
 * Decompiled with CFR 0.152.
 */
package paulevs.edenring.world.generator;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.stream.Collectors;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_5321;
import net.minecraft.class_6544;
import net.minecraft.class_6880;
import net.minecraft.class_6903;
import paulevs.edenring.registries.EdenBiomes;
import paulevs.edenring.world.generator.GeneratorOptions;
import paulevs.edenring.world.generator.MultiThreadGenerator;
import paulevs.edenring.world.generator.TerrainGenerator;
import ru.bclib.interfaces.BiomeMap;
import ru.bclib.world.generator.BiomePicker;
import ru.bclib.world.generator.map.hex.HexBiomeMap;

public class EdenBiomeSource
extends class_1966 {
    public static final Codec<EdenBiomeSource> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_6903.method_40419((class_5321)class_2378.field_25114).forGetter(theEndBiomeSource -> null)).apply((Applicative)instance, instance.stable(EdenBiomeSource::new)));
    private final class_2378<class_1959> biomeRegistry;
    private BiomePicker pickerLand;
    private BiomePicker pickerVoid;
    private BiomePicker pickerCave;
    private BiomeMap mapLand;
    private BiomeMap mapVoid;
    private BiomeMap mapCave;

    public EdenBiomeSource(class_2378<class_1959> biomeRegistry) {
        super(biomeRegistry.method_29722().stream().filter(entry -> ((class_5321)entry.getKey()).method_29177().method_12836().equals("edenring")).map(entry -> biomeRegistry.method_40268((class_5321)entry.getKey())).collect(Collectors.toList()));
        this.biomeRegistry = biomeRegistry;
        if (this.pickerLand == null) {
            this.pickerLand = new BiomePicker();
            EdenBiomes.BIOMES_LAND.forEach(biome -> this.pickerLand.addBiome(biome));
            this.pickerLand.rebuild();
            this.pickerVoid = new BiomePicker();
            EdenBiomes.BIOMES_VOID.forEach(biome -> this.pickerVoid.addBiome(biome));
            this.pickerVoid.rebuild();
            this.pickerCave = new BiomePicker();
            EdenBiomes.BIOMES_CAVE.forEach(biome -> this.pickerCave.addBiome(biome));
            this.pickerCave.rebuild();
        }
        this.pickerLand.getBiomes().forEach(biome -> biome.updateActualBiomes(biomeRegistry));
        this.pickerVoid.getBiomes().forEach(biome -> biome.updateActualBiomes(biomeRegistry));
        this.pickerCave.getBiomes().forEach(biome -> biome.updateActualBiomes(biomeRegistry));
        this.mapLand = new HexBiomeMap(0L, GeneratorOptions.biomeSizeLand, this.pickerLand);
        this.mapVoid = new HexBiomeMap(0L, GeneratorOptions.biomeSizeVoid, this.pickerVoid);
        this.mapCave = new HexBiomeMap(0L, GeneratorOptions.biomeSizeCave, this.pickerCave);
    }

    protected Codec<? extends class_1966> method_28442() {
        return CODEC;
    }

    public class_1966 method_27985(long seed) {
        return new EdenBiomeSource(this.biomeRegistry);
    }

    public class_6880<class_1959> method_38109(int x, int y, int z, class_6544.class_6552 sampler) {
        this.cleanCache(x, z);
        int px = x << 2 | 2;
        int py = y << 2 | 2;
        int pz = z << 2 | 2;
        float[] data = new float[2];
        TerrainGenerator generator = MultiThreadGenerator.getTerrainGenerator();
        generator.fillTerrainDensity(data, new class_2338(px, py, pz), 4.0, 8.0);
        if (this.isLand(data)) {
            if (this.isCave(data)) {
                return this.mapCave.getBiome((double)px, 0.0, (double)pz).getActualBiome();
            }
            return this.mapLand.getBiome((double)px, 0.0, (double)pz).getActualBiome();
        }
        return this.mapVoid.getBiome((double)px, 0.0, (double)pz).getActualBiome();
    }

    public void setSeed(long seed) {
        this.mapLand = new HexBiomeMap(seed, GeneratorOptions.biomeSizeLand, this.pickerLand);
        this.mapVoid = new HexBiomeMap(seed, GeneratorOptions.biomeSizeVoid, this.pickerVoid);
        this.mapCave = new HexBiomeMap(seed, GeneratorOptions.biomeSizeCave, this.pickerCave);
    }

    private void cleanCache(int x, int z) {
        if ((x & 0x3F) == 0 && (z & 0x3F) == 0) {
            this.mapLand.clearCache();
            this.mapVoid.clearCache();
            this.mapCave.clearCache();
        }
    }

    private boolean isLand(float[] data) {
        for (int py = 0; py < data.length; py = (int)((byte)(py + 1))) {
            if (!(data[py] > -0.3f)) continue;
            return true;
        }
        return false;
    }

    private boolean isCave(float[] data) {
        for (int i = 0; i < data.length; i = (int)((byte)(i + 1))) {
            if (!(data[i] < 0.0f)) continue;
            return false;
        }
        return true;
    }
}

