/*
 * Decompiled with CFR 0.152.
 */
package paulevs.edenring.world.generator;

import java.util.Random;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2826;
import net.minecraft.class_2902;
import net.minecraft.class_3532;
import paulevs.edenring.noise.InterpolationCell;
import paulevs.edenring.noise.VoronoiNoise;
import paulevs.edenring.world.generator.MultiThreadGenerator;
import paulevs.edenring.world.generator.TerrainGenerator;
import ru.bclib.noise.OpenSimplexNoise;
import ru.bclib.util.BlocksHelper;
import ru.bclib.util.MHelper;

public class CaveGenerator {
    private static final class_2680 CAVE_AIR = class_2246.field_10543.method_9564();
    private static final VoronoiNoise VORONOI_NOISE = new VoronoiNoise();
    private static OpenSimplexNoise simplexNoise;
    private static int seed;

    public static void init(long seed) {
        Random random = new Random(seed);
        simplexNoise = new OpenSimplexNoise((long)random.nextInt());
        CaveGenerator.seed = random.nextInt();
    }

    public static void carve(class_2791 chunkAccess, InterpolationCell cellTerrain) {
        short minX = (short)chunkAccess.method_12004().method_8326();
        short minZ = (short)chunkAccess.method_12004().method_8328();
        short minY = (short)chunkAccess.method_31607();
        short maxY = (short)chunkAccess.method_31600();
        float[] buffer9 = new float[9];
        float[] buffer27 = new float[27];
        Random random = new Random();
        int maxCell = (maxY - minY) / 8 + 1;
        class_2338 origin = new class_2338((int)minX, (int)minY, (int)minZ);
        TerrainGenerator generator = MultiThreadGenerator.getTerrainGenerator();
        InterpolationCell cellSparse = new InterpolationCell(generator, 4, (maxY - minY) / 16 + 1, 16, 16, new class_2338(minX - 16, (int)minY, minZ - 16));
        InterpolationCell cellVoronoi = new InterpolationCell(p -> Float.valueOf(CaveGenerator.getTunelNoise(p, buffer27, random)), 5, (maxY - minY) / 4 + 1, 4, 4, origin);
        InterpolationCell cellBigCave = new InterpolationCell(p -> Float.valueOf(CaveGenerator.getBigCaveNoise(cellSparse, p)), 3, maxCell, 8, 8, origin);
        InterpolationCell cellPillars = new InterpolationCell(p -> Float.valueOf(CaveGenerator.getPillars(p, seed, buffer9, random)), 5, (maxY - minY) / 4 + 1, 4, 4, origin);
        class_2338.class_2339 pos = new class_2338.class_2339();
        short newMinY = (short)MHelper.min((int)cellTerrain.getMinY(), (int)cellSparse.getMinY());
        minY = (short)MHelper.max((int)minY, (int)newMinY);
        int maxCheck = maxY - 16;
        for (int x = 0; x < 16; x = (int)((byte)(x + 1))) {
            pos.method_33097(x);
            for (int z = 0; z < 16; z = (int)((byte)(z + 1))) {
                short max;
                pos.method_33099(z);
                int index = 0;
                float[] accumulation = new float[8];
                for (short y = max = (short)chunkAccess.method_12005(class_2902.class_2903.field_13194, x, z); y >= minY; y = (short)(y - 1)) {
                    float noise;
                    float heightNoise;
                    float heightNoise2;
                    if (y < maxCheck && ((heightNoise2 = cellTerrain.get((class_2338)pos.method_33098(y + 10), true)) <= 0.0f || y > 8 && (heightNoise2 = cellTerrain.get((class_2338)pos.method_33098(y - 8), true)) <= 0.0f)) continue;
                    class_2826 section = chunkAccess.method_38259(y >> 4);
                    pos.method_33098((int)y);
                    if (y < maxCheck && ((heightNoise = cellTerrain.get((class_2338)pos.method_33098(y + 10), true)) <= 0.0f || y > 8 && (heightNoise = cellTerrain.get((class_2338)pos.method_33098(y - 8), true)) <= 0.0f) || !section.method_12254(x, y & 0xF, z).method_27852(class_2246.field_10340)) continue;
                    accumulation[index] = noise = cellVoronoi.get((class_2338)pos, true);
                    index = (byte)(index + 1 & 7);
                    float average = 0.0f;
                    for (int i = 0; i < accumulation.length; i = (int)((byte)(i + 1))) {
                        noise = MHelper.max((float)noise, (float)accumulation[i]);
                        average += accumulation[i];
                    }
                    noise = (noise + average / (float)accumulation.length) * 0.5f - 0.9f;
                    float cellValue = cellTerrain.get((class_2338)pos, true);
                    noise = -CaveGenerator.smoothUnion(-noise, cellValue + 0.5f, 1.1f);
                    float bigCave = 0.0f;
                    if (noise < 0.1f) {
                        bigCave = cellBigCave.get((class_2338)pos, true);
                        noise = -CaveGenerator.smoothUnion(-noise, -bigCave, 0.1f);
                    }
                    if (noise > -0.1f) {
                        float pillars = cellPillars.get((class_2338)pos, true);
                        noise = CaveGenerator.smoothUnion(noise, pillars, 0.1f);
                    }
                    if (!(noise > 0.0f)) continue;
                    section.method_12256(x, y & 0xF, z, CAVE_AIR, false);
                    int py = pos.method_10264();
                    pos.method_33098(py + 1);
                }
            }
        }
    }

    private static float getTunelNoise(class_2338 pos, float[] buffer, Random random) {
        VORONOI_NOISE.getDistances(seed, (double)pos.method_10263() * 0.01, (double)pos.method_10264() * 0.03, (double)pos.method_10260() * 0.01, buffer, random);
        return buffer[0] / buffer[2];
    }

    private static float smoothUnion(float a, float b, float radius) {
        float h = class_3532.method_15363((float)(0.5f + 0.5f * (b - a) / radius), (float)0.0f, (float)1.0f);
        return class_3532.method_16439((float)h, (float)b, (float)a) - radius * h * (1.0f - h);
    }

    private static float getMinValue(InterpolationCell cell, class_2338 pos) {
        float value = 1.0f;
        for (class_2350 dir : BlocksHelper.DIRECTIONS) {
            float side = cell.get(pos.method_10079(dir, 15), false);
            value = MHelper.min((float)value, (float)side);
        }
        return value;
    }

    private static float getBigCaveNoise(InterpolationCell cell, class_2338 pos) {
        if (pos.method_10264() < 32 || pos.method_10264() > 224) {
            return 0.0f;
        }
        float noise = (float)simplexNoise.eval((double)pos.method_10263() * 0.03, (double)pos.method_10264() * 0.03, (double)pos.method_10260() * 0.03);
        float value = CaveGenerator.getMinValue(cell, pos);
        value = MHelper.max((float)value, (float)CaveGenerator.getMinValue(cell, pos.method_10086(8)));
        value = MHelper.max((float)value, (float)CaveGenerator.getMinValue(cell, pos.method_10087(8)));
        if (noise < 0.0f) {
            value += noise;
        }
        noise = (float)simplexNoise.eval((double)pos.method_10263() * 0.1, (double)pos.method_10264() * 0.1, (double)pos.method_10260() * 0.1) * 0.004f + 0.004f;
        return value - (noise += (float)simplexNoise.eval((double)pos.method_10263() * 0.03, (double)pos.method_10264() * 0.03, (double)pos.method_10260() * 0.03) * 0.01f + 0.01f);
    }

    private static float getPillars(class_2338 pos, int seed, float[] buffer, Random random) {
        VORONOI_NOISE.getDistances(seed, (double)pos.method_10263() * 0.02, (double)pos.method_10260() * 0.02, buffer, random);
        float value = VORONOI_NOISE.getValue(seed, (double)pos.method_10263() * 0.02, (double)pos.method_10260() * 0.02, random);
        value = buffer[0] - 0.07f * (value * 0.5f + 0.5f);
        return value + (float)simplexNoise.eval((double)pos.method_10263() * 0.03, (double)pos.method_10264() * 0.03, (double)pos.method_10260() * 0.03) * 0.01f;
    }
}

