/*
 * Decompiled with CFR 0.152.
 */
package paulevs.edenring.world.features.trees;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.class_1767;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2372;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3111;
import net.minecraft.class_3614;
import net.minecraft.class_5281;
import net.minecraft.class_5821;
import paulevs.edenring.blocks.EdenBlockProperties;
import paulevs.edenring.registries.EdenBlocks;
import ru.bclib.util.BlocksHelper;
import ru.bclib.util.MHelper;
import ru.bclib.world.features.DefaultFeature;

public class OldBalloonMushroomTreeFeature
extends DefaultFeature {
    public boolean method_13151(class_5821<class_3111> featurePlaceContext) {
        class_5281 level = featurePlaceContext.method_33652();
        class_2338 center = featurePlaceContext.method_33655();
        Random random = featurePlaceContext.method_33654();
        class_2248 below = level.method_8320(center.method_10074()).method_26204();
        if (!(below instanceof class_2372) && below != class_2246.field_10566) {
            return false;
        }
        class_2680 log = EdenBlocks.BALLOON_MUSHROOM_MATERIAL.getBlock("log").method_9564();
        class_2338.class_2339 p = center.method_25503().method_33098(center.method_10264() + 4);
        if (!level.method_8320(center).method_27852(EdenBlocks.BALLOON_MUSHROOM_SMALL)) {
            for (int x = -14; x <= 14; ++x) {
                p.method_33097(center.method_10263() + x);
                for (int z = -14; z <= 14; ++z) {
                    if (Math.abs(x) + Math.abs(z) >= 20) continue;
                    p.method_33099(center.method_10260() + z);
                    if (!level.method_8320((class_2338)p).method_27852(log.method_26204())) continue;
                    return false;
                }
            }
        }
        class_2680 bark = EdenBlocks.BALLOON_MUSHROOM_MATERIAL.getBlock("bark").method_9564();
        class_2680 block = EdenBlocks.BALLOON_MUSHROOM_BLOCK.method_9564();
        class_2680 stem = EdenBlocks.BALLOON_MUSHROOM_STEM.method_9564();
        byte height = (byte)MHelper.randRange((int)8, (int)12, (Random)random);
        this.makeTrunk(level, center, p.method_10101((class_2382)center), log, height);
        this.makeRoots(level, center, p, log, bark, stem, random);
        this.makeBranches(level, center, p, stem, height, random);
        this.makeCap(level, p.method_10101((class_2382)center).method_33098(p.method_10264() + height), block, height, random);
        return true;
    }

    private void makeTrunk(class_5281 level, class_2338 center, class_2338.class_2339 p, class_2680 log, byte height) {
        p.method_33098(p.method_10264() - 1);
        for (byte i = 0; i <= height; i = (byte)(i + 1)) {
            this.setBlock(level, (class_2338)p, log);
            this.setBlock(level, (class_2338)p.method_33097(center.method_10263() + 1), log);
            this.setBlock(level, (class_2338)p.method_33099(center.method_10260() + 1), log);
            this.setBlock(level, (class_2338)p.method_33097(center.method_10263()), log);
            p.method_33099(center.method_10260()).method_33098(p.method_10264() + 1);
        }
    }

    private void makeCap(class_5281 level, class_2338.class_2339 p, class_2680 block, byte height, Random random) {
        class_2680 bottom = (class_2680)block.method_11657((class_2769)EdenBlockProperties.NATURAL, (Comparable)Boolean.valueOf(true));
        class_2680 state = EdenBlocks.BALLOON_MUSHROOM_HYMENOPHORE.method_9564();
        class_2680 hymenophoreBottom = (class_2680)state.method_11657(EdenBlockProperties.QUAD_SHAPE, (Comparable)((Object)EdenBlockProperties.QuadShape.BOTTOM));
        class_2680 hymenophoreMiddle = (class_2680)state.method_11657(EdenBlockProperties.QUAD_SHAPE, (Comparable)((Object)EdenBlockProperties.QuadShape.MIDDLE));
        class_2680 hymenophoreSmall = (class_2680)state.method_11657(EdenBlockProperties.QUAD_SHAPE, (Comparable)((Object)EdenBlockProperties.QuadShape.SMALL));
        class_2680 hymenophoreTop = (class_2680)state.method_11657(EdenBlockProperties.QUAD_SHAPE, (Comparable)((Object)EdenBlockProperties.QuadShape.TOP));
        state = EdenBlocks.BALLOON_MUSHROOM_STEM.method_9564();
        class_2680 stemMiddle = (class_2680)state.method_11657(EdenBlockProperties.BALLOON_MUSHROOM_STEM, (Comparable)((Object)EdenBlockProperties.BalloonMushroomStemState.THIN));
        class_2680 stemTop = (class_2680)state.method_11657(EdenBlockProperties.BALLOON_MUSHROOM_STEM, (Comparable)((Object)EdenBlockProperties.BalloonMushroomStemState.THIN_TOP));
        class_1767 dye = random.nextBoolean() ? class_1767.field_7952 : class_1767.field_7954;
        class_2680 lantern = EdenBlocks.MYCOTIC_LANTERN_COLORED.get(dye).method_9564();
        class_2680 sporocap = EdenBlocks.BALLOON_MUSHROOM_SPOROCARP_COLORED.get(class_1767.field_7952).method_9564();
        ArrayList<class_2338> updateBlocks = new ArrayList<class_2338>(128);
        class_2338 center = p.method_10062();
        byte radius = (byte)(height >> 1);
        byte startY = (byte)((float)(-radius) * 0.5f);
        byte r2 = (byte)(radius * radius);
        byte r3 = (byte)((radius - 1) * (radius - 1));
        for (byte y = startY; y <= radius; y = (byte)(y + 1)) {
            state = y == startY ? bottom : block;
            byte y2 = (byte)(y * y);
            for (byte x = (byte)(-radius); x <= radius; x = (byte)(x + 1)) {
                float x2 = ((float)x - 0.5f) * ((float)x - 0.5f);
                for (byte z = (byte)(-radius); z <= radius; z = (byte)(z + 1)) {
                    byte length;
                    float z2 = ((float)z - 0.5f) * ((float)z - 0.5f);
                    float xz = x2 + z2;
                    float xyz = xz + (float)y2;
                    if (!(xyz <= (float)r2)) continue;
                    class_2680 cap = y > startY && xyz < (float)r3 ? sporocap : state;
                    this.setBlock(level, (class_2338)p.method_10101((class_2382)center).method_10100((int)x, y - startY, (int)z), cap);
                    updateBlocks.add(p.method_10062());
                    if (y != startY) continue;
                    if (random.nextInt(16) == 0 && xz > 3.0f) {
                        length = (byte)MHelper.randRange((int)4, (int)7, (Random)random);
                        this.makeLantern(level, p.method_25503().method_33098(p.method_10264() - 1), length, lantern, stemMiddle, stemTop);
                        continue;
                    }
                    if (random.nextInt(4) <= 0) continue;
                    length = (byte)MHelper.randRange((int)1, (int)3, (Random)random);
                    this.makeVine(level, p.method_25503().method_33098(p.method_10264() - 1), length, hymenophoreSmall, hymenophoreBottom, hymenophoreMiddle, hymenophoreTop);
                }
            }
        }
        updateBlocks.forEach(pos -> {
            class_2680 s = level.method_8320(pos);
            s = s.method_26204().method_9559(s, class_2350.field_11036, AIR, (class_1936)level, pos, pos);
            BlocksHelper.setWithoutUpdate((class_1936)level, (class_2338)pos, (class_2680)s);
        });
    }

    private void makeVine(class_5281 level, class_2338.class_2339 pos, byte length, class_2680 small, class_2680 bottom, class_2680 middle, class_2680 top) {
        if (!level.method_8320((class_2338)pos).method_26215()) {
            return;
        }
        if (length == 1) {
            BlocksHelper.setWithoutUpdate((class_1936)level, (class_2338)pos, (class_2680)small);
            return;
        }
        byte maxLength = (byte)(length - 1);
        for (byte i = 0; i < length; i = (byte)(i + 1)) {
            class_2680 state = i == maxLength ? bottom : (i == 0 ? top : middle);
            BlocksHelper.setWithoutUpdate((class_1936)level, (class_2338)pos, (class_2680)state);
            pos.method_33098(pos.method_10264() - 1);
            if (level.method_8320((class_2338)pos).method_26215()) continue;
            state = i == 0 ? small : bottom;
            BlocksHelper.setWithoutUpdate((class_1936)level, (class_2338)pos.method_33098(pos.method_10264() + 1), (class_2680)state);
            return;
        }
    }

    private void makeLantern(class_5281 level, class_2338.class_2339 pos, byte length, class_2680 lantern, class_2680 middle, class_2680 top) {
        if (!level.method_8320((class_2338)pos).method_26215()) {
            return;
        }
        byte maxLength = (byte)(length - 1);
        for (byte i = 0; i < length; i = (byte)(i + 1)) {
            class_2680 state = i == maxLength ? lantern : (i == 0 ? top : middle);
            BlocksHelper.setWithoutUpdate((class_1936)level, (class_2338)pos, (class_2680)state);
            pos.method_33098(pos.method_10264() - 1);
            if (level.method_8320((class_2338)pos).method_26215()) continue;
            BlocksHelper.setWithoutUpdate((class_1936)level, (class_2338)pos.method_33098(pos.method_10264() + 1), (class_2680)lantern);
            return;
        }
    }

    private void makeRoots(class_5281 level, class_2338 center, class_2338.class_2339 p, class_2680 log, class_2680 bark, class_2680 stem, Random random) {
        byte h2;
        byte h;
        byte[][] mask = new byte[4][4];
        mask[1][1] = 4;
        mask[1][2] = 4;
        mask[2][1] = 4;
        mask[2][2] = 4;
        for (int i = 0; i < 2; i = (int)((byte)(i + 1))) {
            byte h22;
            byte h3;
            if (random.nextBoolean()) {
                h3 = (byte)random.nextInt(3);
                h22 = (byte)(-(h3 + MHelper.randRange((int)2, (int)3, (Random)random)));
                this.makeLine(level, p.method_10101((class_2382)center).method_10100(i, (int)h3, -1), bark, log, h22);
                mask[i + 1][0] = (byte)(h3 + 1);
            }
            if (random.nextBoolean()) {
                h3 = (byte)random.nextInt(3);
                h22 = (byte)(-(h3 + MHelper.randRange((int)2, (int)3, (Random)random)));
                this.makeLine(level, p.method_10101((class_2382)center).method_10100(i, (int)h3, 2), bark, log, h22);
                mask[i + 1][3] = (byte)(h3 + 1);
            }
            if (random.nextBoolean()) {
                h3 = (byte)random.nextInt(3);
                h22 = (byte)(-(h3 + MHelper.randRange((int)2, (int)3, (Random)random)));
                this.makeLine(level, p.method_10101((class_2382)center).method_10100(-1, (int)h3, i), bark, log, h22);
                mask[0][i + 1] = (byte)(h3 + 1);
            }
            if (!random.nextBoolean()) continue;
            h3 = (byte)random.nextInt(3);
            h22 = (byte)(-(h3 + MHelper.randRange((int)2, (int)3, (Random)random)));
            this.makeLine(level, p.method_10101((class_2382)center).method_10100(2, (int)h3, i), bark, log, h22);
            mask[3][i + 1] = (byte)(h3 + 1);
        }
        if (random.nextBoolean()) {
            h = (byte)MHelper.randRange((int)1, (int)2, (Random)random);
            h2 = (byte)(-h - 2);
            this.makeLine(level, p.method_10101((class_2382)center).method_10100(-1, h - 1, -1), bark, log, h2);
            mask[0][0] = h;
        }
        if (random.nextBoolean()) {
            h = (byte)MHelper.randRange((int)1, (int)2, (Random)random);
            h2 = (byte)(-h - 2);
            this.makeLine(level, p.method_10101((class_2382)center).method_10100(2, h - 1, -1), bark, log, h2);
            mask[3][0] = h;
        }
        if (random.nextBoolean()) {
            h = (byte)MHelper.randRange((int)1, (int)2, (Random)random);
            h2 = (byte)(-h - 2);
            this.makeLine(level, p.method_10101((class_2382)center).method_10100(2, h - 1, 2), bark, log, h2);
            mask[3][3] = h;
        }
        if (random.nextBoolean()) {
            h = (byte)MHelper.randRange((int)1, (int)2, (Random)random);
            h2 = (byte)(-h - 2);
            this.makeLine(level, p.method_10101((class_2382)center).method_10100(-1, h - 1, 2), bark, log, h2);
            mask[0][3] = h;
        }
        class_2680 branch = (class_2680)EdenBlocks.BALLOON_MUSHROOM_BRANCH.method_9564().method_11657((class_2769)class_2741.field_12546, (Comparable)Boolean.valueOf(true));
        Object[] dirs = BlocksHelper.makeHorizontal();
        for (int x = -2; x < 4; ++x) {
            block2: for (int z = -2; z < 4; ++z) {
                if (random.nextInt(4) == 0) continue;
                MHelper.shuffle((Object[])dirs, (Random)random);
                for (Object dir : dirs) {
                    byte h4 = this.getConnection(x, z, (class_2350)dir, mask);
                    if (h4 <= 0) continue;
                    if (h4 > 1) {
                        h4 = (byte)MHelper.randRange((int)1, (int)h4, (Random)random);
                    }
                    byte h23 = (byte)(-h4 - 3);
                    class_2680 start = (class_2680)branch.method_11657((class_2769)EdenBlockProperties.DIRECTIONS[dir.method_10146()], (Comparable)Boolean.valueOf(true));
                    this.makeLine(level, p.method_10101((class_2382)center).method_10100(x, h4 - 1, z), start, stem, h23);
                    continue block2;
                }
            }
        }
    }

    private void makeBranches(class_5281 level, class_2338 center, class_2338.class_2339 p, class_2680 stem, byte height, Random random) {
        class_2680 branch = (class_2680)EdenBlocks.BALLOON_MUSHROOM_BRANCH.method_9564().method_11657((class_2769)class_2741.field_12519, (Comparable)Boolean.valueOf(true));
        for (int i = 0; i < 2; i = (int)((byte)(i + 1))) {
            byte dx;
            byte dy;
            if (random.nextInt(4) > 0) {
                dy = (byte)MHelper.randRange((int)2, (int)4, (Random)random);
                dx = (byte)random.nextInt(2);
                this.singleBranch(level, p.method_10101((class_2382)center).method_10100(i, height - dy, -1), class_2350.field_11043, dx, dy, stem, branch);
            }
            if (random.nextInt(4) > 0) {
                dy = (byte)MHelper.randRange((int)2, (int)4, (Random)random);
                dx = (byte)random.nextInt(2);
                this.singleBranch(level, p.method_10101((class_2382)center).method_10100(i, height - dy, 2), class_2350.field_11035, dx, dy, stem, branch);
            }
            if (random.nextInt(4) > 0) {
                dy = (byte)MHelper.randRange((int)2, (int)4, (Random)random);
                dx = (byte)random.nextInt(2);
                this.singleBranch(level, p.method_10101((class_2382)center).method_10100(-1, height - dy, i), class_2350.field_11039, dx, dy, stem, branch);
            }
            if (random.nextInt(4) <= 0) continue;
            dy = (byte)MHelper.randRange((int)2, (int)4, (Random)random);
            dx = (byte)random.nextInt(2);
            this.singleBranch(level, p.method_10101((class_2382)center).method_10100(2, height - dy, i), class_2350.field_11034, dx, dy, stem, branch);
        }
    }

    private void singleBranch(class_5281 level, class_2338.class_2339 start, class_2350 dir, byte dxz, byte dy, class_2680 stem, class_2680 branch) {
        branch = (class_2680)branch.method_11657((class_2769)EdenBlockProperties.DIRECTIONS[dir.method_10153().method_10146()], (Comparable)Boolean.valueOf(true));
        if (dxz == 0) {
            this.makeLine(level, start, branch, stem, dy);
        } else {
            EdenBlockProperties.BalloonMushroomStemState state = dir.method_10166() == class_2350.class_2351.field_11051 ? EdenBlockProperties.BalloonMushroomStemState.NORTH_SOUTH : EdenBlockProperties.BalloonMushroomStemState.EAST_WEST;
            class_2680 side = (class_2680)stem.method_11657(EdenBlockProperties.BALLOON_MUSHROOM_STEM, (Comparable)((Object)state));
            for (byte i = 0; i < dxz; i = (byte)(i + 1)) {
                this.setBlock(level, (class_2338)start, side);
                start.method_10098(dir);
            }
            this.makeLine(level, start, branch, stem, dy);
        }
    }

    private byte getConnection(int x, int z, class_2350 dir, byte[][] mask) {
        if ((x += dir.method_10148() + 1) >= 0 && x < 4 && (z += dir.method_10165() + 1) >= 0 && z < 4) {
            return mask[x][z];
        }
        return 0;
    }

    private void makeLine(class_5281 level, class_2338.class_2339 p, class_2680 start, class_2680 line, byte height) {
        byte delta = (byte)(height > 0 ? 1 : -1);
        this.setBlock(level, (class_2338)p, start);
        byte i = delta;
        while (i != height) {
            this.setBlock(level, (class_2338)p.method_33098(p.method_10264() + delta), line);
            i = (byte)(i + delta);
        }
    }

    private void setBlock(class_5281 level, class_2338 pos, class_2680 state) {
        class_2680 place = level.method_8320(pos);
        if (place.method_26207().method_15800() || place.method_27852(EdenBlocks.BALLOON_MUSHROOM_SMALL) || place.method_26207().equals(class_3614.field_15935)) {
            BlocksHelper.setWithoutUpdate((class_1936)level, (class_2338)pos, (class_2680)state);
        }
    }
}

