/*
 * Decompiled with CFR 0.152.
 */
package paulevs.edenring.world.features.terrain;

import java.util.Random;
import net.minecraft.class_1936;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3111;
import net.minecraft.class_5281;
import net.minecraft.class_5821;
import ru.bclib.noise.OpenSimplexNoise;
import ru.bclib.util.BlocksHelper;
import ru.bclib.util.MHelper;
import ru.bclib.world.features.DefaultFeature;

public class LayeredBulbFeature
extends DefaultFeature {
    private static final OpenSimplexNoise NOISE = new OpenSimplexNoise((long)"ore".hashCode());
    private class_2248[] layers;
    private class_2248[] scatterIn;
    private int minCount;
    private int maxCount;
    private int minRadius;
    private int maxRadius;

    public LayeredBulbFeature(class_2248[] layers, int count, int radius, class_2248 ... scatterIn) {
        this.layers = layers;
        this.scatterIn = scatterIn;
        this.minCount = count / 3;
        this.maxCount = count;
        this.minRadius = radius / 2;
        this.maxRadius = radius;
    }

    public boolean method_13151(class_5821<class_3111> featurePlaceContext) {
        Random random = featurePlaceContext.method_33654();
        class_2338 center = featurePlaceContext.method_33655();
        class_5281 level = featurePlaceContext.method_33652();
        int posX = center.method_10263() & 0xFFFFFFF0;
        int posZ = center.method_10260() & 0xFFFFFFF0;
        class_2338.class_2339 pos = new class_2338.class_2339();
        int iterations = MHelper.randRange((int)this.minCount, (int)this.maxCount, (Random)random);
        for (int n = 0; n < iterations; ++n) {
            int wx = posX | random.nextInt(16);
            int wz = posZ | random.nextInt(16);
            int wy = random.nextInt(256);
            int radius = MHelper.randRange((int)this.minRadius, (int)this.maxRadius, (Random)random);
            int x1 = wx - radius;
            int x2 = wx + radius;
            int z1 = wz - radius;
            int z2 = wz + radius;
            int y1 = wy - radius;
            int y2 = wy + radius;
            for (int x = x1; x <= x2; ++x) {
                pos.method_33097(x);
                for (int y = y1; y <= y2; ++y) {
                    pos.method_33098(y);
                    for (int z = z1; z <= z2; ++z) {
                        pos.method_33099(z);
                        float dist = MHelper.length((float)(x - wx), (float)(y - wy), (float)(z - wz));
                        float localRadius = (float)radius - (float)NOISE.eval((double)x * 0.3, (double)y * 0.3, (double)z * 0.3) * (float)radius * 0.3f;
                        if (!(dist < localRadius - (float)random.nextInt(3))) continue;
                        int index = (int)(dist / localRadius * (float)this.layers.length);
                        class_2680 state = this.layers[index].method_9564();
                        class_2680 worldState = level.method_8320((class_2338)pos);
                        for (class_2248 block : this.scatterIn) {
                            if (!worldState.method_27852(block)) continue;
                            BlocksHelper.setWithoutUpdate((class_1936)level, (class_2338)pos, (class_2680)state);
                        }
                    }
                }
            }
        }
        return true;
    }
}

