/*
 * Decompiled with CFR 0.152.
 */
package paulevs.edenring.world.features.plants;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.class_1158;
import net.minecraft.class_1160;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3111;
import net.minecraft.class_3532;
import net.minecraft.class_5281;
import net.minecraft.class_5821;
import paulevs.edenring.blocks.SixSidePlant;
import paulevs.edenring.registries.EdenBlocks;
import ru.bclib.blocks.BlockProperties;
import ru.bclib.util.BlocksHelper;
import ru.bclib.util.MHelper;
import ru.bclib.util.SplineHelper;
import ru.bclib.world.features.DefaultFeature;

public class VolvoxFeature
extends DefaultFeature {
    public boolean method_13151(class_5821<class_3111> featurePlaceContext) {
        class_5281 level = featurePlaceContext.method_33652();
        class_2338 center = featurePlaceContext.method_33655();
        Random random = featurePlaceContext.method_33654();
        byte type = (byte)random.nextInt(8);
        if (type < 2) {
            this.generateSmall(level, center, random);
        } else if (type < 6) {
            this.generateMedium(level, center, random);
        } else {
            this.generateLarge(level, center, random);
        }
        return true;
    }

    private class_2338 getRandom(class_2338 pos, Random random) {
        int x = pos.method_10263() & 0xFFFFFFF0 | random.nextInt(16);
        int z = pos.method_10260() & 0xFFFFFFF0 | random.nextInt(16);
        return new class_2338(x, MHelper.randRange((int)64, (int)192, (Random)random), z);
    }

    private class_2338 getCentered(class_2338 pos, Random random) {
        int x = pos.method_10263() & 0xFFFFFFF0 | 8;
        int z = pos.method_10260() & 0xFFFFFFF0 | 8;
        return new class_2338(x, MHelper.randRange((int)64, (int)192, (Random)random), z);
    }

    private void generateSmall(class_5281 level, class_2338 pos, Random random) {
        class_2680 volvox = EdenBlocks.VOLVOX_BLOCK.method_9564();
        byte count = (byte)MHelper.randRange((int)3, (int)7, (Random)random);
        pos = this.getCentered(pos, random);
        float distance = MHelper.randRange((float)4.0f, (float)6.0f, (Random)random);
        List<class_1160> points = this.makeFibonacciPoints(count);
        for (byte i = 0; i < count; i = (byte)(i + 1)) {
            class_1160 p = points.get(i);
            float radius = MHelper.randRange((float)1.5f, (float)3.0f, (Random)random);
            float px = p.method_4943() * distance + 0.5f;
            float py = p.method_4945() * distance + 0.5f;
            float pz = p.method_4947() * distance + 0.5f;
            this.makeSphere(level, pos.method_10080((double)px, (double)py, (double)pz), radius, -1.0f, volvox, null, null);
        }
    }

    private void generateMedium(class_5281 level, class_2338 pos, Random random) {
        class_2680 volvox = EdenBlocks.VOLVOX_BLOCK.method_9564();
        class_2680 water = class_2246.field_10382.method_9564();
        float radius = MHelper.randRange((float)5.0f, (float)8.0f, (Random)random);
        pos = this.getRandom(pos, random);
        ArrayList<class_2338> sphere = new ArrayList<class_2338>();
        this.makeSphere(level, pos, radius, random.nextFloat(), volvox, water, sphere);
        this.addSmallPlants(level, pos, sphere, random);
    }

    private void generateLarge(class_5281 level, class_2338 pos, Random random) {
        class_2680 volvoxDense = EdenBlocks.VOLVOX_BLOCK_DENSE.method_9564();
        class_2680 volvox = EdenBlocks.VOLVOX_BLOCK.method_9564();
        class_2680 water = class_2246.field_10382.method_9564();
        float radius = MHelper.randRange((float)8.0f, (float)15.0f, (Random)random);
        pos = this.getCentered(pos, random);
        ArrayList<class_2338> sphere = new ArrayList<class_2338>();
        this.makeSphere(level, pos, radius, MHelper.randRange((float)0.5f, (float)0.75f, (Random)random), volvox, water, sphere);
        class_1160 offset = new class_1160(0.5f, 0.5f, 0.5f);
        class_1160 axis = new class_1160(MHelper.randRange((float)-1.0f, (float)1.0f, (Random)random), MHelper.randRange((float)-1.0f, (float)1.0f, (Random)random), MHelper.randRange((float)-1.0f, (float)1.0f, (Random)random));
        axis.method_4952();
        float angle = random.nextFloat() * (float)Math.PI * 2.0f;
        class_1158 rotation = new class_1158(axis, angle, false);
        for (int i = 0; i < 3; i = (int)((byte)(i + 1))) {
            List<class_1160> spline = this.makeCircleSpline(radius, i);
            spline.forEach(point -> point.method_19262(rotation));
            SplineHelper.offset(spline, (class_1160)offset);
            spline.add(spline.get(0));
            SplineHelper.fillSplineForce(spline, (class_5281)level, (class_2680)volvoxDense, (class_2338)pos, state -> state.method_26207().method_15800() || state.equals(volvox));
        }
        this.addSmallPlants(level, pos, sphere, random);
    }

    private void addSmallPlants(class_5281 level, class_2338 center, List<class_2338> blocks, Random random) {
        class_2338.class_2339 pos = new class_2338.class_2339();
        class_2680 mold1 = EdenBlocks.SYMBIOTIC_MOLD.method_9564();
        class_2680 mold2 = EdenBlocks.SYMBIOTIC_MOLD_EMISSIVE.method_9564();
        class_2680 vine1 = (class_2680)EdenBlocks.EDEN_VINE.method_9564().method_11657((class_2769)BlockProperties.TRIPLE_SHAPE, (Comparable)BlockProperties.TripleShape.MIDDLE);
        class_2680 vine2 = (class_2680)EdenBlocks.EDEN_VINE.method_9564().method_11657((class_2769)BlockProperties.TRIPLE_SHAPE, (Comparable)BlockProperties.TripleShape.BOTTOM);
        blocks.forEach(p -> {
            if (random.nextInt(8) == 0) {
                for (class_2350 offset : BlocksHelper.DIRECTIONS) {
                    class_2680 state;
                    class_2338.class_2339 side = pos.method_10101((class_2382)p).method_10098(offset);
                    if (!level.method_8320((class_2338)side).method_26215() || (state = ((SixSidePlant)((Object)((Object)SixSidePlant.class.cast(EdenBlocks.PARIGNUM)))).getAttachedState((class_1936)level, (class_2338)side)) == null) continue;
                    BlocksHelper.setWithoutUpdate((class_1936)level, (class_2338)side, (class_2680)state);
                }
            }
            pos.method_10101((class_2382)p).method_10098(class_2350.field_11033);
            class_2680 state = level.method_8320((class_2338)pos);
            if (state.method_26227().method_15769() && state.method_26207().method_15800()) {
                int plant = random.nextInt(8);
                if (plant == 0) {
                    if (pos.method_10264() < center.method_10264()) {
                        return;
                    }
                    BlocksHelper.setWithoutUpdate((class_1936)level, (class_2338)pos, (class_2680)mold2);
                } else if (plant < 4) {
                    BlocksHelper.setWithoutUpdate((class_1936)level, (class_2338)pos, (class_2680)mold1);
                } else if (plant < 6) {
                    if (pos.method_10264() < center.method_10264() && random.nextInt(3) > 0) {
                        return;
                    }
                    byte length = (byte)MHelper.randRange((int)3, (int)6, (Random)random);
                    for (byte i = 0; i <= length; i = (byte)(i + 1)) {
                        pos.method_10098(class_2350.field_11033);
                        state = level.method_8320((class_2338)pos);
                        pos.method_10098(class_2350.field_11036);
                        if (!state.method_26227().method_15769() || !state.method_26207().method_15800()) {
                            BlocksHelper.setWithoutUpdate((class_1936)level, (class_2338)pos, (class_2680)vine2);
                            break;
                        }
                        BlocksHelper.setWithoutUpdate((class_1936)level, (class_2338)pos, (class_2680)(i == length ? vine2 : vine1));
                        pos.method_10098(class_2350.field_11033);
                    }
                }
            }
        });
    }

    private void makeSphere(class_5281 level, class_2338 center, float radius, float fill, class_2680 wall, class_2680 water, List<class_2338> positions) {
        double r21 = (double)radius * (double)radius;
        class_2338.class_2339 pos = new class_2338.class_2339();
        double r22 = (double)(radius - 1.0f) * (double)(radius - 1.0f);
        int min = class_3532.method_15375((float)(-radius));
        int max = class_3532.method_15375((float)(radius + 1.0f));
        int waterY = (int)class_3532.method_16439((float)fill, (float)min, (float)max);
        for (int x = min; x <= max; ++x) {
            int sqrX = x * x;
            pos.method_33097(center.method_10263() + x);
            for (int y = min; y <= max; ++y) {
                int sqrY = y * y;
                pos.method_33098(center.method_10264() + y);
                for (int z = min; z <= max; ++z) {
                    int sqrZ = z * z;
                    int d = sqrX + sqrY + sqrZ;
                    if (!((double)d <= r21)) continue;
                    pos.method_33099(center.method_10260() + z);
                    if ((double)d >= r22) {
                        if (!level.method_8320((class_2338)pos).method_26207().method_15800()) continue;
                        BlocksHelper.setWithoutUpdate((class_1936)level, (class_2338)pos, (class_2680)wall);
                        if (positions == null) continue;
                        positions.add(pos.method_10062());
                        continue;
                    }
                    if (y >= waterY || !level.method_8320((class_2338)pos).method_26207().method_15800()) continue;
                    BlocksHelper.setWithoutUpdate((class_1936)level, (class_2338)pos, (class_2680)water);
                }
            }
        }
    }

    private List<class_1160> makeCircleSpline(float radius, int offset) {
        short count = (short)(3.0f * radius);
        ArrayList<class_1160> spline = new ArrayList<class_1160>(count);
        float PI2C = (float)Math.PI * 2 / (float)count;
        float[] p = new float[3];
        for (short i = 0; i < count; i = (short)(i + 1)) {
            p[0] = (float)Math.sin((float)i * PI2C);
            p[1] = (float)Math.sin((float)i * PI2C * 3.0f) * 0.3f;
            p[2] = (float)Math.cos((float)i * PI2C);
            float l = MHelper.length((float)p[0], (float)p[1], (float)p[2]);
            l = radius / l;
            class_1160 pos = new class_1160(p[offset] * l, p[(1 + offset) % 3] * l, p[(2 + offset) % 3] * l);
            spline.add(pos);
        }
        return spline;
    }

    private List<class_1160> makeFibonacciPoints(int count) {
        float max = count - 1;
        ArrayList<class_1160> result = new ArrayList<class_1160>(count + 1);
        for (int i = 0; i < count; ++i) {
            float y = 1.0f - (float)i / max * 2.0f;
            float radius = (float)Math.sqrt(1.0f - y * y);
            float theta = MHelper.PHI * (float)i;
            float x = (float)Math.cos(theta) * radius;
            float z = (float)Math.sin(theta) * radius;
            result.add(new class_1160(x, y, z));
        }
        return result;
    }
}

