/*
 * Decompiled with CFR 0.152.
 */
package paulevs.edenring.paintings;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1163;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;
import paulevs.edenring.EdenRing;
import paulevs.edenring.paintings.PaintingColorProvider;
import paulevs.edenring.paintings.PaintingInfo;
import ru.bclib.BCLib;

public class EdenPaintings {
    private static final Map<class_2960, PaintingInfo> PAINTING_BY_ID = Maps.newHashMap();
    private static final List<PaintingInfo> PAINTINGS_LIST = Lists.newArrayList();

    public static void init() {
        PaintingColorProvider biomeColor = EdenPaintings.getGrassColor();
        EdenPaintings.register("limphium_leaves_small_1", 16, 16, biomeColor);
        EdenPaintings.register("limphium_leaves_small_2", 16, 16, biomeColor);
        EdenPaintings.register("limphium_leaves_small_3", 16, 16, biomeColor);
        EdenPaintings.register("limphium_leaves_small_4", 16, 16, biomeColor);
        EdenPaintings.register("limphium_leaves_small_5", 16, 16, biomeColor);
        EdenPaintings.register("limphium_leaves_medium_1", 32, 32, biomeColor);
        EdenPaintings.register("limphium_leaves_medium_2", 16, 32, biomeColor);
        EdenPaintings.register("limphium_leaves_medium_3", 16, 32, biomeColor);
        EdenPaintings.register("limphium_leaves_medium_4", 32, 16, biomeColor);
        EdenPaintings.register("limphium_leaves_medium_5", 32, 16, biomeColor);
    }

    private static void register(String name, int width, int height) {
        EdenPaintings.register(name, width, height, null);
    }

    private static void register(String name, int width, int height, @Nullable PaintingColorProvider provider) {
        class_2960 id = EdenRing.makeID(name);
        class_2960 tex = EdenRing.makeID("textures/painting/" + name + ".png");
        PaintingInfo info = new PaintingInfo(PAINTINGS_LIST.size(), id, tex, width, height, provider);
        PAINTING_BY_ID.put(id, info);
        PAINTINGS_LIST.add(info);
    }

    public static PaintingInfo getPainting(class_2960 id) {
        return PAINTING_BY_ID.get(id);
    }

    public static PaintingInfo getPainting(int id) {
        return PAINTINGS_LIST.get(id);
    }

    public static Collection<PaintingInfo> getPaintings() {
        return PAINTING_BY_ID.values();
    }

    @Nullable
    private static PaintingColorProvider getGrassColor() {
        return BCLib.isClient() ? EdenPaintings.getGrassColorClient() : null;
    }

    @Environment(value=EnvType.CLIENT)
    private static PaintingColorProvider getGrassColorClient() {
        return (level, pos) -> level.method_23780(pos, class_1163.field_5665);
    }
}

