/*
 * Decompiled with CFR 0.152.
 */
package paulevs.edenring.gui;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;
import java.util.function.Function;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1144;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_333;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_757;
import paulevs.edenring.EdenRing;
import paulevs.edenring.client.ItemScaler;
import ru.bclib.util.JsonFactory;

public class GuideBookScreen
extends class_437 {
    private static final Map<String, Function<JsonObject, PageEntry>> ENTRY_REGISTRY = Maps.newHashMap();
    private static final class_2960 BOOK_TEXTURE = EdenRing.makeID("textures/gui/book.png");
    private static final Map<String, BookInfo> BOOKS_CACHE = Maps.newHashMap();
    private static final Stack<Integer> BACK_PAGES = new Stack();
    private static int pageIndex = 0;
    private final class_310 minecraft;
    private final Point arrowToHyper;
    private final Point arrowNext;
    private final Point arrowBack;
    private final BookInfo book;

    public GuideBookScreen() {
        super(class_333.field_18967);
        if (ENTRY_REGISTRY.isEmpty()) {
            ENTRY_REGISTRY.put("text", x$0 -> new TextPageEntry((JsonObject)x$0));
            ENTRY_REGISTRY.put("title", x$0 -> new TitlePageEntry((JsonObject)x$0));
            ENTRY_REGISTRY.put("hyperText", x$0 -> new HyperTextPageEntry((JsonObject)x$0));
            ENTRY_REGISTRY.put("illustration", x$0 -> new IllustrationPageEntry((JsonObject)x$0));
            ENTRY_REGISTRY.put("icon", x$0 -> new IconPageEntry((JsonObject)x$0));
        }
        this.arrowToHyper = new Point();
        this.arrowNext = new Point();
        this.arrowBack = new Point();
        this.minecraft = class_310.method_1551();
        String code = this.minecraft.method_1526().method_4669().getCode();
        this.book = this.getBook(code);
    }

    public static void clearCache() {
        BOOKS_CACHE.clear();
    }

    private BookInfo getBook(String code) {
        BookInfo book = BOOKS_CACHE.get(code);
        if (book != null) {
            return book;
        }
        JsonObject obj = JsonFactory.getJsonObject((class_2960)EdenRing.makeID("lang/book/" + code + ".json"));
        if (obj == null) {
            obj = JsonFactory.getJsonObject((class_2960)EdenRing.makeID("lang/book/en_us.json"));
        }
        String prefix = obj.get("lineNumberPrefix").getAsString();
        JsonArray pages = obj.getAsJsonArray("pages");
        PageInfo[] bookPages = new PageInfo[pages.size() + 1];
        for (int i = 0; i < pages.size(); ++i) {
            bookPages[i + 1] = new PageInfo(pages.get(i).getAsJsonObject());
        }
        book = new BookInfo(prefix, bookPages);
        BOOKS_CACHE.put(code, book);
        return book;
    }

    public boolean method_25402(double x, double y, int i) {
        class_1144 soundManager = class_310.method_1551().method_1483();
        if (pageIndex < this.book.pages.length - 2 && x > (double)this.arrowNext.x && y > (double)this.arrowNext.y && x < (double)(this.arrowNext.x + 16) && y < (double)(this.arrowNext.y + 16)) {
            pageIndex = pageIndex == 0 ? 1 : pageIndex + 2;
            soundManager.method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_17481, (float)1.0f));
        }
        if (pageIndex > 0) {
            if (x > (double)this.arrowBack.x && y > (double)this.arrowBack.y && x < (double)(this.arrowBack.x + 16) && y < (double)(this.arrowBack.y + 16)) {
                if ((pageIndex -= 2) < 0) {
                    pageIndex = 0;
                }
                soundManager.method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_17481, (float)1.0f));
            } else if (!BACK_PAGES.isEmpty() && x > (double)this.arrowToHyper.x && y > (double)this.arrowToHyper.y && x < (double)(this.arrowToHyper.x + 16) && y < (double)(this.arrowToHyper.y + 16)) {
                Integer index = BACK_PAGES.pop();
                soundManager.method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_17481, (float)1.0f));
                pageIndex = index;
            } else {
                for (int j = 0; j < 2; j = (int)((byte)(j + 1))) {
                    int index = pageIndex + j;
                    if (index >= this.book.pages.length || this.book.pages[index] == null) continue;
                    this.book.pages[index].entries.forEach(pageEntry -> {
                        if (pageEntry instanceof HyperTextPageEntry) {
                            HyperTextPageEntry hyperText = (HyperTextPageEntry)pageEntry;
                            for (int n = 0; n < hyperText.start.length; n = (int)((byte)(n + 1))) {
                                Point start = hyperText.start[n];
                                if (start == null) continue;
                                Point size = hyperText.size[n];
                                float px = (float)(x - (double)start.x);
                                float py = (float)(y - (double)start.y);
                                if (!(px < (float)size.x) || !(py < (float)size.y)) continue;
                                if (hyperText.pages[n] == -1) break;
                                soundManager.method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_17481, (float)1.0f));
                                BACK_PAGES.push(pageIndex);
                                pageIndex = hyperText.pages[n];
                                break;
                            }
                        }
                    });
                }
            }
        }
        return super.method_25402(x, y, i);
    }

    public void method_25394(class_4587 poseStack, int i, int j, float f) {
        this.method_25420(poseStack);
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)BOOK_TEXTURE);
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableBlend();
        int posY = (this.field_22790 - 180) / 2;
        int arrowY = posY + 82;
        if (pageIndex <= 0) {
            int posX = (this.field_22789 - 146) / 2;
            this.arrowNext.setLocation(posX + 146 + 8, arrowY);
            this.renderImage(poseStack, posX, posY, 0, 0, 146, 180, 512, 256);
            this.renderImage(poseStack, this.arrowNext.x, arrowY, 16, 192, 16, 16, 512, 256);
        } else if (pageIndex + 1 >= this.book.pages.length) {
            int posX = (this.field_22789 - 146) / 2;
            this.arrowBack.setLocation(posX - 8 - 16, arrowY);
            this.arrowToHyper.setLocation(this.arrowBack);
            this.arrowToHyper.y = posY + 8;
            this.renderImage(poseStack, posX, posY, 160, 0, 146, 180, 512, 256);
            this.renderImage(poseStack, this.arrowBack.x, arrowY, 0, 192, 16, 16, 512, 256);
            if (!BACK_PAGES.empty()) {
                this.renderImage(poseStack, this.arrowToHyper.x, this.arrowToHyper.y, 0, 208, 16, 16, 512, 256);
            }
            this.book.pages[pageIndex].render(poseStack, posX, posY + 16, 146, 180);
            posY = posY + 180 - 18;
            String number = this.book.numberPrefix + pageIndex;
            this.field_22793.method_1729(poseStack, number, (float)(posX + 24), (float)posY, 0);
        } else {
            int posX1 = (this.field_22789 - 292 - 8) / 2;
            int posX2 = posX1 + 146 + 8;
            this.arrowBack.setLocation(posX1 - 8 - 16, arrowY);
            this.arrowToHyper.setLocation(this.arrowBack);
            this.arrowToHyper.y = posY + 8;
            this.renderImage(poseStack, posX1, posY, 160, 0, 146, 180, 512, 256);
            this.renderImage(poseStack, posX2, posY, 320, 0, 146, 180, 512, 256);
            this.renderImage(poseStack, this.arrowBack.x, arrowY, 0, 192, 16, 16, 512, 256);
            if (!BACK_PAGES.empty()) {
                this.renderImage(poseStack, this.arrowToHyper.x, this.arrowToHyper.y, 0, 208, 16, 16, 512, 256);
            }
            if (pageIndex < this.book.pages.length - 2) {
                this.arrowNext.setLocation(posX2 + 146 + 8, arrowY);
                this.renderImage(poseStack, this.arrowNext.x, arrowY, 16, 192, 16, 16, 512, 256);
            }
            this.book.pages[pageIndex].render(poseStack, posX1, posY + 16, 146, 180);
            this.book.pages[pageIndex + 1].render(poseStack, posX2 - 6, posY + 16, 146, 180);
            posY = posY + 180 - 18;
            String number1 = this.book.numberPrefix + pageIndex;
            String number2 = this.book.numberPrefix + (pageIndex + 1);
            this.field_22793.method_1729(poseStack, number1, (float)(posX1 + 24), (float)posY, 0);
            this.field_22793.method_1729(poseStack, number2, (float)(posX2 + 146 - 24 - this.field_22793.method_1727(number2)), (float)posY, 0);
        }
    }

    private void renderImage(class_4587 poseStack, int x, int y, int u, int v, int width, int height, int atlasWidth, int atlasHeight) {
        GuideBookScreen.method_25290((class_4587)poseStack, (int)x, (int)y, (float)u, (float)v, (int)width, (int)height, (int)atlasWidth, (int)atlasHeight);
    }

    class BookInfo {
        String numberPrefix;
        PageInfo[] pages;

        BookInfo(String numberPrefix, PageInfo[] pages) {
            this.numberPrefix = numberPrefix;
            this.pages = pages;
        }
    }

    class PageInfo {
        final List<PageEntry> entries = Lists.newArrayList();
        final String name;

        PageInfo(JsonObject obj) {
            JsonElement element = obj.get("name");
            this.name = element != null ? element.getAsString() : null;
            element = obj.get("entries");
            if (element != null && element instanceof JsonArray) {
                element.getAsJsonArray().forEach(entry -> {
                    JsonObject object = entry.getAsJsonObject();
                    String type = object.get("type").getAsString();
                    Function<JsonObject, PageEntry> init = ENTRY_REGISTRY.get(type);
                    if (init != null) {
                        this.entries.add(init.apply(object));
                    }
                });
            }
        }

        void render(class_4587 poseStack, int posX, int posY, int pageWidth, int pageHeight) {
            for (PageEntry entry : this.entries) {
                posY = entry.renderAndOffset(poseStack, posX + 2, posY, pageWidth, pageHeight) + 4;
            }
        }
    }

    class HyperTextPageEntry
    extends PageEntry {
        String[] lines;
        String[] keys;
        Point[] start;
        Point[] size;
        int[] pages;

        HyperTextPageEntry(JsonObject obj) {
            super(obj);
            JsonArray preLines = obj.getAsJsonArray("lines");
            this.lines = new String[preLines.size()];
            this.start = new Point[this.lines.length];
            this.size = new Point[this.lines.length];
            this.keys = new String[this.lines.length];
            this.pages = new int[this.lines.length];
            for (int i = 0; i < this.lines.length; ++i) {
                obj = preLines.get(i).getAsJsonObject();
                this.lines[i] = obj.get("text").getAsString();
                this.keys[i] = obj.get("link").getAsString();
            }
        }

        @Override
        int renderAndOffset(class_4587 poseStack, int posX, int posY, int pageWidth, int pageHeight) {
            posX += 16;
            for (int i = 0; i < this.lines.length; i = (int)((byte)(i + 1))) {
                String line = this.lines[i];
                if (this.start[i] == null) {
                    int width = GuideBookScreen.this.field_22793.method_1727(line);
                    Objects.requireNonNull(GuideBookScreen.this.field_22793);
                    int height = 9;
                    this.start[i] = new Point(posX, posY);
                    this.size[i] = new Point(width, height);
                    String key = this.keys[i];
                    this.pages[i] = -1;
                    for (int n = 1; n < GuideBookScreen.this.book.pages.length; ++n) {
                        PageInfo info = GuideBookScreen.this.book.pages[n];
                        if (info == null || info.name == null || !info.name.equals(key)) continue;
                        this.pages[i] = (n & 1) == 1 ? n : n - 1;
                        break;
                    }
                }
                this.start[i].setLocation(posX, posY);
                GuideBookScreen.this.field_22793.method_1729(poseStack, line, (float)posX, (float)posY, 0);
                Objects.requireNonNull(GuideBookScreen.this.field_22793);
                posY += 9;
            }
            return posY;
        }
    }

    class IconPageEntry
    extends PageEntry {
        private final class_1799 item;
        private final int height;
        final boolean centered;

        IconPageEntry(JsonObject obj) {
            super(obj);
            String text = obj.get("item").getAsString();
            this.height = obj.get("height").getAsInt();
            class_2960 location = new class_2960(text);
            this.item = new class_1799((class_1935)class_2378.field_11142.method_10223(location));
            JsonElement preCentered = obj.get("centered");
            this.centered = preCentered == null ? false : preCentered.getAsBoolean();
        }

        @Override
        int renderAndOffset(class_4587 poseStack, int posX, int posY, int pageWidth, int pageHeight) {
            int posHeight;
            int posSide = posX + (pageWidth - 16) / 2;
            int n = posHeight = this.centered ? posY + pageHeight / 2 + 16 : posY + 16;
            if (this.height != 16) {
                ItemScaler.setScale(this.height);
            }
            GuideBookScreen.this.minecraft.method_1480().method_4023(this.item, posSide, posHeight);
            return posY + this.height;
        }
    }

    class IllustrationPageEntry
    extends PageEntry {
        final class_2960 texture;
        final boolean centered;
        final int height;
        final int width;

        IllustrationPageEntry(JsonObject obj) {
            super(obj);
            this.texture = new class_2960(obj.get("image").getAsString());
            this.height = obj.get("height").getAsInt();
            this.width = obj.get("width").getAsInt();
            JsonElement preCentered = obj.get("centered");
            this.centered = preCentered == null ? false : preCentered.getAsBoolean();
        }

        @Override
        int renderAndOffset(class_4587 poseStack, int posX, int posY, int pageWidth, int pageHeight) {
            int posSide = posX + (pageWidth - this.width) / 2;
            int posHeight = this.centered ? posY - 16 + (pageHeight - this.height) / 2 : posY;
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.setShaderTexture((int)0, (class_2960)this.texture);
            GuideBookScreen.this.renderImage(poseStack, posSide, posHeight, 0, 0, this.width, this.height, this.width, this.height);
            return posY + this.height;
        }
    }

    class TitlePageEntry
    extends PageEntry {
        String title;

        TitlePageEntry(JsonObject obj) {
            super(obj);
            this.title = obj.get("title").getAsString();
        }

        @Override
        int renderAndOffset(class_4587 poseStack, int posX, int posY, int pageWidth, int pageHeight) {
            int width = GuideBookScreen.this.field_22793.method_1727(this.title);
            int posSide = posX + (pageWidth - width) / 2;
            GuideBookScreen.this.field_22793.method_1729(poseStack, this.title, (float)posSide, (float)posY, 0);
            Objects.requireNonNull(GuideBookScreen.this.field_22793);
            return posY + 9;
        }
    }

    class TextPageEntry
    extends PageEntry {
        boolean requireRecombination;
        String[] lines;

        TextPageEntry(JsonObject obj) {
            super(obj);
            this.requireRecombination = false;
            JsonElement element = obj.get("text");
            if (element.isJsonArray()) {
                JsonArray preLines = obj.getAsJsonArray("text");
                this.lines = new String[preLines.size()];
                for (int i = 0; i < this.lines.length; ++i) {
                    this.lines[i] = preLines.get(i).getAsString();
                }
            } else {
                this.requireRecombination = true;
                String text = element.getAsString();
                this.lines = text.split(" ");
            }
        }

        @Override
        int renderAndOffset(class_4587 poseStack, int posX, int posY, int pageWidth, int pageHeight) {
            posX += 16;
            if (this.requireRecombination) {
                String modifier = null;
                this.requireRecombination = false;
                if (this.lines[0].startsWith("\u00a7")) {
                    modifier = this.lines[0].substring(0, 2);
                }
                boolean run = true;
                ArrayList<String> newLines = new ArrayList<String>(this.lines.length >> 2);
                for (int i = 0; run && i < this.lines.length; ++i) {
                    int length = this.lines[i].length();
                    StringBuilder builder = new StringBuilder();
                    if (modifier != null) {
                        if (i == 0) {
                            length -= 2;
                        } else {
                            builder.append(modifier);
                        }
                    }
                    builder.append(this.lines[i]);
                    for (int j = i + 1; j < this.lines.length; ++j) {
                        String word = this.lines[j];
                        if ((length += word.length() + 1) >= 22) {
                            i = j - 1;
                            break;
                        }
                        builder.append(' ');
                        builder.append(word);
                        run = j != this.lines.length - 1;
                    }
                    String line = builder.toString();
                    newLines.add(line);
                }
                this.lines = newLines.toArray(new String[newLines.size()]);
            }
            for (String line : this.lines) {
                GuideBookScreen.this.field_22793.method_1729(poseStack, line, (float)posX, (float)posY, 0);
                Objects.requireNonNull(GuideBookScreen.this.field_22793);
                posY += 9;
            }
            return posY;
        }
    }

    abstract class PageEntry {
        PageEntry(JsonObject obj) {
        }

        abstract int renderAndOffset(class_4587 var1, int var2, int var3, int var4, int var5);
    }
}

