/*
 * Decompiled with CFR 0.152.
 */
package paulevs.edenring.client.environment.renderers;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.DimensionRenderingRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_1959;
import net.minecraft.class_243;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_291;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4543;
import net.minecraft.class_4587;
import net.minecraft.class_638;
import net.minecraft.class_6491;
import net.minecraft.class_757;
import net.minecraft.class_758;
import paulevs.edenring.EdenRing;
import paulevs.edenring.client.EdenRingClient;
import paulevs.edenring.world.MoonInfo;
import ru.bclib.util.BackgroundInfo;
import ru.bclib.util.MHelper;

@Environment(value=EnvType.CLIENT)
public class EdenSkyRenderer
implements DimensionRenderingRegistry.SkyRenderer {
    private static final class_2960 PLANET_TEXTURE = EdenRing.makeID("textures/environment/planet.png");
    private static final class_2960 MOON_TEXTURE = EdenRing.makeID("textures/environment/moon.png");
    private static final class_2960 RINGS_SOFT_TEXTURE = EdenRing.makeID("textures/environment/rings_soft.png");
    private static final class_2960 RINGS_TEXTURE = EdenRing.makeID("textures/environment/rings.png");
    private static final class_2960 HORIZON_BW = EdenRing.makeID("textures/environment/horizon_bw.png");
    private static final class_2960 HORIZON = EdenRing.makeID("textures/environment/horizon.png");
    private static final class_2960 NEBULA1 = EdenRing.makeID("textures/environment/nebula_1.png");
    private static final class_2960 NEBULA2 = EdenRing.makeID("textures/environment/nebula_2.png");
    private static final class_2960 STARS = EdenRing.makeID("textures/environment/stars.png");
    private static final class_2960 SUN_FADE = EdenRing.makeID("textures/environment/sun_fade.png");
    private static final class_2960 SUN = EdenRing.makeID("textures/environment/sun.png");
    private static final MoonInfo[] MOONS = new MoonInfo[8];
    private static class_287 bufferBuilder;
    private static class_291[] horizon;
    private static class_291[] nebula;
    private static class_291 stars;
    private boolean shouldInit = true;
    private static int windowHeight;
    private static int windowWidth;

    private void init() {
        this.shouldInit = false;
        bufferBuilder = class_289.method_1348().method_1349();
        if (horizon == null) {
            horizon = new class_291[3];
        }
        if (nebula == null) {
            nebula = new class_291[3];
        }
        EdenSkyRenderer.horizon[0] = this.buildBufferCylinder(bufferBuilder, horizon[0], 20.0);
        EdenSkyRenderer.horizon[1] = this.buildBufferCylinder(bufferBuilder, horizon[1], 40.0);
        EdenSkyRenderer.horizon[2] = this.buildBufferCylinder(bufferBuilder, horizon[2], 100.0);
        EdenSkyRenderer.nebula[0] = this.buildBufferCylinder(bufferBuilder, nebula[0], 30.0);
        EdenSkyRenderer.nebula[1] = this.buildBufferSquares(bufferBuilder, nebula[1], 20.0, 60.0, 10, 1, 235L);
        EdenSkyRenderer.nebula[2] = this.buildBufferSquares(bufferBuilder, nebula[2], 20.0, 60.0, 10, 1, 352L);
        stars = this.buildBufferSquares(bufferBuilder, stars, 0.125, 0.875, 5000, 4, 41315L);
        Random random = new Random(0L);
        for (int i = 0; i < MOONS.length; ++i) {
            EdenSkyRenderer.MOONS[i] = new MoonInfo(random);
        }
    }

    public void render(WorldRenderContext context) {
        double position;
        MoonInfo moon;
        int i;
        if (!EdenRingClient.CLIENT_CONFIG.renderSky()) {
            return;
        }
        class_638 level = context.world();
        class_1159 projectionMatrix = context.projectionMatrix();
        if (level == null || projectionMatrix == null) {
            return;
        }
        class_310 minecraft = class_310.method_1551();
        class_4587 poseStack = context.matrixStack();
        float tickDelta = context.tickDelta();
        if (this.shouldInit) {
            this.init();
        }
        double time = (double)level.method_8510() + (double)tickDelta;
        double py = minecraft.field_1724.method_19538().field_1351;
        float angle = class_3532.method_15363((float)((float)(py - 128.0) * 6.0E-4f), (float)-0.03f, (float)0.03f);
        float skyBlend = class_3532.method_15363((float)((float)Math.abs(py - 128.0) * 0.006f), (float)0.0f, (float)1.0f);
        py = py < 0.0 ? class_3532.method_15350((double)(-py * 0.05), (double)0.0, (double)1.0) : (py < 256.0 ? 0.0 : class_3532.method_15350((double)((py - 256.0) * 0.05), (double)0.0, (double)1.0));
        class_243 skyColor = this.getSkyColor(minecraft.field_1773.method_19418().method_19326(), tickDelta, level);
        float skyR = class_3532.method_16439((float)skyBlend, (float)((float)skyColor.field_1352 * 0.5f), (float)0.0f);
        float skyG = class_3532.method_16439((float)skyBlend, (float)((float)skyColor.field_1351 * 0.5f), (float)0.0f);
        float skyB = class_3532.method_16439((float)skyBlend, (float)((float)skyColor.field_1350 * 0.5f), (float)0.0f);
        RenderSystem.clear((int)16384, (boolean)class_310.field_1703);
        class_758.method_23792();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.disableBlend();
        RenderSystem.disableCull();
        RenderSystem.disableTexture();
        RenderSystem.disableDepthTest();
        RenderSystem.clearColor((float)skyR, (float)skyG, (float)skyB, (float)1.0f);
        RenderSystem.setShaderColor((float)skyR, (float)skyG, (float)skyB, (float)1.0f);
        RenderSystem.setShader(class_757::method_34539);
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1592);
        bufferBuilder.method_22918(projectionMatrix, -10.0f, -10.0f, 0.0f).method_1344();
        bufferBuilder.method_22918(projectionMatrix, 10.0f, -10.0f, 0.0f).method_1344();
        bufferBuilder.method_22918(projectionMatrix, 10.0f, 10.0f, 0.0f).method_1344();
        bufferBuilder.method_22918(projectionMatrix, -10.0f, 10.0f, 0.0f).method_1344();
        bufferBuilder.method_1326();
        class_286.method_1309((class_287)bufferBuilder);
        float dayTime = level.method_30274(tickDelta);
        RenderSystem.enableTexture();
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.enableBlend();
        poseStack.method_22903();
        poseStack.method_22907(class_1160.field_20703.method_23626(-0.4f));
        poseStack.method_22907(class_1160.field_20705.method_23626(1.5707964f - dayTime * (float)Math.PI * 2.0f));
        RenderSystem.setShaderTexture((int)0, (class_2960)STARS);
        this.renderBuffer(poseStack, projectionMatrix, stars, class_290.field_1585, 1.0f, 1.0f, 1.0f, skyBlend * 0.25f + 0.75f);
        float nebulaBlend = skyBlend * 0.75f + 0.25f;
        float nebulaBlend2 = nebulaBlend * 0.15f;
        RenderSystem.setShaderTexture((int)0, (class_2960)NEBULA1);
        this.renderBuffer(poseStack, projectionMatrix, nebula[1], class_290.field_1585, 1.0f, 1.0f, 1.0f, nebulaBlend2);
        RenderSystem.setShaderTexture((int)0, (class_2960)NEBULA2);
        this.renderBuffer(poseStack, projectionMatrix, nebula[2], class_290.field_1585, 1.0f, 1.0f, 1.0f, nebulaBlend2);
        RenderSystem.setShaderTexture((int)0, (class_2960)HORIZON);
        this.renderBuffer(poseStack, projectionMatrix, nebula[0], class_290.field_1585, 1.0f, 1.0f, 1.0f, nebulaBlend);
        poseStack.method_22903();
        poseStack.method_22907(class_1160.field_20707.method_23626(1.5707964f));
        class_1159 matrix = poseStack.method_23760().method_23761();
        RenderSystem.setShaderColor((float)skyR, (float)skyG, (float)skyB, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)SUN_FADE);
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        bufferBuilder.method_22918(matrix, -80.0f, 100.0f, -80.0f).method_22913(0.0f, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, 80.0f, 100.0f, -80.0f).method_22913(1.0f, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, 80.0f, 100.0f, 80.0f).method_22913(1.0f, 1.0f).method_1344();
        bufferBuilder.method_22918(matrix, -80.0f, 100.0f, 80.0f).method_22913(0.0f, 1.0f).method_1344();
        bufferBuilder.method_1326();
        class_286.method_1309((class_287)bufferBuilder);
        float color = (float)Math.cos((double)dayTime * Math.PI * 2.0) * 1.1f;
        color = class_3532.method_15363((float)color, (float)0.3f, (float)1.0f);
        RenderSystem.setShaderColor((float)1.0f, (float)color, (float)color, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)SUN);
        RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ZERO);
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        bufferBuilder.method_22918(matrix, -30.0f, 100.0f, -30.0f).method_22913(0.0f, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, 30.0f, 100.0f, -30.0f).method_22913(1.0f, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, 30.0f, 100.0f, 30.0f).method_22913(1.0f, 1.0f).method_1344();
        bufferBuilder.method_22918(matrix, -30.0f, 100.0f, 30.0f).method_22913(0.0f, 1.0f).method_1344();
        bufferBuilder.method_1326();
        class_286.method_1309((class_287)bufferBuilder);
        RenderSystem.defaultBlendFunc();
        poseStack.method_22909();
        poseStack.method_22909();
        RenderSystem.defaultBlendFunc();
        poseStack.method_22903();
        poseStack.method_22904(0.0, 0.0, -100.0);
        poseStack.method_22907(class_1160.field_20703.method_23626(angle));
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)RINGS_SOFT_TEXTURE);
        matrix = poseStack.method_23760().method_23761();
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        bufferBuilder.method_22918(matrix, -130.0f, 0.0f, -130.0f).method_22913(0.0f, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, 130.0f, 0.0f, -130.0f).method_22913(1.0f, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, 130.0f, 0.0f, 130.0f).method_22913(1.0f, 1.0f).method_1344();
        bufferBuilder.method_22918(matrix, -130.0f, 0.0f, 130.0f).method_22913(0.0f, 1.0f).method_1344();
        bufferBuilder.method_1326();
        class_286.method_1309((class_287)bufferBuilder);
        poseStack.method_22909();
        int frame = (int)(dayTime * 12.0f + 0.5f);
        float v0 = (float)frame / 12.0f;
        float v1 = v0 + 0.083f;
        for (i = 0; i < MOONS.length; ++i) {
            moon = MOONS[i];
            position = moon.orbitState + dayTime * moon.speed;
            this.renderMoon(false, poseStack, position, moon.orbitRadius, moon.orbitAngle, moon.size, v0, v1, moon.color);
        }
        poseStack.method_22903();
        poseStack.method_22904(0.0, 0.0, -100.0);
        matrix = poseStack.method_23760().method_23761();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)PLANET_TEXTURE);
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        bufferBuilder.method_22918(matrix, -140.0f, 140.0f, 0.0f).method_22913(0.0f, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, 140.0f, 140.0f, 0.0f).method_22913(1.0f, 0.0f).method_1344();
        bufferBuilder.method_22918(matrix, 140.0f, -140.0f, 0.0f).method_22913(1.0f, 1.0f).method_1344();
        bufferBuilder.method_22918(matrix, -140.0f, -140.0f, 0.0f).method_22913(0.0f, 1.0f).method_1344();
        bufferBuilder.method_1326();
        class_286.method_1309((class_287)bufferBuilder);
        poseStack.method_22909();
        for (i = 0; i < MOONS.length; ++i) {
            moon = MOONS[i];
            position = moon.orbitState + dayTime * moon.speed;
            this.renderMoon(true, poseStack, position, moon.orbitRadius, moon.orbitAngle, moon.size, v0, v1, moon.color);
        }
        if (py > 0.0) {
            poseStack.method_22903();
            poseStack.method_22904(0.0, 0.0, -100.0);
            poseStack.method_22907(class_1160.field_20703.method_23626(angle));
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)(py > 0.5 ? 0.5f : (float)py));
            RenderSystem.setShaderTexture((int)0, (class_2960)RINGS_TEXTURE);
            matrix = poseStack.method_23760().method_23761();
            bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
            bufferBuilder.method_22918(matrix, -130.0f, 0.001f, 0.0f).method_22913(0.0f, 0.5f).method_1344();
            bufferBuilder.method_22918(matrix, 130.0f, 0.001f, 0.0f).method_22913(1.0f, 0.5f).method_1344();
            bufferBuilder.method_22918(matrix, 130.0f, 0.001f, 130.0f).method_22913(1.0f, 1.0f).method_1344();
            bufferBuilder.method_22918(matrix, -130.0f, 0.001f, 130.0f).method_22913(0.0f, 1.0f).method_1344();
            bufferBuilder.method_1326();
            class_286.method_1309((class_287)bufferBuilder);
            poseStack.method_22909();
        }
        if (py < 1.0) {
            RenderSystem.setShaderTexture((int)0, (class_2960)HORIZON_BW);
            if (BackgroundInfo.fogDensity > 1.5f) {
                float density = class_3532.method_15363((float)(BackgroundInfo.fogDensity - 1.5f), (float)0.0f, (float)1.0f);
                poseStack.method_22903();
                poseStack.method_22907(class_1160.field_20705.method_23626((float)(-time * 3.0E-5)));
                this.renderBuffer(poseStack, projectionMatrix, horizon[1], class_290.field_1585, BackgroundInfo.fogColorRed * 0.7f, BackgroundInfo.fogColorGreen * 0.7f, BackgroundInfo.fogColorBlue * 0.7f, (1.0f - skyBlend) * density);
                poseStack.method_22909();
            }
            poseStack.method_22903();
            poseStack.method_22907(class_1160.field_20705.method_23626((float)(time * 2.0E-4)));
            float density = class_3532.method_15363((float)BackgroundInfo.fogDensity, (float)1.0f, (float)2.0f);
            this.renderBuffer(poseStack, projectionMatrix, horizon[0], class_290.field_1585, BackgroundInfo.fogColorRed, BackgroundInfo.fogColorGreen, BackgroundInfo.fogColorBlue, (1.0f - skyBlend) * 0.5f * density);
            poseStack.method_22909();
            poseStack.method_22903();
            poseStack.method_22907(class_1160.field_20705.method_23626((float)(-time * 1.0E-4)));
            this.renderBuffer(poseStack, projectionMatrix, horizon[1], class_290.field_1585, BackgroundInfo.fogColorRed, BackgroundInfo.fogColorGreen, BackgroundInfo.fogColorBlue, (1.0f - skyBlend) * 0.5f);
            poseStack.method_22909();
        }
        if (BackgroundInfo.blindness > 0.0f) {
            RenderSystem.defaultBlendFunc();
            RenderSystem.disableTexture();
            RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)BackgroundInfo.blindness);
            RenderSystem.setShader(class_757::method_34539);
            bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1592);
            bufferBuilder.method_22918(projectionMatrix, -10.0f, -10.0f, 0.0f).method_1344();
            bufferBuilder.method_22918(projectionMatrix, 10.0f, -10.0f, 0.0f).method_1344();
            bufferBuilder.method_22918(projectionMatrix, 10.0f, 10.0f, 0.0f).method_1344();
            bufferBuilder.method_22918(projectionMatrix, -10.0f, 10.0f, 0.0f).method_1344();
            bufferBuilder.method_1326();
            class_286.method_1309((class_287)bufferBuilder);
        }
        RenderSystem.enableTexture();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableBlend();
        RenderSystem.enableDepthTest();
        RenderSystem.enableCull();
    }

    private class_291 buildBufferCylinder(class_287 bufferBuilder, class_291 buffer, double height) {
        if (buffer != null) {
            buffer.close();
        }
        buffer = new class_291();
        this.makeCylinder(bufferBuilder, 16, height, 100.0);
        bufferBuilder.method_1326();
        buffer.method_1352(bufferBuilder);
        return buffer;
    }

    private void renderBuffer(class_4587 matrices, class_1159 matrix4f, class_291 buffer, class_293 format, float r, float g, float b, float a) {
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)a);
        if (format == class_290.field_1592) {
            buffer.method_34427(matrices.method_23760().method_23761(), matrix4f, class_757.method_34539());
        } else {
            buffer.method_34427(matrices.method_23760().method_23761(), matrix4f, class_757.method_34542());
        }
    }

    private void makeCylinder(class_287 buffer, int segments, double height, double radius) {
        buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        for (int i = 0; i < segments; ++i) {
            double a1 = (double)i * Math.PI * 2.0 / (double)segments;
            double a2 = (double)(i + 1) * Math.PI * 2.0 / (double)segments;
            double px1 = Math.sin(a1) * radius;
            double pz1 = Math.cos(a1) * radius;
            double px2 = Math.sin(a2) * radius;
            double pz2 = Math.cos(a2) * radius;
            float u0 = (float)i / (float)segments;
            float u1 = (float)(i + 1) / (float)segments;
            buffer.method_22912(px1, -height, pz1).method_22913(u0, 0.0f).method_1344();
            buffer.method_22912(px1, height, pz1).method_22913(u0, 1.0f).method_1344();
            buffer.method_22912(px2, height, pz2).method_22913(u1, 1.0f).method_1344();
            buffer.method_22912(px2, -height, pz2).method_22913(u1, 0.0f).method_1344();
        }
    }

    private class_291 buildBufferSquares(class_287 bufferBuilder, class_291 buffer, double minSize, double maxSize, int count, int verticalCount, long seed) {
        if (buffer != null) {
            buffer.close();
        }
        buffer = new class_291();
        this.makeStars(bufferBuilder, minSize, maxSize, count, verticalCount, seed);
        bufferBuilder.method_1326();
        buffer.method_1352(bufferBuilder);
        return buffer;
    }

    private void makeStars(class_287 buffer, double minSize, double maxSize, int count, int verticalCount, long seed) {
        Random random = new Random(seed);
        buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        for (int i = 0; i < count; ++i) {
            double posX = random.nextDouble() * 2.0 - 1.0;
            double posY = random.nextDouble() * 2.0 - 1.0;
            double posZ = random.nextDouble() * 2.0 - 1.0;
            double size = MHelper.randRange((double)minSize, (double)maxSize, (Random)random);
            double length = posX * posX + posY * posY + posZ * posZ;
            if (!(length < 1.0) || !(length > 0.001)) continue;
            length = 1.0 / Math.sqrt(length);
            double j = (posX *= length) * 100.0;
            double k = (posY *= length) * 100.0;
            double l = (posZ *= length) * 100.0;
            double m = Math.atan2(posX, posZ);
            double n = Math.sin(m);
            double o = Math.cos(m);
            double p = Math.atan2(Math.sqrt(posX * posX + posZ * posZ), posY);
            double q = Math.sin(p);
            double r = Math.cos(p);
            double s = random.nextDouble() * Math.PI * 2.0;
            double t = Math.sin(s);
            double u = Math.cos(s);
            int pos = 0;
            float minV = verticalCount < 2 ? 0.0f : (float)random.nextInt(verticalCount) / (float)verticalCount;
            for (int v = 0; v < 4; ++v) {
                double x = (double)((v & 2) - 1) * size;
                double y = (double)((v + 1 & 2) - 1) * size;
                double aa = x * u - y * t;
                double ab = y * u + x * t;
                double ad = aa * q + 0.0 * r;
                double ae = 0.0 * q - aa * r;
                double af = ae * n - ab * o;
                double ah = ab * n + ae * o;
                float texU = pos >> 1 & 1;
                float texV = (float)(pos + 1 >> 1 & 1) / (float)verticalCount + minV;
                ++pos;
                buffer.method_22912(j + af, k + ad, l + ah).method_22913(texU, texV).method_1344();
            }
        }
    }

    private void renderMoon(boolean front, class_4587 matrices, double orbitPosition, float orbitRadius, float orbitAngle, float size, float v0, float v1, class_1160 color) {
        float offset2 = (float)Math.cos(orbitPosition);
        if (front && offset2 < 0.0f) {
            return;
        }
        if (!front && offset2 >= 0.0f) {
            return;
        }
        float offset1 = (float)Math.sin(orbitPosition);
        matrices.method_22903();
        matrices.method_22904((double)(offset1 * (70.0f + orbitRadius)), (double)(offset1 * orbitAngle), (double)(offset2 * orbitRadius - 100.0f));
        class_1159 matrix = matrices.method_23760().method_23761();
        RenderSystem.setShaderColor((float)color.method_4943(), (float)color.method_4945(), (float)color.method_4947(), (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)MOON_TEXTURE);
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        bufferBuilder.method_22918(matrix, -size, size, 0.0f).method_22913(0.0f, v0).method_1344();
        bufferBuilder.method_22918(matrix, size, size, 0.0f).method_22913(1.0f, v0).method_1344();
        bufferBuilder.method_22918(matrix, size, -size, 0.0f).method_22913(1.0f, v1).method_1344();
        bufferBuilder.method_22918(matrix, -size, -size, 0.0f).method_22913(0.0f, v1).method_1344();
        bufferBuilder.method_1326();
        class_286.method_1309((class_287)bufferBuilder);
        matrices.method_22909();
    }

    private class_243 getSkyColor(class_243 pos, float tickDelta, class_638 level) {
        class_243 samplePos = pos.method_1023(2.0, 2.0, 2.0).method_1021(0.25);
        class_4543 biomeManager = level.method_22385();
        class_243 color = class_6491.method_24895((class_243)samplePos, (i, j, k) -> class_243.method_24457((int)((class_1959)biomeManager.method_24854(i, j, k).comp_349()).method_8697()));
        float light = class_3532.method_15362((float)(level.method_30274(tickDelta) * ((float)Math.PI * 2))) * 2.0f + 0.5f;
        light = class_3532.method_15363((float)light, (float)0.0f, (float)1.0f);
        return color.method_18805((double)light, (double)light, (double)light);
    }
}

