/*
 * Decompiled with CFR 0.152.
 */
package paulevs.edenring.client.environment.animation;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_1162;
import net.minecraft.class_1923;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2818;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4604;
import net.minecraft.class_638;
import org.jetbrains.annotations.Nullable;
import paulevs.edenring.client.environment.TransformHelper;
import paulevs.edenring.client.environment.animation.SpriteAnimation;
import paulevs.edenring.client.environment.animation.SpriteChunk;
import paulevs.edenring.interfaces.BiomeCountProvider;
import paulevs.edenring.interfaces.SpriteInitializer;
import ru.bclib.api.biomes.BiomeAPI;
import ru.bclib.util.MHelper;
import ru.bclib.world.biomes.BCLBiome;

public class SpriteGrid {
    private final BiomeCountProvider spriteCount;
    private final SpriteInitializer initializer;
    private final List<List<class_1923>> missingChunks = new ArrayList<List<class_1923>>(2);
    private final SpriteChunk[][] chunks = new SpriteChunk[128][128];
    private final List<SpriteAnimation> animations = new ArrayList<SpriteAnimation>(256);
    private final Random random = new Random();
    private final class_1162 color = new class_1162();
    private final class_1160 pos = new class_1160();
    private class_638 lastLevel;
    private int lastDistance = -1;
    private byte missingIndex;
    private long lastTicks;
    private int lastX;
    private int lastZ;
    private float[] fogColor;
    private float fogDelta;
    private float fogStart;
    private float fogEnd;
    private float light;

    public SpriteGrid(SpriteInitializer initializer, BiomeCountProvider spriteCount) {
        this.initializer = initializer;
        this.spriteCount = spriteCount;
        this.missingChunks.add(new ArrayList(1024));
        this.missingChunks.add(new ArrayList(1024));
    }

    public void render(class_638 level, class_1923 pos, int distance, class_4587 poseStack, class_4184 camera, float tickDelta, @Nullable class_4604 frustum) {
        if (distance > 127) {
            distance = 127;
        }
        int half = distance >> 1;
        List<class_1923> missing = this.missingChunks.get(this.missingIndex);
        long ticks = level.method_8510();
        if (ticks >= this.lastTicks) {
            this.lastTicks = ticks + 20L;
            if (!missing.isEmpty()) {
                this.missingIndex = (byte)(this.missingIndex + 1 & 1);
                List<class_1923> missingNew = this.missingChunks.get(this.missingIndex);
                missing.forEach(p -> {
                    if (MHelper.max((int)class_3532.method_15382((int)(pos.field_9181 - p.field_9181)), (int)class_3532.method_15382((int)(pos.field_9180 - p.field_9180))) >= half) {
                        return;
                    }
                    class_2818 levelChunk = level.method_8497(p.field_9181, p.field_9180);
                    if (levelChunk.method_12223() && levelChunk.method_12004().field_9181 == 0 && levelChunk.method_12004().field_9180 == 0) {
                        missingNew.add((class_1923)p);
                        return;
                    }
                    int dx = p.field_9181 & 0x7F;
                    int dz = p.field_9180 & 0x7F;
                    SpriteChunk chunk = this.chunks[dx][dz];
                    if (chunk == null || !chunk.isCorrectPos(p.field_9181, p.field_9180)) {
                        this.chunks[dx][dz] = chunk = this.initChunk(level, p.field_9181, p.field_9180);
                    }
                    this.animations.addAll(chunk.getPoints());
                });
                this.sort(camera);
                missing.clear();
            }
        }
        if (this.lastLevel != level || this.lastX != pos.field_9181 || this.lastZ != pos.field_9180 || this.lastDistance != distance) {
            this.animations.clear();
            this.lastX = pos.field_9181;
            this.lastZ = pos.field_9180;
            this.lastDistance = distance;
            if (this.lastLevel != level) {
                this.lastLevel = level;
                for (int i = 0; i < this.chunks.length; i = (int)((short)(i + 1))) {
                    for (int j = 0; j < this.chunks[0].length; j = (int)((short)(j + 1))) {
                        this.chunks[i][j] = null;
                    }
                }
            }
            for (int i = 0; i < distance; i = (int)((byte)(i + 1))) {
                int px = pos.field_9181 - half + i;
                int dx = px & 0x7F;
                for (int j = 0; j < distance; j = (int)((byte)(j + 1))) {
                    int pz = pos.field_9180 - half + j;
                    int dz = pz & 0x7F;
                    SpriteChunk chunk = this.chunks[dx][dz];
                    if (chunk == null || !chunk.isCorrectPos(px, pz)) {
                        chunk = this.initChunk(level, px, pz);
                        if (chunk == null) {
                            missing.add(new class_1923(px, pz));
                            continue;
                        }
                        this.chunks[dx][dz] = chunk;
                    }
                    this.animations.addAll(chunk.getPoints());
                }
            }
            this.sort(camera);
        }
        if (this.animations.isEmpty()) {
            return;
        }
        SpriteAnimation animation = this.animations.get(0);
        float max = (float)half * 16.0f;
        float min = 128.0f;
        if (max < min) {
            max = min * 1.5f;
        }
        float delta = max - min;
        class_243 camPos = camera.method_19326();
        if (animation.useFogColor()) {
            this.fogColor = RenderSystem.getShaderFogColor();
            this.fogStart = RenderSystem.getShaderFogStart() * animation.fogStartMultiplier();
            this.fogEnd = RenderSystem.getShaderFogEnd() * animation.fogEndMultiplier();
            this.fogDelta = this.fogEnd - this.fogStart;
            float dayTime = level.method_30274(tickDelta);
            this.light = class_3532.method_15363((float)((float)Math.cos((double)dayTime * Math.PI * 2.0) * 1.1f), (float)0.2f, (float)1.0f);
        }
        double time = (double)level.method_8510() + (double)tickDelta;
        class_287 bufferBuilder = class_289.method_1348().method_1349();
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1575);
        this.animations.forEach(sprite -> {
            float z;
            float y;
            class_238 bb;
            sprite.update(time);
            if (sprite.getFrame() < 0 || sprite.getAlpha() < 0.01f || sprite.getScale() < 0.01f) {
                return;
            }
            if (frustum != null && (bb = sprite.getBoundingBox()) != null && !frustum.method_23093(bb)) {
                return;
            }
            class_2338 origin = sprite.getOrigin();
            float x = (float)((double)origin.method_10263() - camPos.field_1352);
            float length = MHelper.length((float)x, (float)(y = (float)((double)origin.method_10264() - camPos.field_1351)), (float)(z = (float)((double)origin.method_10260() - camPos.field_1350)));
            if (length <= min) {
                return;
            }
            float dist = (length - min) / delta;
            dist = Math.abs(dist * 2.0f - 1.0f);
            if (sprite.useSqrSqr()) {
                dist *= dist;
            }
            dist = 1.0f - dist * dist;
            float a = class_3532.method_15363((float)(sprite.getAlpha() * dist * 0.75f), (float)0.0f, (float)1.0f);
            if (a < 0.01f) {
                return;
            }
            if (sprite.useFogColor()) {
                float fogMix = (length - this.fogStart) / this.fogDelta;
                if (fogMix > 1.0f) {
                    fogMix = 1.0f;
                }
                float r = class_3532.method_15363((float)class_3532.method_16439((float)fogMix, (float)this.light, (float)(this.fogColor[0] * 1.2f)), (float)0.2f, (float)1.0f);
                float g = class_3532.method_15363((float)class_3532.method_16439((float)fogMix, (float)this.light, (float)(this.fogColor[1] * 1.2f)), (float)0.2f, (float)1.0f);
                float b = class_3532.method_15363((float)class_3532.method_16439((float)fogMix, (float)this.light, (float)(this.fogColor[2] * 1.2f)), (float)0.2f, (float)1.0f);
                this.color.method_23851(r, g, b, a);
            } else {
                this.color.method_23851(1.0f, 1.0f, 1.0f, a);
            }
            this.pos.method_4949(x, y, z);
            sprite.offset(this.pos);
            float v = (float)sprite.getFrame() * sprite.getVSize();
            this.renderSprite(sprite.getScale(), v, v + sprite.getVSize(), bufferBuilder, poseStack);
        });
        bufferBuilder.method_1326();
        class_286.method_1309((class_287)bufferBuilder);
    }

    private SpriteChunk initChunk(class_638 level, int px, int pz) {
        class_2818 levelChunk = level.method_8497(px, pz);
        if (levelChunk.method_12223()) {
            return null;
        }
        this.random.setSeed(MHelper.getSeed((int)0, (int)px, (int)pz));
        BCLBiome biome = BiomeAPI.getRenderBiome((class_1959)((class_1959)levelChunk.method_16359(2, 32, 2).comp_349()));
        int count = this.spriteCount.getCount(biome, this.random);
        return new SpriteChunk(px, pz, this.random, count, this.initializer);
    }

    private void renderSprite(float size, float v1, float v2, class_287 bufferBuilder, class_4587 poseStack) {
        poseStack.method_22903();
        TransformHelper.translateAndRotateRelative(this.pos.method_4943(), this.pos.method_4945(), this.pos.method_4947(), poseStack);
        this.renderQuad(bufferBuilder, poseStack, size, v1, v2);
        poseStack.method_22909();
    }

    private void renderQuad(class_287 bufferBuilder, class_4587 poseStack, float size, float v1, float v2) {
        class_1159 matrix = poseStack.method_23760().method_23761();
        bufferBuilder.method_22918(matrix, -size, -size, 0.0f).method_22913(0.0f, v2).method_22915(this.color.method_4953(), this.color.method_4956(), this.color.method_4957(), this.color.method_23853()).method_1344();
        bufferBuilder.method_22918(matrix, size, -size, 0.0f).method_22913(1.0f, v2).method_22915(this.color.method_4953(), this.color.method_4956(), this.color.method_4957(), this.color.method_23853()).method_1344();
        bufferBuilder.method_22918(matrix, size, size, 0.0f).method_22913(1.0f, v1).method_22915(this.color.method_4953(), this.color.method_4956(), this.color.method_4957(), this.color.method_23853()).method_1344();
        bufferBuilder.method_22918(matrix, -size, size, 0.0f).method_22913(0.0f, v1).method_22915(this.color.method_4953(), this.color.method_4956(), this.color.method_4957(), this.color.method_23853()).method_1344();
    }

    private void sort(class_4184 camera) {
        class_2338 camBlockPos = camera.method_19328();
        this.animations.sort((c1, c2) -> {
            float d1 = camBlockPos.method_19455((class_2382)c1.getOrigin());
            float d2 = camBlockPos.method_19455((class_2382)c2.getOrigin());
            return Float.compare(d2, d1);
        });
    }
}

