/*
 * Decompiled with CFR 0.152.
 */
package paulevs.edenring.client;

import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.rendering.v1.DimensionRenderingRegistry;
import net.fabricmc.loader.api.FabricLoader;
import paulevs.edenring.EdenRing;
import paulevs.edenring.client.EdenClientConfig;
import paulevs.edenring.client.environment.renderers.EdenCloudRenderer;
import paulevs.edenring.client.environment.renderers.EdenSkyRenderer;
import paulevs.edenring.client.environment.renderers.EdenWeatherRenderer;
import paulevs.edenring.registries.EdenBlockEntitiesRenderers;
import paulevs.edenring.registries.EdenEntitiesRenderers;
import paulevs.edenring.registries.EdenParticles;
import ru.bclib.BCLib;
import ru.bclib.util.TranslationHelper;

public class EdenRingClient
implements ClientModInitializer {
    public static final EdenClientConfig CLIENT_CONFIG = new EdenClientConfig();
    private static boolean hasIris;

    public void onInitializeClient() {
        EdenBlockEntitiesRenderers.init();
        EdenEntitiesRenderers.init();
        EdenParticles.register();
        if (BCLib.isDevEnvironment()) {
            TranslationHelper.printMissingEnNames((String)"edenring");
            TranslationHelper.printMissingNames((String)"edenring", (String)"ru_ru");
        }
        DimensionRenderingRegistry.registerSkyRenderer(EdenRing.EDEN_RING_KEY, (DimensionRenderingRegistry.SkyRenderer)new EdenSkyRenderer());
        DimensionRenderingRegistry.registerCloudRenderer(EdenRing.EDEN_RING_KEY, (DimensionRenderingRegistry.CloudRenderer)new EdenCloudRenderer());
        DimensionRenderingRegistry.registerWeatherRenderer(EdenRing.EDEN_RING_KEY, (DimensionRenderingRegistry.WeatherRenderer)new EdenWeatherRenderer());
        CLIENT_CONFIG.saveChanges();
        hasIris = FabricLoader.getInstance().isModLoaded("iris");
    }

    public static boolean hasIris() {
        return hasIris;
    }
}

