/*
 * Decompiled with CFR 0.152.
 */
package paulevs.edenring.blocks.entities;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.dimension.v1.FabricDimensions;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3614;
import net.minecraft.class_5281;
import net.minecraft.class_5321;
import net.minecraft.class_5454;
import net.minecraft.class_5821;
import net.minecraft.server.MinecraftServer;
import paulevs.edenring.EdenRing;
import paulevs.edenring.interfaces.EdenPortable;
import paulevs.edenring.registries.EdenBlockEntities;
import paulevs.edenring.registries.EdenFeatures;
import paulevs.edenring.world.EdenPortal;

public class EdenPortalBlockEntity
extends class_2586 {
    private int checkTicks;
    private long ticks;
    private class_238 box;

    public EdenPortalBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(EdenBlockEntities.EDEN_PORTAL, blockPos, blockState);
    }

    @Environment(value=EnvType.CLIENT)
    public static <T extends class_2586> void clientTick(class_1937 level, class_2338 blockPos, class_2680 state, T entity) {
        if (entity == null || !(entity instanceof EdenPortalBlockEntity)) {
            return;
        }
        ++((EdenPortalBlockEntity)entity).ticks;
    }

    @Environment(value=EnvType.CLIENT)
    public long getTicks() {
        return this.ticks;
    }

    public static <T extends class_2586> void serverTick(class_1937 level, class_2338 blockPos, class_2680 state, T entity) {
        class_5321<class_1937> key;
        List entities;
        if (entity == null || !(entity instanceof EdenPortalBlockEntity)) {
            return;
        }
        EdenPortalBlockEntity portal = (EdenPortalBlockEntity)entity;
        if (portal.checkTicks > 10) {
            portal.checkTicks = 0;
            if (!EdenPortal.checkOldPortal(level, blockPos)) {
                EdenPortal.destroyPortal(level, blockPos);
                level.method_8501(blockPos, class_2246.field_10124.method_9564());
                portal.method_11012();
                return;
            }
        }
        ++portal.checkTicks;
        if (portal.box == null) {
            portal.box = new class_238(blockPos);
            portal.box = portal.box.method_1009(0.5, 0.0, 0.5).method_35578((double)(blockPos.method_10264() + 3));
        }
        if ((entities = level.method_8335(null, portal.box)).isEmpty()) {
            return;
        }
        MinecraftServer server = level.method_8503();
        class_3218 destination = server.method_3847(key = level.method_27983().equals(EdenRing.EDEN_RING_KEY) ? class_1937.field_25179 : EdenRing.EDEN_RING_KEY);
        if (destination == null) {
            return;
        }
        class_2338.class_2339 preExit = EdenPortalBlockEntity.getExit((class_1937)destination, blockPos);
        if (preExit == null) {
            preExit = blockPos.method_25503();
            EdenPortalBlockEntity.getLand((class_1937)destination, preExit);
            if (preExit.method_10264() == 130 && destination.method_8320(preExit.method_10087(2)).method_26215()) {
                EdenFeatures.SMALL_ISLAND.getFeature().method_13151(new class_5821(Optional.empty(), (class_5281)destination, destination.method_14178().method_12129(), destination.field_9229, preExit.method_10087(2), null));
            }
            EdenPortal.buildPortal((class_1937)destination, (class_2338)preExit);
        }
        class_2338.class_2339 exit = preExit;
        entities.forEach(e -> {
            if (e.method_5805()) {
                EdenPortable portable = (EdenPortable)e;
                if (portable.getPortalTimeout() > 0) {
                    portable.setPortalTimeout(20);
                } else if (e instanceof class_3222) {
                    class_3222 player = (class_3222)e;
                    FabricDimensions.teleport((class_1297)player, (class_3218)destination, (class_5454)new class_5454(new class_243((double)exit.method_10263() + 0.5, (double)exit.method_10264(), (double)exit.method_10260() + 0.5), new class_243(0.0, 0.0, 0.0), player.method_36454(), player.method_36455()));
                    ((EdenPortable)player).setPortalTimeout(20);
                } else {
                    e.method_5772();
                    class_1297 newEntity = e.method_5864().method_5883((class_1937)destination);
                    newEntity.method_5878(e);
                    e.method_5650(class_1297.class_5529.field_27002);
                    destination.method_18769(newEntity);
                    ((EdenPortable)newEntity).setPortalTimeout(100);
                    newEntity.method_5859((double)exit.method_10263() + 0.5, (double)exit.method_10264(), (double)exit.method_10260() + 0.5);
                }
            }
        });
    }

    private static class_2338.class_2339 getExit(class_1937 level, class_2338 start) {
        int x1 = (start.method_10263() >> 4) - 1;
        int z1 = (start.method_10260() >> 4) - 1;
        int x2 = x1 + 3;
        int z2 = z1 + 3;
        ArrayList<class_2586> entityList = new ArrayList<class_2586>();
        for (int x = x1; x < x2; ++x) {
            for (int z = z1; z < z2; ++z) {
                Map entities = level.method_8497(x, z).method_12214();
                entityList.addAll(entities.values().stream().filter(entity -> entity instanceof EdenPortalBlockEntity).toList());
            }
        }
        int size = entityList.size();
        if (size == 0) {
            return null;
        }
        class_2586 target = size == 1 ? (class_2586)entityList.get(0) : (class_2586)entityList.get(level.field_9229.nextInt(size));
        return target.method_11016().method_25503();
    }

    private static void getLand(class_1937 level, class_2338.class_2339 pos) {
        class_2791 chunk = level.method_8402(pos.method_10263() >> 4, pos.method_10260() >> 4, class_2806.field_12803, true);
        pos.method_33097(pos.method_10263() & 0xF);
        pos.method_33099(pos.method_10260() & 0xF);
        int maxY = chunk.method_12005(class_2902.class_2903.field_13202, pos.method_10263(), pos.method_10260()) + 3;
        if (maxY < 1) {
            pos.method_10100(chunk.method_12004().method_8326(), 2, chunk.method_12004().method_8328()).method_33098(130);
            return;
        }
        pos.method_33098(maxY);
        class_2680 state = level.method_8320((class_2338)pos);
        while (pos.method_10264() > 0 && (state.method_26215() || state.method_26207().method_15800() || state.method_26207().equals(class_3614.field_15935))) {
            pos.method_33098(pos.method_10264() - 1);
            state = chunk.method_8320((class_2338)pos);
        }
        if (pos.method_10264() < 1) {
            pos.method_33098(128);
        }
        pos.method_10100(chunk.method_12004().method_8326(), 2, chunk.method_12004().method_8328());
    }
}

