/*
 * Decompiled with CFR 0.152.
 */
package com.teamremastered.endrem.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.fabricmc.loader.api.FabricLoader;

public class ERConfigHandler {
    private static Path configFilePath;
    private static Gson gson;
    public static boolean ENABLE_EYE_OF_ENDER;
    public static int EYE_BREAK_PROBABILITY;

    public static void load() {
        if (ERConfigHandler.getFilePath().toFile().exists()) {
            try {
                BufferedReader reader = Files.newBufferedReader(ERConfigHandler.getFilePath());
                Data data = (Data)gson.fromJson((Reader)reader, Data.class);
                ENABLE_EYE_OF_ENDER = data.common.ENABLE_EYE_OF_ENDER;
                EYE_BREAK_PROBABILITY = data.common.EYE_BREAK_PROBABILITY;
                ((Reader)reader).close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        ERConfigHandler.save();
    }

    public static void save() {
        try {
            BufferedWriter writer = Files.newBufferedWriter(ERConfigHandler.getFilePath(), new OpenOption[0]);
            Data data = new Data(new Data.Common(ENABLE_EYE_OF_ENDER, EYE_BREAK_PROBABILITY));
            gson.toJson((Object)data, (Appendable)writer);
            ((Writer)writer).close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static Path getFilePath() {
        if (configFilePath == null) {
            configFilePath = FabricLoader.getInstance().getConfigDir().resolve("endrem.json");
        }
        return configFilePath;
    }

    static {
        gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        ENABLE_EYE_OF_ENDER = false;
        EYE_BREAK_PROBABILITY = 10;
    }

    private static class Data {
        private Common common;

        public Data(Common common) {
            this.common = common;
        }

        private static class Common {
            private final String enableEyeOfEnderComment = "Enable/Disable usage of Ender Eyes";
            private final boolean ENABLE_EYE_OF_ENDER;
            private final String eyeBreakProbabilityComment = "Percentage chance of eyes breaking when thrown";
            private final int EYE_BREAK_PROBABILITY;

            private Common() {
                this.ENABLE_EYE_OF_ENDER = false;
                this.EYE_BREAK_PROBABILITY = 10;
            }

            private Common(boolean ENABLE_EYE_OF_ENDER, int EYE_BREAK_PROBABILITY) {
                this.ENABLE_EYE_OF_ENDER = ENABLE_EYE_OF_ENDER;
                this.EYE_BREAK_PROBABILITY = EYE_BREAK_PROBABILITY;
            }
        }
    }
}

