/*
 * Decompiled with CFR 0.152.
 */
package ru.bclib.world.structures;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2893;
import net.minecraft.class_2960;
import net.minecraft.class_3037;
import net.minecraft.class_3111;
import net.minecraft.class_3195;
import net.minecraft.class_5312;
import net.minecraft.class_5321;
import net.minecraft.class_5742;
import net.minecraft.class_6834;
import net.minecraft.class_6862;
import net.minecraft.class_6872;
import net.minecraft.class_6873;
import net.minecraft.class_6874;
import net.minecraft.class_6880;
import net.minecraft.class_7059;
import net.minecraft.class_7072;
import ru.bclib.api.tag.TagAPI;
import ru.bclib.mixin.common.StructureFeatureAccessor;
import ru.bclib.mixin.common.StructureFeaturesAccessor;

public class BCLStructureFeature {
    private static final Random RANDOM = new Random(354L);
    private final class_3195<class_3111> structure;
    private final class_6880<class_5312<?, ?>> featureConfigured;
    private final class_2893.class_2895 featureStep;
    private final List<class_2960> biomes = Lists.newArrayList();
    private final class_2960 id;
    public final class_6862<class_1959> biomeTag;
    public final class_5321<class_5312<?, ?>> structureKey;
    public final class_5321<class_7059> structureSetKey;
    public final class_6872 spreadConfig;

    public BCLStructureFeature(class_2960 id, class_3195<class_3111> structure, class_2893.class_2895 step, int spacing, int separation) {
        this(id, structure, step, spacing, separation, false);
    }

    public BCLStructureFeature(class_2960 id, class_3195<class_3111> structure, class_2893.class_2895 step, int spacing, int separation, boolean adaptNoise) {
        this.id = id;
        this.featureStep = step;
        this.spreadConfig = new class_6872(spacing, separation, class_6873.field_36421, RANDOM.nextInt(8192));
        this.structureKey = class_5321.method_29179((class_5321)class_2378.field_25915, (class_2960)id);
        this.structureSetKey = class_5321.method_29179((class_5321)class_2378.field_37227, (class_2960)id);
        this.biomeTag = TagAPI.makeBiomeTag(id.method_12836(), "has_structure/" + id.method_12832());
        this.structure = StructureFeatureAccessor.callRegister(id.toString(), structure, step);
        this.featureConfigured = StructureFeaturesAccessor.callRegister(this.structureKey, this.structure.method_41134((class_3037)class_3111.field_13603, this.biomeTag, adaptNoise));
        class_7072.method_41184(this.structureSetKey, this.featureConfigured, (class_6874)this.spreadConfig);
    }

    public static <C extends class_3037> boolean isValidBiome(class_6834.class_6835<C> context) {
        return BCLStructureFeature.isValidBiome(context, 5);
    }

    public static <C extends class_3037> boolean isValidBiome(class_6834.class_6835<C> context, int yPos) {
        class_2338 blockPos = context.comp_309().method_33943(yPos);
        return context.comp_312().test(context.comp_306().method_16359(class_5742.method_33100((int)blockPos.method_10263()), class_5742.method_33100((int)blockPos.method_10264()), class_5742.method_33100((int)blockPos.method_10260())));
    }

    public class_3195<class_3111> getStructure() {
        return this.structure;
    }

    public class_6880<class_5312<?, ?>> getFeatureConfigured() {
        return this.featureConfigured;
    }

    public class_2893.class_2895 getFeatureStep() {
        return this.featureStep;
    }

    public class_2960 getID() {
        return this.id;
    }

    public void addInternalBiome(class_2960 biome) {
        this.biomes.add(biome);
    }

    public List<class_2960> getBiomes() {
        return this.biomes;
    }
}

