/*
 * Decompiled with CFR 0.152.
 */
package ru.bclib.world.generator.map.hex;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Random;
import net.minecraft.class_1923;
import ru.bclib.interfaces.BiomeChunk;
import ru.bclib.interfaces.BiomeMap;
import ru.bclib.interfaces.TriConsumer;
import ru.bclib.noise.OpenSimplexNoise;
import ru.bclib.util.MHelper;
import ru.bclib.world.biomes.BCLBiome;
import ru.bclib.world.generator.BiomePicker;
import ru.bclib.world.generator.map.hex.HexBiomeChunk;

public class HexBiomeMap
implements BiomeMap {
    private static final float RAD_INNER = (float)Math.sqrt(3.0) * 0.5f;
    private static final float COEF = 0.25f * (float)Math.sqrt(3.0);
    private static final float COEF_HALF = COEF * 0.5f;
    private static final float SIN = (float)Math.sin(0.4);
    private static final float COS = (float)Math.cos(0.4);
    private static final float[] EDGE_CIRCLE_X = new float[8];
    private static final float[] EDGE_CIRCLE_Z = new float[8];
    private final Map<class_1923, HexBiomeChunk> chunks = Maps.newConcurrentMap();
    private final BiomePicker picker;
    private final OpenSimplexNoise[] noises = new OpenSimplexNoise[2];
    private TriConsumer<Integer, Integer, Integer> processor;
    private final byte noiseIterations;
    private final float scale;
    private final int seed;

    public HexBiomeMap(long seed, int size, BiomePicker picker) {
        this.picker = picker;
        this.scale = HexBiomeChunk.scaleMap(size);
        Random random = new Random(seed);
        this.noises[0] = new OpenSimplexNoise(random.nextInt());
        this.noises[1] = new OpenSimplexNoise(random.nextInt());
        this.noiseIterations = (byte)Math.min(Math.ceil(Math.log(this.scale) / Math.log(2.0)), 5.0);
        this.seed = random.nextInt();
    }

    @Override
    public void clearCache() {
        if (this.chunks.size() > 127) {
            this.chunks.clear();
        }
    }

    @Override
    public BCLBiome getBiome(double x, double y, double z) {
        BCLBiome biome = this.getRawBiome(x, z);
        BCLBiome edge = biome.getEdge();
        int size = biome.getEdgeSize();
        if (edge == null && biome.getParentBiome() != null) {
            edge = biome.getParentBiome().getEdge();
            size = biome.getParentBiome().getEdgeSize();
        }
        if (edge == null) {
            return biome;
        }
        for (int i = 0; i < 8; i = (int)((byte)(i + 1))) {
            if (this.getRawBiome(x + (double)((float)size * EDGE_CIRCLE_X[i]), z + (double)((float)size * EDGE_CIRCLE_Z[i])).isSame(biome)) continue;
            return edge;
        }
        return biome;
    }

    @Override
    public BiomeChunk getChunk(int cx, int cz, boolean update) {
        class_1923 pos = new class_1923(cx, cz);
        HexBiomeChunk chunk = this.chunks.get(pos);
        if (chunk == null) {
            Random random = new Random(MHelper.getSeed(this.seed, cx, cz));
            chunk = new HexBiomeChunk(random, this.picker);
            if (update && this.processor != null) {
                this.processor.accept(cx, cz, chunk.getSide());
            }
            this.chunks.put(pos, chunk);
        }
        return chunk;
    }

    @Override
    public void setChunkProcessor(TriConsumer<Integer, Integer, Integer> processor) {
        this.processor = processor;
    }

    private BCLBiome getRawBiome(double x, double z) {
        boolean offset;
        double px = x / (double)this.scale * (double)RAD_INNER;
        double pz = z / (double)this.scale;
        double dx = this.rotateX(px, pz);
        double dz = this.rotateZ(px, pz);
        px = dx;
        pz = dz;
        dx = this.getNoise(px, pz, (byte)0) * (double)0.2f;
        dz = this.getNoise(pz, px, (byte)1) * (double)0.2f;
        px += dx;
        int cellZ = (int)Math.floor(pz += dz);
        boolean bl = offset = (cellZ & 1) == 1;
        if (offset) {
            px += 0.5;
        }
        int cellX = (int)Math.floor(px);
        float pointX = (float)(px - (double)cellX - 0.5);
        float pointZ = (float)(pz - (double)cellZ - 0.5);
        if (Math.abs(pointZ) < 0.3333f) {
            return this.getChunkBiome(cellX, cellZ);
        }
        if (this.insideHexagon(0.0f, 0.0f, 1.1555f, pointZ * RAD_INNER, pointX)) {
            return this.getChunkBiome(cellX, cellZ);
        }
        cellX = pointX < 0.0f ? (offset ? cellX - 1 : cellX) : (offset ? cellX : cellX + 1);
        cellZ = pointZ < 0.0f ? cellZ - 1 : cellZ + 1;
        return this.getChunkBiome(cellX, cellZ);
    }

    private BCLBiome getChunkBiome(int x, int z) {
        int cx = HexBiomeChunk.scaleCoordinate(x);
        int cz = HexBiomeChunk.scaleCoordinate(z);
        if ((z >> 2 & 1) == 0 && HexBiomeChunk.isBorder(x)) {
            x = 0;
            ++cx;
        } else if ((x >> 2 & 1) == 0 && HexBiomeChunk.isBorder(z)) {
            z = 0;
            ++cz;
        }
        return this.getChunk(cx, cz, true).getBiome(x, z);
    }

    private boolean insideHexagon(float centerX, float centerZ, float radius, float x, float z) {
        double dx = Math.abs(x - centerX) / radius;
        double dy = Math.abs(z - centerZ) / radius;
        return dy <= (double)COEF && (double)COEF * dx + 0.25 * dy <= (double)COEF_HALF;
    }

    private double getNoise(double x, double z, byte state) {
        double result = 0.0;
        for (byte i = 1; i <= this.noiseIterations; i = (byte)(i + 1)) {
            OpenSimplexNoise noise = this.noises[state];
            state = (byte)(state + 1 & 1);
            result += noise.eval(x * (double)i, z * (double)i) / (double)i;
        }
        return result;
    }

    private double rotateX(double x, double z) {
        return x * (double)COS - z * (double)SIN;
    }

    private double rotateZ(double x, double z) {
        return x * (double)SIN + z * (double)COS;
    }

    static {
        for (int i = 0; i < 8; i = (int)((byte)(i + 1))) {
            float angle = (float)i / 4.0f * (float)Math.PI;
            HexBiomeMap.EDGE_CIRCLE_X[i] = (float)Math.sin(angle);
            HexBiomeMap.EDGE_CIRCLE_Z[i] = (float)Math.cos(angle);
        }
    }
}

