/*
 * Decompiled with CFR 0.152.
 */
package ru.bclib.world.generator;

import java.awt.Point;
import java.util.function.Function;
import net.minecraft.class_3532;
import ru.bclib.config.Configs;

public class GeneratorOptions {
    private static int biomeSizeNether;
    private static int biomeVSizeNether;
    private static int biomeSizeEndLand;
    private static int biomeSizeEndVoid;
    private static Function<Point, Boolean> endLandFunction;
    private static boolean customNetherBiomeSource;
    private static boolean customEndBiomeSource;
    private static boolean addNetherBiomesByCategory;
    private static boolean addEndBiomesByCategory;
    private static boolean useOldBiomeGenerator;
    private static boolean verticalBiomes;
    private static long farEndBiomesSqr;
    private static boolean fixEndBiomeSource;
    private static boolean fixNetherBiomeSource;

    public static void init() {
        biomeSizeNether = Configs.GENERATOR_CONFIG.getInt("nether.biomeMap", "biomeSize", 256);
        biomeVSizeNether = Configs.GENERATOR_CONFIG.getInt("nether.biomeMap", "biomeVerticalSize(onlyInTallNether)", 86);
        biomeSizeEndLand = Configs.GENERATOR_CONFIG.getInt("end.biomeMap", "biomeSizeLand", 256);
        biomeSizeEndVoid = Configs.GENERATOR_CONFIG.getInt("end.biomeMap", "biomeSizeVoid", 256);
        customNetherBiomeSource = Configs.GENERATOR_CONFIG.getBoolean("options", "customNetherBiomeSource", true);
        customEndBiomeSource = Configs.GENERATOR_CONFIG.getBoolean("options", "customEndBiomeSource", true);
        addNetherBiomesByCategory = Configs.GENERATOR_CONFIG.getBoolean("options", "addNetherBiomesByCategory", false);
        addEndBiomesByCategory = Configs.GENERATOR_CONFIG.getBoolean("options", "addEndBiomesByCategory", false);
        useOldBiomeGenerator = Configs.GENERATOR_CONFIG.useOldGenerator();
        verticalBiomes = Configs.GENERATOR_CONFIG.getBoolean("options", "verticalBiomesInTallNether", true);
        fixEndBiomeSource = Configs.GENERATOR_CONFIG.getBoolean("options.biomeSource", "fixEndBiomeSource", true);
        fixNetherBiomeSource = Configs.GENERATOR_CONFIG.getBoolean("options.biomeSource", "fixNetherBiomeSource", true);
    }

    public static int getBiomeSizeNether() {
        return class_3532.method_15340((int)biomeSizeNether, (int)1, (int)8192);
    }

    public static int getVerticalBiomeSizeNether() {
        return class_3532.method_15340((int)biomeVSizeNether, (int)1, (int)8192);
    }

    public static int getBiomeSizeEndLand() {
        return class_3532.method_15340((int)biomeSizeEndLand, (int)1, (int)8192);
    }

    public static int getBiomeSizeEndVoid() {
        return class_3532.method_15340((int)biomeSizeEndVoid, (int)1, (int)8192);
    }

    public static void setEndLandFunction(Function<Point, Boolean> endLandFunction) {
        GeneratorOptions.endLandFunction = endLandFunction;
    }

    public static Function<Point, Boolean> getEndLandFunction() {
        return endLandFunction;
    }

    public static long getFarEndBiomes() {
        return farEndBiomesSqr;
    }

    public static void setFarEndBiomes(int distance) {
        farEndBiomesSqr = (long)distance * (long)distance;
    }

    public static void setFarEndBiomesSqr(long distanceSqr) {
        farEndBiomesSqr = distanceSqr;
    }

    public static boolean customNetherBiomeSource() {
        return customNetherBiomeSource;
    }

    public static boolean customEndBiomeSource() {
        return customEndBiomeSource;
    }

    public static boolean addNetherBiomesByCategory() {
        return addNetherBiomesByCategory;
    }

    public static boolean addEndBiomesByCategory() {
        return addEndBiomesByCategory;
    }

    public static boolean useOldBiomeGenerator() {
        return useOldBiomeGenerator;
    }

    public static boolean useVerticalBiomes() {
        return verticalBiomes;
    }

    public static boolean fixEndBiomeSource() {
        return fixEndBiomeSource;
    }

    public static boolean fixNetherBiomeSource() {
        return fixNetherBiomeSource;
    }

    static {
        customNetherBiomeSource = true;
        customEndBiomeSource = true;
        addNetherBiomesByCategory = false;
        addEndBiomesByCategory = false;
        useOldBiomeGenerator = false;
        verticalBiomes = true;
        farEndBiomesSqr = 1000000L;
        fixEndBiomeSource = true;
        fixNetherBiomeSource = true;
    }
}

