/*
 * Decompiled with CFR 0.152.
 */
package ru.bclib.world.generator;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.class_2960;
import ru.bclib.util.WeighTree;
import ru.bclib.util.WeightedList;
import ru.bclib.world.biomes.BCLBiome;

public class BiomePicker {
    private final Set<class_2960> immutableIDs = Sets.newHashSet();
    private final List<BCLBiome> biomes = Lists.newArrayList();
    private WeighTree<BCLBiome> tree;
    private int biomeCount = 0;

    public void addBiome(BCLBiome biome) {
        if (this.immutableIDs.contains(biome.getID())) {
            return;
        }
        this.immutableIDs.add(biome.getID());
        this.biomes.add(biome);
        ++this.biomeCount;
    }

    public void addBiomeMutable(BCLBiome biome) {
        if (this.immutableIDs.contains(biome.getID())) {
            return;
        }
        this.biomes.add(biome);
    }

    public void clearMutables() {
        for (int i = this.biomes.size() - 1; i >= this.biomeCount; --i) {
            this.biomes.remove(i);
        }
    }

    public BCLBiome getBiome(Random random) {
        return this.biomes.isEmpty() ? null : this.tree.get(random);
    }

    public List<BCLBiome> getBiomes() {
        return this.biomes;
    }

    public boolean containsImmutable(class_2960 id) {
        return this.immutableIDs.contains(id);
    }

    public void removeMutableBiome(class_2960 id) {
        for (int i = this.biomeCount; i < this.biomes.size(); ++i) {
            BCLBiome biome = this.biomes.get(i);
            if (!biome.getID().equals((Object)id)) continue;
            this.biomes.remove(i);
            break;
        }
    }

    public void rebuild() {
        if (this.biomes.isEmpty()) {
            return;
        }
        WeightedList list = new WeightedList();
        this.biomes.forEach(biome -> list.add(biome, biome.getGenChance()));
        this.tree = new WeighTree(list);
    }
}

