/*
 * Decompiled with CFR 0.152.
 */
package ru.bclib.world.generator;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6544;
import net.minecraft.class_6880;
import net.minecraft.class_6903;
import org.apache.commons.lang3.function.TriFunction;
import ru.bclib.BCLib;
import ru.bclib.api.biomes.BiomeAPI;
import ru.bclib.config.ConfigKeeper;
import ru.bclib.config.Configs;
import ru.bclib.interfaces.BiomeMap;
import ru.bclib.mixin.common.BiomeAccessor;
import ru.bclib.world.biomes.BCLBiome;
import ru.bclib.world.generator.BCLBiomeSource;
import ru.bclib.world.generator.BiomePicker;
import ru.bclib.world.generator.GeneratorOptions;
import ru.bclib.world.generator.map.MapStack;
import ru.bclib.world.generator.map.hex.HexBiomeMap;
import ru.bclib.world.generator.map.square.SquareBiomeMap;

public class BCLibNetherBiomeSource
extends BCLBiomeSource {
    public static final Codec<BCLibNetherBiomeSource> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_6903.method_40419((class_5321)class_2378.field_25114).forGetter(source -> source.biomeRegistry), (App)Codec.LONG.fieldOf("seed").stable().forGetter(source -> source.seed)).apply((Applicative)instance, instance.stable(BCLibNetherBiomeSource::new)));
    private BiomeMap biomeMap;
    private static boolean forceLegacyGenerator = false;
    private static int lastWorldHeight;
    private static int worldHeight;

    public static void setForceLegacyGeneration(boolean val) {
        forceLegacyGenerator = val;
    }

    public static void setWorldHeight(int worldHeight) {
        BCLibNetherBiomeSource.worldHeight = worldHeight;
    }

    public BCLibNetherBiomeSource(class_2378<class_1959> biomeRegistry, long seed) {
        super(biomeRegistry, seed, BCLibNetherBiomeSource.getBiomes(biomeRegistry));
        BiomeAPI.NETHER_BIOME_PICKER.clearMutables();
        this.method_28443().forEach(biome -> {
            class_2960 key = ((class_5321)biome.method_40230().orElseThrow()).method_29177();
            if (!BiomeAPI.hasBiome(key)) {
                BCLBiome bclBiome = new BCLBiome(key, (class_1959)biome.comp_349());
                BiomeAPI.NETHER_BIOME_PICKER.addBiomeMutable(bclBiome);
            } else {
                BCLBiome bclBiome = BiomeAPI.getBiome(key);
                if (bclBiome != BiomeAPI.EMPTY_BIOME && bclBiome.getParentBiome() == null && !BiomeAPI.NETHER_BIOME_PICKER.containsImmutable(key)) {
                    BiomeAPI.NETHER_BIOME_PICKER.addBiomeMutable(bclBiome);
                }
            }
        });
        BiomeAPI.NETHER_BIOME_PICKER.getBiomes().forEach(biome -> biome.updateActualBiomes(biomeRegistry));
        BiomeAPI.NETHER_BIOME_PICKER.rebuild();
        this.initMap();
    }

    private static List<class_6880<class_1959>> getBiomes(class_2378<class_1959> biomeRegistry) {
        List include = (List)Configs.BIOMES_CONFIG.getEntry("force_include", "nether_biomes", ConfigKeeper.StringArrayEntry.class).getValue();
        return biomeRegistry.method_10220().filter(biome -> biomeRegistry.method_29113(biome).isPresent()).map(biome -> biomeRegistry.method_40268((class_5321)biomeRegistry.method_29113(biome).get())).filter(biome -> {
            BiomeAccessor bacc;
            class_6880 patt4288$temp;
            class_2960 key = ((class_5321)biome.method_40230().orElseThrow()).method_29177();
            if (include.contains(key.toString())) {
                return true;
            }
            if (GeneratorOptions.addNetherBiomesByCategory() && biome instanceof BiomeAccessor && ((BiomeAccessor)biome).bclib_getBiomeCategory() == class_1959.class_1961.field_9366) {
                return true;
            }
            BCLBiome bclBiome = BiomeAPI.getBiome(key);
            if (bclBiome != BiomeAPI.EMPTY_BIOME) {
                if (bclBiome.getParentBiome() != null) {
                    bclBiome = bclBiome.getParentBiome();
                }
                key = bclBiome.getID();
            }
            boolean isNetherBiome = (patt4288$temp = biome) instanceof BiomeAccessor ? (bacc = (BiomeAccessor)patt4288$temp).bclib_getBiomeCategory() == class_1959.class_1961.field_9366 : false;
            return BiomeAPI.NETHER_BIOME_PICKER.containsImmutable(key) || isNetherBiome && BiomeAPI.isDatapackBiome(key);
        }).toList();
    }

    public class_6880<class_1959> method_38109(int biomeX, int biomeY, int biomeZ, class_6544.class_6552 var4) {
        if (lastWorldHeight != worldHeight) {
            lastWorldHeight = worldHeight;
            this.initMap();
        }
        if ((biomeX & 0x3F) == 0 && (biomeZ & 0x3F) == 0) {
            this.biomeMap.clearCache();
        }
        return this.biomeMap.getBiome(biomeX << 2, biomeY << 2, biomeZ << 2).getActualBiome();
    }

    public class_1966 method_27985(long seed) {
        return new BCLibNetherBiomeSource((class_2378<class_1959>)this.biomeRegistry, seed);
    }

    protected Codec<? extends class_1966> method_28442() {
        return CODEC;
    }

    public static void register() {
        class_2378.method_10230((class_2378)class_2378.field_25096, (class_2960)BCLib.makeID("nether_biome_source"), CODEC);
    }

    private void initMap() {
        boolean useLegacy = GeneratorOptions.useOldBiomeGenerator() || forceLegacyGenerator;
        TriFunction mapConstructor = useLegacy ? SquareBiomeMap::new : HexBiomeMap::new;
        this.biomeMap = worldHeight > 128 && GeneratorOptions.useVerticalBiomes() ? new MapStack(this.seed, GeneratorOptions.getBiomeSizeNether(), BiomeAPI.NETHER_BIOME_PICKER, GeneratorOptions.getVerticalBiomeSizeNether(), worldHeight, (TriFunction<Long, Integer, BiomePicker, BiomeMap>)mapConstructor) : (BiomeMap)mapConstructor.apply((Object)this.seed, (Object)GeneratorOptions.getBiomeSizeNether(), (Object)BiomeAPI.NETHER_BIOME_PICKER);
    }

    public String toString() {
        return "BCLib - Nether BiomeSource";
    }
}

