/*
 * Decompiled with CFR 0.152.
 */
package ru.bclib.world.generator;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.awt.Point;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_1972;
import net.minecraft.class_2169;
import net.minecraft.class_2378;
import net.minecraft.class_2919;
import net.minecraft.class_2960;
import net.minecraft.class_3541;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_5820;
import net.minecraft.class_6544;
import net.minecraft.class_6880;
import net.minecraft.class_6903;
import ru.bclib.BCLib;
import ru.bclib.api.biomes.BiomeAPI;
import ru.bclib.config.ConfigKeeper;
import ru.bclib.config.Configs;
import ru.bclib.interfaces.BiomeMap;
import ru.bclib.mixin.common.BiomeAccessor;
import ru.bclib.noise.OpenSimplexNoise;
import ru.bclib.world.biomes.BCLBiome;
import ru.bclib.world.generator.BCLBiomeSource;
import ru.bclib.world.generator.GeneratorOptions;
import ru.bclib.world.generator.map.hex.HexBiomeMap;
import ru.bclib.world.generator.map.square.SquareBiomeMap;

public class BCLibEndBiomeSource
extends BCLBiomeSource {
    public static Codec<BCLibEndBiomeSource> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_6903.method_40419((class_5321)class_2378.field_25114).forGetter(theEndBiomeSource -> null), (App)Codec.LONG.fieldOf("seed").stable().forGetter(theEndBiomeSource -> theEndBiomeSource.seed)).apply((Applicative)instance, instance.stable(BCLibEndBiomeSource::new)));
    private static final OpenSimplexNoise SMALL_NOISE = new OpenSimplexNoise(8324L);
    private Function<Point, Boolean> endLandFunction;
    private final class_3541 noise;
    private final class_6880<class_1959> centerBiome;
    private final class_6880<class_1959> barrens;
    private BiomeMap mapLand;
    private BiomeMap mapVoid;
    private final Point pos;

    public BCLibEndBiomeSource(class_2378<class_1959> biomeRegistry, long seed) {
        super(biomeRegistry, seed, BCLibEndBiomeSource.getBiomes(biomeRegistry));
        BiomeAPI.END_LAND_BIOME_PICKER.clearMutables();
        BiomeAPI.END_VOID_BIOME_PICKER.clearMutables();
        List includeVoid = (List)Configs.BIOMES_CONFIG.getEntry("force_include", "end_void_biomes", ConfigKeeper.StringArrayEntry.class).getValue();
        this.method_28443().forEach(biome -> {
            class_2960 key = ((class_5321)biome.method_40230().orElseThrow()).method_29177();
            String group = key.method_12836() + "." + key.method_12832();
            if (!BiomeAPI.hasBiome(key)) {
                BCLBiome bclBiome = new BCLBiome(key, (class_1959)biome.comp_349());
                if (includeVoid.contains(key.toString())) {
                    BiomeAPI.END_VOID_BIOME_PICKER.addBiomeMutable(bclBiome);
                } else {
                    BiomeAPI.END_LAND_BIOME_PICKER.addBiomeMutable(bclBiome);
                }
            } else {
                BCLBiome bclBiome = BiomeAPI.getBiome(key);
                if (bclBiome != BiomeAPI.EMPTY_BIOME && bclBiome.getParentBiome() == null && !BiomeAPI.END_LAND_BIOME_PICKER.containsImmutable(key) && !BiomeAPI.END_VOID_BIOME_PICKER.containsImmutable(key)) {
                    if (includeVoid.contains(key.toString())) {
                        BiomeAPI.END_VOID_BIOME_PICKER.addBiomeMutable(bclBiome);
                    } else {
                        BiomeAPI.END_LAND_BIOME_PICKER.addBiomeMutable(bclBiome);
                    }
                }
            }
        });
        BiomeAPI.END_LAND_BIOME_PICKER.getBiomes().forEach(biome -> biome.updateActualBiomes(biomeRegistry));
        BiomeAPI.END_VOID_BIOME_PICKER.getBiomes().forEach(biome -> biome.updateActualBiomes(biomeRegistry));
        BiomeAPI.END_LAND_BIOME_PICKER.rebuild();
        BiomeAPI.END_VOID_BIOME_PICKER.rebuild();
        if (GeneratorOptions.useOldBiomeGenerator()) {
            this.mapLand = new SquareBiomeMap(seed, GeneratorOptions.getBiomeSizeEndLand(), BiomeAPI.END_LAND_BIOME_PICKER);
            this.mapVoid = new SquareBiomeMap(seed, GeneratorOptions.getBiomeSizeEndVoid(), BiomeAPI.END_VOID_BIOME_PICKER);
        } else {
            this.mapLand = new HexBiomeMap(seed, GeneratorOptions.getBiomeSizeEndLand(), BiomeAPI.END_LAND_BIOME_PICKER);
            this.mapVoid = new HexBiomeMap(seed, GeneratorOptions.getBiomeSizeEndVoid(), BiomeAPI.END_VOID_BIOME_PICKER);
        }
        this.centerBiome = biomeRegistry.method_40268(class_1972.field_9411);
        this.barrens = biomeRegistry.method_40268(class_1972.field_9465);
        class_2919 chunkRandom = new class_2919((class_5819)new class_5820(seed));
        chunkRandom.method_33650(17292);
        this.noise = new class_3541((class_5819)chunkRandom);
        this.endLandFunction = GeneratorOptions.getEndLandFunction();
        this.pos = new Point();
    }

    private static List<class_6880<class_1959>> getBiomes(class_2378<class_1959> biomeRegistry) {
        List includeLand = (List)Configs.BIOMES_CONFIG.getEntry("force_include", "end_land_biomes", ConfigKeeper.StringArrayEntry.class).getValue();
        List includeVoid = (List)Configs.BIOMES_CONFIG.getEntry("force_include", "end_void_biomes", ConfigKeeper.StringArrayEntry.class).getValue();
        return biomeRegistry.method_10220().filter(biome -> biomeRegistry.method_29113(biome).isPresent()).map(biome -> biomeRegistry.method_40268((class_5321)biomeRegistry.method_29113(biome).get())).filter(biome -> {
            BCLBiome bclBiome;
            boolean isEndBiome;
            class_2960 key = ((class_5321)biome.method_40230().orElseThrow()).method_29177();
            if (includeLand.contains(key.toString()) || includeVoid.contains(key.toString())) {
                return true;
            }
            class_6880 patt5436$temp = biome;
            if (patt5436$temp instanceof BiomeAccessor) {
                BiomeAccessor bacc = (BiomeAccessor)patt5436$temp;
                boolean bl = isEndBiome = bacc.bclib_getBiomeCategory() == class_1959.class_1961.field_9360;
                if (GeneratorOptions.addEndBiomesByCategory() && isEndBiome) {
                    return true;
                }
            } else {
                isEndBiome = false;
            }
            if ((bclBiome = BiomeAPI.getBiome(key)) != BiomeAPI.EMPTY_BIOME) {
                if (bclBiome.getParentBiome() != null) {
                    bclBiome = bclBiome.getParentBiome();
                }
                key = bclBiome.getID();
            }
            return BiomeAPI.END_LAND_BIOME_PICKER.containsImmutable(key) || BiomeAPI.END_VOID_BIOME_PICKER.containsImmutable(key) || isEndBiome && BiomeAPI.isDatapackBiome(key);
        }).toList();
    }

    public class_6880<class_1959> method_38109(int biomeX, int biomeY, int biomeZ, class_6544.class_6552 sampler) {
        long posX = biomeX << 2;
        long posZ = biomeZ << 2;
        long farEndBiomes = GeneratorOptions.getFarEndBiomes();
        long dist = posX * posX + posZ * posZ;
        if ((biomeX & 0x3F) == 0 && (biomeZ & 0x3F) == 0) {
            this.mapLand.clearCache();
            this.mapVoid.clearCache();
        }
        if (this.endLandFunction == null) {
            if (dist <= farEndBiomes) {
                return this.centerBiome;
            }
            float height = class_2169.method_8757((class_3541)this.noise, (int)((biomeX >> 1) + 1), (int)((biomeZ >> 1) + 1)) + (float)SMALL_NOISE.eval(biomeX, biomeZ) * 5.0f;
            if (height > -20.0f && height < -5.0f) {
                return this.barrens;
            }
            if (height < -10.0f) {
                return this.mapVoid.getBiome(posX, biomeY << 2, posZ).getActualBiome();
            }
            return this.mapLand.getBiome(posX, biomeY << 2, posZ).getActualBiome();
        }
        this.pos.setLocation(biomeX, biomeZ);
        if (this.endLandFunction.apply(this.pos).booleanValue()) {
            return dist <= farEndBiomes ? this.centerBiome : this.mapLand.getBiome(posX, biomeY << 2, posZ).getActualBiome();
        }
        return dist <= farEndBiomes ? this.barrens : this.mapVoid.getBiome(posX, biomeY << 2, posZ).getActualBiome();
    }

    public class_1966 method_27985(long seed) {
        return new BCLibEndBiomeSource((class_2378<class_1959>)this.biomeRegistry, seed);
    }

    protected Codec<? extends class_1966> method_28442() {
        return CODEC;
    }

    public static void register() {
        class_2378.method_10230((class_2378)class_2378.field_25096, (class_2960)BCLib.makeID("end_biome_source"), CODEC);
    }

    public String toString() {
        return "BCLib - The End BiomeSource";
    }
}

