/*
 * Decompiled with CFR 0.152.
 */
package ru.bclib.world.biomes;

import ru.bclib.config.Configs;
import ru.bclib.world.biomes.BCLBiome;
import ru.bclib.world.biomes.VanillaBiomeSettings;

public class BCLBiomeSettings {
    float terrainHeight = 0.1f;
    float fogDensity = 1.0f;
    float genChance = 1.0f;
    int edgeSize = 0;
    boolean vertical = false;
    BCLBiome edge = null;

    protected BCLBiomeSettings() {
    }

    public static Builder createBCL() {
        return new Builder();
    }

    public float getGenChance() {
        return this.genChance;
    }

    public boolean isVertical() {
        return this.vertical;
    }

    public float getTerrainHeight() {
        return this.terrainHeight;
    }

    public float getFogDensity() {
        return this.fogDensity;
    }

    public int getEdgeSize() {
        return this.edgeSize;
    }

    public BCLBiome getEdge() {
        return this.edge;
    }

    public void applyWithDefaults(BCLBiome biome) {
        String group = biome.configGroup();
        biome.genChance = Configs.BIOMES_CONFIG.getFloat(group, "generation_chance", this.genChance);
        if (this.edge != null) {
            biome.edgeSize = Configs.BIOMES_CONFIG.getInt(group, "edge_size", this.edgeSize);
            if (this.edgeSize > 0) {
                biome.setEdge(this.edge);
            }
        }
        if (!(this instanceof VanillaBiomeSettings)) {
            biome.fogDensity = Configs.BIOMES_CONFIG.getFloat(group, "fog_density", this.fogDensity);
            biome.vertical = Configs.BIOMES_CONFIG.getBoolean(group, "vertical", this.vertical);
            biome.terrainHeight = Configs.BIOMES_CONFIG.getFloat(group, "terrain_height", this.terrainHeight);
        }
        Configs.BIOMES_CONFIG.saveChanges();
    }

    public static class Builder
    extends CommonBuilder<BCLBiomeSettings, Builder> {
        public Builder() {
            super(new BCLBiomeSettings());
        }
    }

    public static class CommonBuilder<T extends BCLBiomeSettings, R extends CommonBuilder> {
        private final T storage;

        CommonBuilder(T storage) {
            this.storage = storage;
        }

        public T build() {
            return this.storage;
        }

        public R setGenChance(float genChance) {
            ((BCLBiomeSettings)this.storage).genChance = genChance;
            return (R)this;
        }

        public R setTerrainHeight(float terrainHeight) {
            ((BCLBiomeSettings)this.storage).terrainHeight = terrainHeight;
            return (R)this;
        }

        public R setVertical() {
            return this.setVertical(true);
        }

        public R setVertical(boolean vertical) {
            ((BCLBiomeSettings)this.storage).vertical = vertical;
            return (R)this;
        }

        public R setEdgeSize(int size) {
            ((BCLBiomeSettings)this.storage).edgeSize = size;
            return (R)this;
        }

        public R setEdge(BCLBiome edge) {
            ((BCLBiomeSettings)this.storage).edge = edge;
            return (R)this;
        }

        public R setFogDensity(float fogDensity) {
            ((BCLBiomeSettings)this.storage).fogDensity = fogDensity;
            return (R)this;
        }
    }
}

