/*
 * Decompiled with CFR 0.152.
 */
package ru.bclib.world.biomes;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5458;
import net.minecraft.class_6686;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;
import ru.bclib.BCLib;
import ru.bclib.api.biomes.BiomeAPI;
import ru.bclib.api.tag.TagAPI;
import ru.bclib.util.WeightedList;
import ru.bclib.world.biomes.BCLBiomeSettings;
import ru.bclib.world.biomes.VanillaBiomeSettings;

public class BCLBiome
extends BCLBiomeSettings {
    private final Set<class_6862<class_1959>> structureTags = Sets.newHashSet();
    private final WeightedList<BCLBiome> subbiomes = new WeightedList();
    private final Map<String, Object> customData = Maps.newHashMap();
    private final class_2960 biomeID;
    private final class_1959 biome;
    private Consumer<class_6880<class_1959>> surfaceInit;
    private BCLBiome biomeParent;
    private class_6880<class_1959> actualBiome;
    private boolean didLoadConfig = false;

    public BCLBiome(class_5321<class_1959> biomeKey) {
        this(biomeKey.method_29177());
    }

    public BCLBiome(class_2960 biomeID) {
        this(biomeID, (class_1959)class_5458.field_25933.method_10223(biomeID), null);
    }

    public BCLBiome(class_1959 biome) {
        this(biome, null);
    }

    public BCLBiome(class_1959 biome, VanillaBiomeSettings settings) {
        this(BiomeAPI.getBiomeID(biome), biome, settings);
    }

    public BCLBiome(class_2960 biomeID, class_1959 biome) {
        this(biomeID, biome, null);
    }

    public BCLBiome(class_2960 biomeID, class_1959 biome, BCLBiomeSettings defaults) {
        this.subbiomes.add(this, 1.0f);
        this.biomeID = biomeID;
        this.biome = biome;
        if (defaults != null) {
            defaults.applyWithDefaults(this);
        }
    }

    @Override
    @Nullable
    public BCLBiome getEdge() {
        return this.edge;
    }

    BCLBiome setEdge(BCLBiome edge) {
        this.edge = edge;
        edge.biomeParent = this;
        return this;
    }

    public BCLBiome addSubBiome(BCLBiome biome) {
        biome.biomeParent = this;
        this.subbiomes.add(biome, biome.getGenChance());
        return this;
    }

    public boolean containsSubBiome(BCLBiome biome) {
        return this.subbiomes.contains(biome);
    }

    public BCLBiome getSubBiome(Random random) {
        return this.subbiomes.get(random);
    }

    @Nullable
    public BCLBiome getParentBiome() {
        return this.biomeParent;
    }

    public boolean isSame(BCLBiome biome) {
        return biome == this || biome.biomeParent != null && biome.biomeParent == this;
    }

    public class_2960 getID() {
        return this.biomeID;
    }

    public class_6880<class_1959> getBiomeHolder() {
        return class_5458.field_25933.method_40268(BiomeAPI.getBiomeKey(this.biome));
    }

    public class_1959 getBiome() {
        return this.biome;
    }

    public class_6880<class_1959> getActualBiome() {
        return this.actualBiome;
    }

    public void updateActualBiomes(class_2378<class_1959> biomeRegistry) {
        this.subbiomes.forEach(sub -> {
            if (sub != this) {
                sub.updateActualBiomes(biomeRegistry);
            }
        });
        if (this.edge != null && this.edge != this) {
            this.edge.updateActualBiomes(biomeRegistry);
        }
        class_5321 key = (class_5321)biomeRegistry.method_29113((Object)((class_1959)biomeRegistry.method_10223(this.biomeID))).orElseThrow();
        this.actualBiome = biomeRegistry.method_40268(key);
        if (this.actualBiome == null) {
            BCLib.LOGGER.error("Unable to find actual Biome for " + this.biomeID);
        }
        if (!this.structureTags.isEmpty()) {
            this.structureTags.forEach(tagKey -> TagAPI.addBiomeTag((class_6862<class_1959>)tagKey, (class_1959)this.actualBiome.comp_349()));
        }
        if (this.surfaceInit != null) {
            this.surfaceInit.accept(this.actualBiome);
        }
    }

    @Nullable
    public <T> T getCustomData(String name) {
        return (T)this.customData.get(name);
    }

    public <T> T getCustomData(String name, T defaultValue) {
        return (T)this.customData.getOrDefault(name, defaultValue);
    }

    public BCLBiome addCustomData(String name, Object obj) {
        this.customData.put(name, obj);
        return this;
    }

    public BCLBiome addCustomData(Map<String, Object> data) {
        this.customData.putAll(data);
        return this;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        BCLBiome biome = (BCLBiome)obj;
        return biome == null ? false : this.biomeID.equals((Object)biome.biomeID);
    }

    public int hashCode() {
        return this.biomeID.hashCode();
    }

    public String toString() {
        return this.biomeID.toString();
    }

    public void attachStructures(List<class_6862<class_1959>> structures) {
        this.structureTags.addAll(structures);
    }

    public void setSurface(class_6686.class_6708 surface) {
        this.surfaceInit = actualBiome -> {
            class_5321 key = BiomeAPI.getBiomeKey((class_6880<class_1959>)actualBiome);
            if (key == null) {
                BCLib.LOGGER.warning("BCL Biome " + this.biomeID + " does not have registry key!", new Object[0]);
            } else {
                BiomeAPI.addSurfaceRule(this.biomeID, class_6686.method_39049((class_6686.class_6693)class_6686.method_39055((class_5321[])new class_5321[]{key}), (class_6686.class_6708)surface));
            }
        };
    }

    public String configGroup() {
        return this.biomeID.method_12836() + "." + this.biomeID.method_12832();
    }
}

