/*
 * Decompiled with CFR 0.152.
 */
package ru.bclib.util;

import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashSet;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5458;

public class TranslationHelper {
    public static void printMissingEnNames(String modID) {
        TranslationHelper.printMissingNames(modID, "en_us");
    }

    public static void printMissingNames(String modID, String languageCode) {
        HashSet missingNames = Sets.newHashSet();
        Gson gson = new Gson();
        InputStream inputStream = TranslationHelper.class.getResourceAsStream("/assets/" + modID + "/lang/" + languageCode + ".json");
        JsonObject translation = inputStream == null ? new JsonObject() : (JsonObject)gson.fromJson((Reader)new InputStreamReader(inputStream), JsonObject.class);
        class_2378.field_11146.forEach(block -> {
            String name;
            if (class_2378.field_11146.method_10221(block).method_12836().equals(modID) && !translation.has(name = block.method_9518().getString())) {
                missingNames.add(name);
            }
        });
        class_2378.field_11142.forEach(item -> {
            String name;
            if (class_2378.field_11142.method_10221(item).method_12836().equals(modID) && !translation.has(name = item.method_7848().getString())) {
                missingNames.add(name);
            }
        });
        class_5458.field_25933.forEach(biome -> {
            String name;
            class_2960 id = class_5458.field_25933.method_10221(biome);
            if (id.method_12836().equals(modID) && !translation.has(name = "biome." + modID + "." + id.method_12832())) {
                missingNames.add(name);
            }
        });
        class_2378.field_11145.forEach(entity -> {
            String name;
            class_2960 id = class_2378.field_11145.method_10221(entity);
            if (id.method_12836().equals(modID) && !translation.has(name = "entity." + modID + "." + id.method_12832())) {
                missingNames.add(name);
            }
        });
        if (!missingNames.isEmpty()) {
            System.out.println("========================================");
            System.out.println("\t\t   MISSING NAMES LIST");
            if (!missingNames.isEmpty()) {
                if (languageCode.equals("en_us")) {
                    System.out.println("========================================");
                    System.out.println("\t  AUTO ENGLISH BEAUTIFICATION");
                    System.out.println("========================================");
                    missingNames.stream().sorted().forEach(name -> System.out.println("\t\"" + name + "\": \"" + TranslationHelper.fastTranslateEn(name) + "\","));
                } else {
                    System.out.println("========================================");
                    System.out.println("\t\t   TEMPLATE: [" + languageCode + "]");
                    System.out.println("========================================");
                    missingNames.stream().sorted().forEach(name -> System.out.println("\t\"" + name + "\": \"\","));
                }
            }
            System.out.println("========================================");
        }
    }

    public static String fastTranslateEn(String text) {
        String[] words = text.substring(text.lastIndexOf(46) + 1).split("_");
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < words.length; ++i) {
            String word = words[i];
            builder.append(Character.toUpperCase(word.charAt(0)));
            builder.append(word, 1, word.length());
            if (i >= words.length - 1) continue;
            builder.append(' ');
        }
        return builder.toString();
    }
}

