/*
 * Decompiled with CFR 0.152.
 */
package ru.bclib.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import org.jetbrains.annotations.Nullable;
import ru.bclib.BCLib;

public class JsonFactory {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static JsonObject getJsonObject(InputStream stream) {
        try {
            InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);
            JsonElement json = JsonFactory.loadJson(reader);
            if (json != null && json.isJsonObject()) {
                JsonObject jsonObject = json.getAsJsonObject();
                return jsonObject != null ? jsonObject : new JsonObject();
            }
        }
        catch (Exception ex) {
            BCLib.LOGGER.catching(ex);
        }
        return new JsonObject();
    }

    public static JsonObject getJsonObject(File jsonFile) {
        JsonElement json;
        if (jsonFile.exists() && (json = JsonFactory.loadJson(jsonFile)) != null && json.isJsonObject()) {
            JsonObject jsonObject = json.getAsJsonObject();
            return jsonObject != null ? jsonObject : new JsonObject();
        }
        return new JsonObject();
    }

    @Nullable
    @Environment(value=EnvType.CLIENT)
    public static JsonObject getJsonObject(class_2960 location) {
        class_3300 manager = class_310.method_1551().method_1478();
        JsonObject obj = null;
        try {
            class_3298 resource = manager.method_14486(location);
            if (resource != null) {
                InputStream stream = resource.method_14482();
                InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);
                obj = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
                reader.close();
                stream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return obj;
    }

    public static JsonElement loadJson(File jsonFile) {
        if (jsonFile.exists()) {
            JsonElement jsonElement;
            FileReader reader = new FileReader(jsonFile, StandardCharsets.UTF_8);
            try {
                jsonElement = JsonFactory.loadJson(reader);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((Reader)reader).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    BCLib.LOGGER.catching(ex);
                }
            }
            ((Reader)reader).close();
            return jsonElement;
        }
        return null;
    }

    public static JsonElement loadJson(Reader reader) {
        return (JsonElement)GSON.fromJson(reader, JsonElement.class);
    }

    public static void storeJson(File jsonFile, JsonElement jsonObject) {
        try (FileWriter writer = new FileWriter(jsonFile, StandardCharsets.UTF_8);){
            String json = GSON.toJson(jsonObject);
            writer.write(json);
            writer.flush();
        }
        catch (IOException ex) {
            BCLib.LOGGER.catching(ex);
        }
    }

    public static void storeJson(OutputStream outStream, JsonElement jsonObject) {
        OutputStreamWriter writer = new OutputStreamWriter(outStream, StandardCharsets.UTF_8);
        GSON.toJson(jsonObject, (Appendable)writer);
        try {
            writer.flush();
        }
        catch (IOException e) {
            BCLib.LOGGER.error(e.getMessage());
            e.printStackTrace();
        }
    }

    public static int getInt(JsonObject object, String member, int def) {
        JsonElement elem = object.get(member);
        return elem == null ? def : elem.getAsInt();
    }

    public static float getFloat(JsonObject object, String member, float def) {
        JsonElement elem = object.get(member);
        return elem == null ? def : elem.getAsFloat();
    }

    public static boolean getBoolean(JsonObject object, String member, boolean def) {
        JsonElement elem = object.get(member);
        return elem == null ? def : elem.getAsBoolean();
    }

    public static String getString(JsonObject object, String member, String def) {
        JsonElement elem = object.get(member);
        return elem == null ? def : elem.getAsString();
    }
}

