/*
 * Decompiled with CFR 0.152.
 */
package ru.bclib.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1831;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2522;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3956;
import net.minecraft.class_6862;
import ru.bclib.BCLib;
import ru.bclib.api.tag.CommonItemTags;
import ru.bclib.config.PathConfig;
import ru.bclib.interfaces.UnknownReceipBookCategory;
import ru.bclib.recipes.BCLRecipeManager;
import ru.bclib.util.ItemUtil;
import ru.bclib.util.RecipeHelper;

public class AnvilRecipe
implements class_1860<class_1263>,
UnknownReceipBookCategory {
    public static final String GROUP = "smithing";
    public static final class_3956<AnvilRecipe> TYPE = BCLRecipeManager.registerType("bclib", "smithing");
    public static final Serializer SERIALIZER = BCLRecipeManager.registerSerializer("bclib", "smithing", new Serializer());
    public static final class_2960 ID = BCLib.makeID("smithing");
    private final class_2960 id;
    private final class_1856 input;
    private final class_1799 output;
    private final int damage;
    private final int toolLevel;
    private final int anvilLevel;
    private final int inputCount;

    public static void register() {
    }

    public AnvilRecipe(class_2960 identifier, class_1856 input, class_1799 output, int inputCount, int toolLevel, int anvilLevel, int damage) {
        this.id = identifier;
        this.input = input;
        this.output = output;
        this.toolLevel = toolLevel;
        this.anvilLevel = anvilLevel;
        this.inputCount = inputCount;
        this.damage = damage;
    }

    public static Builder create(String id) {
        return AnvilRecipe.create(BCLib.makeID(id));
    }

    public static Builder create(class_2960 id) {
        Builder.INSTANCE.id = id;
        Builder.INSTANCE.input = null;
        Builder.INSTANCE.output = null;
        Builder.INSTANCE.inputCount = 1;
        Builder.INSTANCE.toolLevel = 1;
        Builder.INSTANCE.anvilLevel = 1;
        Builder.INSTANCE.damage = 1;
        Builder.INSTANCE.alright = true;
        Builder.INSTANCE.exist = true;
        return Builder.INSTANCE;
    }

    public class_1865<?> method_8119() {
        return SERIALIZER;
    }

    public class_1799 method_8110() {
        return this.output;
    }

    public boolean method_8115(class_1263 craftingInventory, class_1937 world) {
        return this.matches(craftingInventory);
    }

    public class_1799 method_8116(class_1263 craftingInventory) {
        return this.output.method_7972();
    }

    public class_1799 craft(class_1263 craftingInventory, class_1657 player) {
        if (!player.method_7337()) {
            if (!this.checkHammerDurability(craftingInventory, player)) {
                return class_1799.field_8037;
            }
            class_1799 hammer = craftingInventory.method_5438(1);
            hammer.method_7956(this.damage, (class_1309)player, entity -> entity.method_20236((class_1268)null));
        }
        return this.method_8116(craftingInventory);
    }

    public boolean checkHammerDurability(class_1263 craftingInventory, class_1657 player) {
        if (player.method_7337()) {
            return true;
        }
        class_1799 hammer = craftingInventory.method_5438(1);
        int damage = hammer.method_7919() + this.damage;
        return damage < hammer.method_7936();
    }

    public boolean matches(class_1263 craftingInventory) {
        class_1799 hammer = craftingInventory.method_5438(1);
        if (hammer.method_7960() || !hammer.method_31573(CommonItemTags.HAMMERS)) {
            return false;
        }
        class_1799 material = craftingInventory.method_5438(0);
        int materialCount = material.method_7947();
        int level = ((class_1831)hammer.method_7909()).method_8022().method_8024();
        return this.input.method_8093(craftingInventory.method_5438(0)) && materialCount >= this.inputCount && level >= this.toolLevel;
    }

    public int getDamage() {
        return this.damage;
    }

    public int getInputCount() {
        return this.inputCount;
    }

    public int getAnvilLevel() {
        return this.anvilLevel;
    }

    public class_2371<class_1856> method_8117() {
        class_2371 defaultedList = class_2371.method_10211();
        defaultedList.add((Object)class_1856.method_26964(class_2378.field_11142.method_10220().filter(item -> item.method_40131().method_40220(CommonItemTags.HAMMERS)).filter(hammer -> ((class_1831)hammer).method_8022().method_8024() >= this.toolLevel).map(class_1799::new)));
        defaultedList.add((Object)this.input);
        return defaultedList;
    }

    @Environment(value=EnvType.CLIENT)
    public boolean method_8113(int width, int height) {
        return true;
    }

    public class_2960 method_8114() {
        return this.id;
    }

    public class_3956<?> method_17716() {
        return TYPE;
    }

    public boolean method_8118() {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnvilRecipe that = (AnvilRecipe)o;
        return this.damage == that.damage && this.toolLevel == that.toolLevel && this.id.equals((Object)that.id) && this.input.equals(that.input) && this.output.equals(that.output);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.input, this.output, this.damage, this.toolLevel);
    }

    public String toString() {
        return "AnvilRecipe [" + this.id + "]";
    }

    public static class Builder {
        private static final Builder INSTANCE = new Builder();
        private class_2960 id;
        private class_1856 input;
        private class_1799 output;
        private int inputCount = 1;
        private int toolLevel = 1;
        private int anvilLevel = 1;
        private int damage = 1;
        private boolean alright;
        private boolean exist;

        private Builder() {
        }

        public Builder setInput(class_1935 ... inputItems) {
            this.alright &= RecipeHelper.exists(inputItems);
            this.setInput(class_1856.method_8091((class_1935[])inputItems));
            return this;
        }

        public Builder setInput(class_6862<class_1792> inputTag) {
            this.setInput(class_1856.method_8106(inputTag));
            return this;
        }

        public Builder setInput(class_1856 ingredient) {
            this.input = ingredient;
            return this;
        }

        public Builder setInputCount(int count) {
            this.inputCount = count;
            return this;
        }

        public Builder setOutput(class_1935 output) {
            return this.setOutput(output, 1);
        }

        public Builder setOutput(class_1935 output, int amount) {
            this.alright &= RecipeHelper.exists(output);
            this.output = new class_1799(output, amount);
            return this;
        }

        public Builder setToolLevel(int level) {
            this.toolLevel = level;
            return this;
        }

        public Builder setAnvilLevel(int level) {
            this.anvilLevel = level;
            return this;
        }

        public Builder setDamage(int damage) {
            this.damage = damage;
            return this;
        }

        public Builder checkConfig(PathConfig config) {
            this.exist &= config.getBoolean("anvil", this.id.method_12832(), true);
            return this;
        }

        public void build() {
            if (!this.exist) {
                return;
            }
            if (this.input == null) {
                BCLib.LOGGER.warning("Input for Anvil recipe can't be 'null', recipe {} will be ignored!", this.id);
                return;
            }
            if (this.output == null) {
                BCLib.LOGGER.warning("Output for Anvil recipe can't be 'null', recipe {} will be ignored!", this.id);
                return;
            }
            if (BCLRecipeManager.getRecipe(TYPE, this.id) != null) {
                BCLib.LOGGER.warning("Can't add Anvil recipe! Id {} already exists!", this.id);
                return;
            }
            if (!this.alright) {
                BCLib.LOGGER.debug("Can't add Anvil recipe {}! Ingeredient or output not exists.", this.id);
                return;
            }
            BCLRecipeManager.addRecipe(TYPE, new AnvilRecipe(this.id, this.input, this.output, this.inputCount, this.toolLevel, this.anvilLevel, this.damage));
        }
    }

    public static class Serializer
    implements class_1865<AnvilRecipe> {
        public AnvilRecipe fromJson(class_2960 id, JsonObject json) {
            class_1856 input = class_1856.method_8102((JsonElement)json.get("input"));
            JsonObject result = class_3518.method_15296((JsonObject)json, (String)"result");
            class_1799 output = ItemUtil.fromJsonRecipe(result);
            if (output == null) {
                throw new IllegalStateException("Output item does not exists!");
            }
            if (result.has("nbt")) {
                try {
                    String nbtData = class_3518.method_15265((JsonObject)result, (String)"nbt");
                    class_2487 nbt = class_2522.method_10718((String)nbtData);
                    output.method_7980(nbt);
                }
                catch (CommandSyntaxException ex) {
                    BCLib.LOGGER.warning("Error parse nbt data for output.", new Object[]{ex});
                }
            }
            int inputCount = class_3518.method_15282((JsonObject)json, (String)"inputCount", (int)1);
            int toolLevel = class_3518.method_15282((JsonObject)json, (String)"toolLevel", (int)1);
            int anvilLevel = class_3518.method_15282((JsonObject)json, (String)"anvilLevel", (int)1);
            int damage = class_3518.method_15282((JsonObject)json, (String)"damage", (int)1);
            return new AnvilRecipe(id, input, output, inputCount, toolLevel, anvilLevel, damage);
        }

        public AnvilRecipe fromNetwork(class_2960 id, class_2540 packetBuffer) {
            class_1856 input = class_1856.method_8086((class_2540)packetBuffer);
            class_1799 output = packetBuffer.method_10819();
            int inputCount = packetBuffer.method_10816();
            int toolLevel = packetBuffer.method_10816();
            int anvilLevel = packetBuffer.method_10816();
            int damage = packetBuffer.method_10816();
            return new AnvilRecipe(id, input, output, inputCount, toolLevel, anvilLevel, damage);
        }

        public void toNetwork(class_2540 packetBuffer, AnvilRecipe recipe) {
            recipe.input.method_8088(packetBuffer);
            packetBuffer.method_10793(recipe.output);
            packetBuffer.method_10804(recipe.inputCount);
            packetBuffer.method_10804(recipe.toolLevel);
            packetBuffer.method_10804(recipe.anvilLevel);
            packetBuffer.method_10804(recipe.damage);
        }
    }
}

