/*
 * Decompiled with CFR 0.152.
 */
package ru.bclib.mixin.common;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import net.minecraft.class_32;
import net.minecraft.class_3807;
import net.minecraft.server.Main;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import ru.bclib.api.LifeCycleAPI;
import ru.bclib.api.datafixer.DataFixerAPI;

@Mixin(value={Main.class})
public abstract class MainMixin {
    @Inject(method={"main"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/storage/LevelStorageSource;createDefault(Ljava/nio/file/Path;)Lnet/minecraft/world/level/storage/LevelStorageSource;")})
    private static void bclib_callServerFix(String[] args, CallbackInfo ci) {
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec optionUniverse = parser.accepts("universe").withRequiredArg().defaultsTo((Object)".", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec optionWorld = parser.accepts("world").withRequiredArg();
        parser.accepts("nogui");
        parser.accepts("initSettings", "Initializes 'server.properties' and 'eula.txt', then quits");
        parser.accepts("demo");
        parser.accepts("bonusChest");
        parser.accepts("forceUpgrade");
        parser.accepts("eraseCache");
        parser.accepts("safeMode", "Loads level with vanilla datapack only");
        parser.accepts("help").forHelp();
        parser.accepts("singleplayer").withRequiredArg();
        parser.accepts("port").withRequiredArg().ofType(Integer.class).defaultsTo((Object)-1, (Object[])new Integer[0]);
        parser.accepts("serverId").withRequiredArg();
        parser.accepts("jfrProfile");
        parser.nonOptions();
        OptionSet options = parser.parse(args);
        Path settingPath = Paths.get("server.properties", new String[0]);
        class_3807 settings = new class_3807(settingPath);
        File file = new File((String)options.valueOf((OptionSpec)optionUniverse));
        String levelID = Optional.ofNullable((String)options.valueOf((OptionSpec)optionWorld)).orElse(settings.method_16717().field_16820);
        class_32 levelStorageSource = class_32.method_26999((Path)file.toPath());
        DataFixerAPI.fixData(levelStorageSource, levelID, false, didFix -> {});
        LifeCycleAPI._runBeforeLevelLoad();
    }
}

