/*
 * Decompiled with CFR 0.152.
 */
package ru.bclib.gui.screens;

import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_3536;
import net.minecraft.class_437;
import org.jetbrains.annotations.Nullable;
import ru.bclib.gui.gridlayout.GridColumn;
import ru.bclib.gui.gridlayout.GridLayout;
import ru.bclib.gui.gridlayout.GridMessageCell;
import ru.bclib.gui.gridlayout.GridRow;
import ru.bclib.gui.gridlayout.GridScreen;
import ru.bclib.gui.gridlayout.GridStringCell;
import ru.bclib.gui.screens.AtomicProgressListener;
import ru.bclib.gui.screens.ProgressLogoRender;

public class ProgressScreen
extends GridScreen
implements class_3536,
AtomicProgressListener {
    static final class_2960 BCLIB_LOGO_PIXELATED_LOCATION = new class_2960("bclib", "iconpixelated.png");
    class_2561 description;
    private class_2561 stageComponent;
    private GridMessageCell stage;
    private GridStringCell progress;
    private ProgressLogoRender progressImage;
    private int currentProgress = 0;
    private AtomicInteger atomicCounter;

    public ProgressScreen(@Nullable class_437 parent, class_2561 title, class_2561 description) {
        super(parent, title, 20, true);
        this.description = description;
    }

    @Override
    public void incAtomic(int maxProgress) {
        if (this.atomicCounter != null) {
            this.method_15410(100 * this.atomicCounter.incrementAndGet() / maxProgress);
        }
    }

    @Override
    public void resetAtomic() {
        this.method_15410(0);
        this.atomicCounter = new AtomicInteger(0);
    }

    public boolean method_25422() {
        return false;
    }

    public class_2561 getProgressComponent() {
        return this.getProgressComponent(this.currentProgress);
    }

    private class_2561 getProgressComponent(int pg) {
        return new class_2588("title.bclib.progress").method_27693(": " + pg + "%");
    }

    @Override
    protected void initLayout() {
        this.grid.addSpacerRow();
        GridRow row = this.grid.addRow(GridLayout.VerticalAlignment.CENTER);
        row.addFiller();
        this.progressImage = new ProgressLogoRender();
        this.progressImage.percentage = (float)this.currentProgress / 100.0f;
        row.addCustomRender(this.progressImage);
        row.addSpacer();
        int textWidth = Math.max(this.getWidth(this.description), this.getWidth(this.getProgressComponent(100)));
        GridColumn textCol = row.addColumn(0.0, GridLayout.GridValueType.INHERIT);
        textCol.addRow().addString(this.description, this);
        textCol.addSpacerRow();
        this.progress = textCol.addRow().addString(this.getProgressComponent(), -8421505, GridLayout.Alignment.LEFT, this);
        row.addFiller();
        this.grid.addSpacerRow(20);
        row = this.grid.addRow();
        this.stage = row.addMessage((class_2561)(this.stageComponent != null ? this.stageComponent : new class_2585("")), this.field_22793, GridLayout.Alignment.CENTER);
    }

    public void method_15412(class_2561 text) {
        this.method_15414(text);
    }

    public void method_15413(class_2561 text) {
        this.method_15414(text);
        this.method_15410(0);
    }

    @Override
    public void method_15414(class_2561 text) {
        this.stageComponent = text;
        if (this.stage != null) {
            this.stage.setText(text);
        }
    }

    public void method_15410(int progress) {
        if (progress != this.currentProgress) {
            this.currentProgress = progress;
            if (this.progressImage != null) {
                this.progressImage.percentage = (float)this.currentProgress / 100.0f;
            }
            if (this.progress != null) {
                this.progress.setText(this.getProgressComponent());
            }
        }
    }

    @Override
    public void method_15411() {
    }
}

