/*
 * Decompiled with CFR 0.152.
 */
package ru.bclib.gui.gridlayout;

import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_4185;
import ru.bclib.gui.gridlayout.GridCell;
import ru.bclib.gui.gridlayout.GridCellDefinition;
import ru.bclib.gui.gridlayout.GridCheckboxCell;
import ru.bclib.gui.gridlayout.GridColumn;
import ru.bclib.gui.gridlayout.GridContainer;
import ru.bclib.gui.gridlayout.GridCustomRenderCell;
import ru.bclib.gui.gridlayout.GridElement;
import ru.bclib.gui.gridlayout.GridImageCell;
import ru.bclib.gui.gridlayout.GridLayout;
import ru.bclib.gui.gridlayout.GridMessageCell;
import ru.bclib.gui.gridlayout.GridScreen;
import ru.bclib.gui.gridlayout.GridStringCell;
import ru.bclib.gui.gridlayout.GridTransform;

@Environment(value=EnvType.CLIENT)
public class GridRow
extends GridContainer {
    public final GridLayout.VerticalAlignment alignment;

    GridRow(double width) {
        this(width, GridLayout.VerticalAlignment.TOP);
    }

    GridRow(double width, GridLayout.GridValueType widthType) {
        this(width, widthType, GridLayout.VerticalAlignment.CENTER);
    }

    GridRow(double width, GridLayout.VerticalAlignment alignment) {
        super(width);
        this.alignment = alignment;
    }

    GridRow(double width, GridLayout.GridValueType widthType, GridLayout.VerticalAlignment alignment) {
        super(width, widthType);
        this.alignment = alignment;
    }

    public GridColumn addColumn(double width, GridLayout.GridValueType widthType) {
        GridColumn cell = new GridColumn(width, widthType);
        this.cells.add(cell);
        return cell;
    }

    public GridCell addComponent(double height, Function<GridTransform, Object> componentPlacer) {
        return this.addComponent(1.0, GridLayout.GridValueType.PERCENTAGE, height, componentPlacer);
    }

    public GridCell addComponent(double width, GridLayout.GridValueType widthType, double height, Function<GridTransform, Object> componentPlacer) {
        GridCell cell = new GridCell(width, height, widthType, componentPlacer, null);
        this.cells.add(cell);
        return cell;
    }

    public GridCell addButton(class_2561 text, double height, class_4185.class_4241 onPress) {
        return this.addButton(text, 1.0, GridLayout.GridValueType.PERCENTAGE, height, onPress);
    }

    public GridCell addButton(class_2561 text, float alpha, double height, class_4185.class_4241 onPress) {
        return this.addButton(text, alpha, 1.0, GridLayout.GridValueType.PERCENTAGE, height, onPress);
    }

    public GridCell addButton(class_2561 text, double height, class_327 font, class_4185.class_4241 onPress) {
        return this.addButton(text, 1.0f, height, font, onPress);
    }

    public GridCell addButton(class_2561 text, float alpha, double height, class_327 font, class_4185.class_4241 onPress) {
        int width = font.method_30880(text.method_30937()) + 24;
        return this.addButton(text, alpha, width, GridLayout.GridValueType.CONSTANT, height, onPress);
    }

    public GridCell addButton(class_2561 text, double width, GridLayout.GridValueType widthType, double height, class_4185.class_4241 onPress) {
        return this.addButton(text, 1.0f, width, widthType, height, onPress);
    }

    public GridCell addButton(class_2561 text, float alpha, double width, GridLayout.GridValueType widthType, double height, class_4185.class_4241 onPress) {
        GridCell cell = new GridCell(width, height, widthType, transform -> {
            class_4185 customButton = new class_4185(transform.left, transform.top, transform.width, transform.height, text, onPress);
            customButton.method_25350(alpha);
            return customButton;
        }, null);
        this.cells.add(cell);
        return cell;
    }

    public GridCheckboxCell addCheckbox(class_2561 text, boolean checked, class_327 font, Consumer<Boolean> onChange) {
        int width = font.method_30880(text.method_30937()) + 24 + 24;
        GridCheckboxCell cell = new GridCheckboxCell(text, checked, 1.0f, width, this.widthType, 20.0, onChange);
        this.cells.add(cell);
        return cell;
    }

    public GridCheckboxCell addCheckbox(class_2561 text, boolean checked, int height) {
        return this.addCheckbox(text, checked, 1.0f, height);
    }

    public GridCheckboxCell addCheckbox(class_2561 text, boolean checked, float alpha, int height) {
        return this.addCheckbox(text, checked, alpha, 1.0, GridLayout.GridValueType.PERCENTAGE, height);
    }

    public GridCheckboxCell addCheckbox(class_2561 text, boolean checked, int height, class_327 font) {
        return this.addCheckbox(text, checked, 1.0f, height, font);
    }

    public GridCheckboxCell addCheckbox(class_2561 text, boolean checked, float alpha, int height, class_327 font) {
        int width = font.method_30880(text.method_30937()) + 24 + 24;
        return this.addCheckbox(text, checked, alpha, width, GridLayout.GridValueType.CONSTANT, height);
    }

    public GridCheckboxCell addCheckbox(class_2561 text, boolean checked, double width, GridLayout.GridValueType widthType, int height) {
        return this.addCheckbox(text, checked, 1.0f, width, widthType, height);
    }

    public GridCheckboxCell addCheckbox(class_2561 text, boolean checked, float alpha, double width, GridLayout.GridValueType widthType, int height) {
        GridCheckboxCell cell = new GridCheckboxCell(text, checked, alpha, width, widthType, height);
        this.cells.add(cell);
        return cell;
    }

    public GridCustomRenderCell addCustomRender(GridCustomRenderCell cell) {
        this.cells.add(cell);
        return cell;
    }

    public GridCell addImage(class_2960 location, int width, int height) {
        return this.addImage(location, 1.0f, width, height);
    }

    public GridCell addImage(class_2960 location, float alpha, int width, int height) {
        return this.addImage(location, alpha, width, GridLayout.GridValueType.CONSTANT, height, 0, 0, width, height, width, height);
    }

    public GridCell addImage(class_2960 location, double width, GridLayout.GridValueType widthType, int height, int resourceWidth, int resourceHeight) {
        return this.addImage(location, 1.0f, width, widthType, height, resourceWidth, resourceHeight);
    }

    public GridCell addImage(class_2960 location, float alpha, double width, GridLayout.GridValueType widthType, int height, int resourceWidth, int resourceHeight) {
        return this.addImage(location, alpha, width, widthType, height, 0, 0, resourceWidth, resourceWidth, resourceWidth, resourceHeight);
    }

    public GridCell addImage(class_2960 location, double width, GridLayout.GridValueType widthType, int height, int uvLeft, int uvTop, int uvWidth, int uvHeight, int resourceWidth, int resourceHeight) {
        return this.addImage(location, 1.0f, width, widthType, height, uvLeft, uvTop, uvWidth, uvHeight, resourceWidth, resourceHeight);
    }

    public GridCell addImage(class_2960 location, float alpha, double width, GridLayout.GridValueType widthType, int height, int uvLeft, int uvTop, int uvWidth, int uvHeight, int resourceWidth, int resourceHeight) {
        GridImageCell cell = new GridImageCell(location, width, widthType, height, alpha, uvLeft, uvTop, uvWidth, uvHeight, resourceWidth, resourceHeight);
        this.cells.add(cell);
        return cell;
    }

    public GridColumn addFiller() {
        return this.addFiller(1.0f);
    }

    public GridColumn addFiller(float portion) {
        GridColumn cell = new GridColumn(portion, GridLayout.GridValueType.FILL);
        this.cells.add(cell);
        return cell;
    }

    public void addSpacer() {
        this.addSpacer(12);
    }

    public void addSpacer(int width) {
        GridCell cell = new GridCell(width, 0.0, GridLayout.GridValueType.CONSTANT, null, null);
        this.cells.add(cell);
    }

    public GridMessageCell addMessage(class_2561 text, class_327 font, GridLayout.Alignment contentAlignment) {
        return this.addMessage(text, font, -1, contentAlignment);
    }

    public GridMessageCell addMessage(class_2561 text, class_327 font, int color, GridLayout.Alignment contentAlignment) {
        return this.addMessage(text, 1.0, GridLayout.GridValueType.PERCENTAGE, font, color, contentAlignment);
    }

    public GridMessageCell addMessage(class_2561 text, double width, GridLayout.GridValueType widthType, class_327 font, GridLayout.Alignment contentAlignment) {
        return this.addMessage(text, width, widthType, font, -1, contentAlignment);
    }

    public GridMessageCell addMessage(class_2561 text, double width, GridLayout.GridValueType widthType, class_327 font, int color, GridLayout.Alignment contentAlignment) {
        GridMessageCell cell = new GridMessageCell(width, widthType, contentAlignment, font, text, color);
        this.cells.add(cell);
        return cell;
    }

    public GridStringCell addString(class_2561 text, GridScreen parent) {
        return this.addString(text, -1, parent);
    }

    public GridStringCell addString(class_2561 text, int color, GridScreen parent) {
        int width = parent.getWidth(text);
        return this.addString(text, width, GridLayout.GridValueType.CONSTANT, color, GridLayout.Alignment.CENTER, parent);
    }

    public GridStringCell addString(class_2561 text, GridLayout.Alignment contentAlignment, GridScreen parent) {
        return this.addString(text, -1, contentAlignment, parent);
    }

    public GridStringCell addString(class_2561 text, int color, GridLayout.Alignment contentAlignment, GridScreen parent) {
        return this.addString(text, 1.0, GridLayout.GridValueType.PERCENTAGE, color, contentAlignment, parent);
    }

    public GridStringCell addString(class_2561 text, double width, GridLayout.GridValueType widthType, GridLayout.Alignment contentAlignment, GridScreen parent) {
        return this.addString(text, width, widthType, -1, contentAlignment, parent);
    }

    public GridStringCell addString(class_2561 text, double width, GridLayout.GridValueType widthType, int color, GridLayout.Alignment contentAlignment, GridScreen parent) {
        Objects.requireNonNull(parent.getFont());
        GridStringCell cell = new GridStringCell(width, widthType, 9, contentAlignment, parent, text, color);
        this.cells.add(cell);
        return cell;
    }

    @Override
    protected GridElement buildElementAt(int inLeft, int top, int width, List<GridElement> collector) {
        int height = 0;
        int left = inLeft;
        if (this.widthType == GridLayout.GridValueType.INHERIT) {
            int originalWidth = width;
            width = this.cells.stream().filter(row -> row.widthType == GridLayout.GridValueType.CONSTANT || row.widthType == GridLayout.GridValueType.INHERIT).map(row -> row.buildElement((int)0, (int)0, (float)1.0f, (int)0, (int)0, null).width).reduce(0, (p, c) -> p + c);
        }
        int inheritedWidth = width;
        int fixedWidth = this.cells.stream().filter(col -> col.widthType != GridLayout.GridValueType.FILL).map(col -> col.calculateWidth(inheritedWidth)).reduce(0, (p, c) -> p + c);
        float autoWidthSum = this.cells.stream().filter(col -> col.widthType == GridLayout.GridValueType.FILL).map(col -> Float.valueOf(col.width)).reduce(Float.valueOf(0.0f), (p, c) -> Float.valueOf(p.floatValue() + c.floatValue())).floatValue();
        int autoWidth = width - fixedWidth;
        if (this.alignment == GridLayout.VerticalAlignment.TOP) {
            for (GridCellDefinition col2 : this.cells) {
                GridElement element = col2.buildElement(width, autoWidth, autoWidthSum, left, top, collector);
                left += element.width;
                height = Math.max(height, element.height);
            }
        } else {
            GridElement element;
            HashMap<GridCellDefinition, GridElement> cache = new HashMap<GridCellDefinition, GridElement>();
            for (GridCellDefinition col3 : this.cells) {
                element = col3.buildElement(width, autoWidth, autoWidthSum, left, top, null);
                left += element.width;
                height = Math.max(height, element.height);
                cache.put(col3, element);
            }
            left = inLeft;
            for (GridCellDefinition col3 : this.cells) {
                element = (GridElement)cache.get(col3);
                int topOffset = this.alignment == GridLayout.VerticalAlignment.BOTTOM ? height - element.height : height - element.height >> 1;
                element = col3.buildElement(width, autoWidth, autoWidthSum, left, top + topOffset, collector);
                left += element.width;
            }
        }
        return new GridElement(inLeft, top, width, height);
    }
}

