/*
 * Decompiled with CFR 0.152.
 */
package ru.bclib.gui.gridlayout;

import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import ru.bclib.gui.gridlayout.GridCell;
import ru.bclib.gui.gridlayout.GridCellDefinition;
import ru.bclib.gui.gridlayout.GridContainer;
import ru.bclib.gui.gridlayout.GridElement;
import ru.bclib.gui.gridlayout.GridLayout;
import ru.bclib.gui.gridlayout.GridRow;

@Environment(value=EnvType.CLIENT)
public class GridColumn
extends GridContainer {
    GridColumn(double width) {
        super(width);
    }

    GridColumn(double width, GridLayout.GridValueType widthType) {
        super(width, widthType);
    }

    public GridRow addRow() {
        return this.addRow(GridLayout.VerticalAlignment.TOP);
    }

    public GridRow addRow(GridLayout.VerticalAlignment align) {
        GridRow row = new GridRow(1.0, this.widthType == GridLayout.GridValueType.INHERIT ? GridLayout.GridValueType.INHERIT : GridLayout.GridValueType.PERCENTAGE, align);
        this.cells.add(row);
        return row;
    }

    public void addSpacerRow() {
        this.addSpacerRow(4);
    }

    public void addSpacerRow(int height) {
        GridCell cell = new GridCell(1.0, height, GridLayout.GridValueType.PERCENTAGE, null, null);
        this.cells.add(cell);
    }

    @Override
    public int calculateWidth(int parentWidth) {
        if (this.widthType == GridLayout.GridValueType.INHERIT) {
            return this.cells.stream().filter(row -> row.widthType == GridLayout.GridValueType.INHERIT).map(row -> row.buildElement((int)0, (int)0, (float)1.0f, (int)0, (int)0, null).width).reduce(0, (p, c) -> Math.max(p, c));
        }
        return super.calculateWidth(parentWidth);
    }

    @Override
    protected GridElement buildElementAt(int left, int inTop, int width, List<GridElement> collector) {
        int height = 0;
        int top = inTop;
        if (this.widthType == GridLayout.GridValueType.INHERIT) {
            width = this.calculateWidth(width);
        }
        for (GridCellDefinition row : this.cells) {
            GridElement element = row.buildElement(width, 0, 1.0f, left, top, collector);
            top += element.height;
            height += element.height;
        }
        return new GridElement(left, inTop, width, height);
    }
}

