/*
 * Decompiled with CFR 0.152.
 */
package ru.bclib.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.nio.file.Path;
import net.fabricmc.loader.api.FabricLoader;
import ru.bclib.util.JsonFactory;

public class ConfigWriter {
    private static final Path GAME_CONFIG_DIR = FabricLoader.getInstance().getConfigDir();
    private final File configFile;
    private JsonObject configObject;

    public ConfigWriter(String modID, String configFile) {
        this.configFile = new File(GAME_CONFIG_DIR.resolve(modID).toFile(), configFile + ".json");
        File parent = this.configFile.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        this.load();
    }

    File getConfigFile() {
        return this.configFile;
    }

    public JsonObject getConfig() {
        return this.configObject;
    }

    public void save() {
        if (this.configObject == null) {
            return;
        }
        ConfigWriter.save(this.configFile, (JsonElement)this.configObject);
    }

    JsonObject reload() {
        this.configObject = ConfigWriter.load(this.configFile);
        return this.configObject;
    }

    public JsonObject load() {
        if (this.configObject == null) {
            this.configObject = ConfigWriter.load(this.configFile);
        }
        return this.configObject;
    }

    public void save(JsonElement config) {
        this.configObject = config.getAsJsonObject();
        ConfigWriter.save(this.configFile, config);
    }

    public static JsonObject load(File configFile) {
        return JsonFactory.getJsonObject(configFile);
    }

    public static void save(File configFile, JsonElement config) {
        JsonFactory.storeJson(configFile, config);
    }

    public static String scrubFileName(String input) {
        input = input.replaceAll("[/\\ ]+", "_");
        input = input.replaceAll("[,:&\"\\|\\<\\>\\?\\*]", "_");
        return input;
    }
}

