/*
 * Decompiled with CFR 0.152.
 */
package ru.bclib.config;

import java.lang.invoke.CallSite;
import java.util.Arrays;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import ru.bclib.util.Pair;

public class ConfigKey {
    private final String[] path;
    private final String entry;
    private final boolean root;

    public ConfigKey(String entry, String ... path) {
        this.validate(entry);
        this.path = path;
        this.entry = entry;
        this.root = path.length == 0 || path.length == 1 && path[0].isEmpty();
    }

    public ConfigKey(String entry, class_2960 path) {
        this(entry, path.method_12836(), path.method_12832());
    }

    public String[] getPath() {
        return this.path;
    }

    public String getEntry() {
        return this.entry;
    }

    public boolean isRoot() {
        return this.root;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.path);
        result = 31 * result + this.entry.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ConfigKey)) {
            return false;
        }
        ConfigKey other = (ConfigKey)obj;
        if (other.path.length != this.path.length) {
            return false;
        }
        for (int i = 0; i < this.path.length; ++i) {
            if (this.path[i].equals(other.path[i])) continue;
            return false;
        }
        return this.entry.equals(other.entry);
    }

    public String toString() {
        if (this.root) {
            return String.format("[root]:%s", this.entry);
        }
        Object p = this.path[0];
        for (int i = 1; i < this.path.length; ++i) {
            p = (String)p + "." + this.path[i];
        }
        return String.format("%s:%s", p, this.entry);
    }

    private void validate(String entry) {
        if (entry == null) {
            throw new NullPointerException("Config key must be not null!");
        }
        if (entry.isEmpty()) {
            throw new IndexOutOfBoundsException("Config key must be not empty!");
        }
    }

    public static Pair<String, String> realKey(@NotNull String key) {
        String[] parts = key.split("\\[default:", 2);
        if (parts.length == 1) {
            return new Pair<String, String>(parts[0].trim(), "");
        }
        if (parts.length == 2) {
            return new Pair<String, CallSite>(parts[0].trim(), (CallSite)((Object)(" " + ("[default:" + parts[1]).trim())));
        }
        return new Pair<String, String>(key, "");
    }
}

